/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.raw.slicing;

import java.util.function.Consumer;
import org.openstreetmap.atlas.utilities.statistic.storeless.CounterWithStatistic;
import org.slf4j.Logger;

public class RawAtlasSlicingStatistic {
    private static final long LOG_FREQUENCY = 10000L;
    private final Logger logger;
    private final CounterWithStatistic lines;
    private final CounterWithStatistic points;
    private final CounterWithStatistic relations;
    private final CounterWithStatistic slicedLines;
    private final CounterWithStatistic slicedRelations;
    private final CounterWithStatistic skippedLines;
    private final CounterWithStatistic skipedRelations;

    public RawAtlasSlicingStatistic(Logger logger) {
        this.logger = logger;
        Consumer<String> log = arg_0 -> ((Logger)logger).info(arg_0);
        this.points = new CounterWithStatistic(this.logger, 10000L, "Processed Point");
        this.points.logUsingLevel(log);
        this.lines = new CounterWithStatistic(this.logger, 10000L, "Processed Line");
        this.lines.logUsingLevel(log);
        this.relations = new CounterWithStatistic(this.logger, 10000L, "Processed Relation");
        this.relations.logUsingLevel(log);
        this.slicedLines = new CounterWithStatistic(this.logger, 10000L, "Sliced Line");
        this.slicedLines.logUsingLevel(log);
        this.slicedRelations = new CounterWithStatistic(this.logger, 10000L, "Sliced Relation");
        this.slicedRelations.logUsingLevel(log);
        this.skippedLines = new CounterWithStatistic(this.logger, 10000L, "Skipped Line");
        this.skippedLines.logUsingLevel(log);
        this.skipedRelations = new CounterWithStatistic(this.logger, 10000L, "Skipped Relation");
        this.skipedRelations.logUsingLevel(log);
    }

    public void recordProcessedLine() {
        this.lines.increment();
    }

    public void recordProcessedPoint() {
        this.points.increment();
    }

    public void recordProcessedRelation() {
        this.relations.increment();
    }

    public void recordSkippedLine() {
        this.skippedLines.increment();
    }

    public void recordSkippedRelation() {
        this.skipedRelations.increment();
    }

    public void recordSlicedLine() {
        this.slicedLines.increment();
    }

    public void recordSlicedRelation() {
        this.slicedRelations.increment();
    }

    public void summary() {
        this.logger.trace("Raw Atlas Country Slicing Summary");
        this.points.summaryWithoutTimer();
        this.lines.summaryWithoutTimer();
        this.relations.summaryWithoutTimer();
        this.slicedLines.summaryWithoutTimer();
        this.slicedRelations.summaryWithoutTimer();
        this.skippedLines.summaryWithoutTimer();
        this.skipedRelations.summaryWithoutTimer();
    }
}

