/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.raw.slicing;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.geography.Location;
import org.openstreetmap.atlas.geography.PolyLine;
import org.openstreetmap.atlas.geography.Polygon;
import org.openstreetmap.atlas.geography.atlas.Atlas;
import org.openstreetmap.atlas.geography.atlas.items.AtlasEntity;
import org.openstreetmap.atlas.geography.atlas.items.ItemType;
import org.openstreetmap.atlas.geography.atlas.items.Line;
import org.openstreetmap.atlas.geography.atlas.items.LineItem;
import org.openstreetmap.atlas.geography.atlas.items.Point;
import org.openstreetmap.atlas.geography.atlas.items.Relation;
import org.openstreetmap.atlas.geography.atlas.items.RelationMember;
import org.openstreetmap.atlas.geography.atlas.pbf.AtlasLoadingOption;
import org.openstreetmap.atlas.geography.atlas.pbf.slicing.identifier.CountrySlicingIdentifierFactory;
import org.openstreetmap.atlas.geography.atlas.pbf.slicing.identifier.ReverseIdentifierFactory;
import org.openstreetmap.atlas.geography.atlas.raw.slicing.CoordinateToNewPointMapping;
import org.openstreetmap.atlas.geography.atlas.raw.slicing.RawAtlasSlicer;
import org.openstreetmap.atlas.geography.atlas.raw.slicing.changeset.ChangeSetHandler;
import org.openstreetmap.atlas.geography.atlas.raw.slicing.changeset.RelationChangeSet;
import org.openstreetmap.atlas.geography.atlas.raw.slicing.changeset.RelationChangeSetHandler;
import org.openstreetmap.atlas.geography.atlas.raw.temporary.TemporaryEntity;
import org.openstreetmap.atlas.geography.atlas.raw.temporary.TemporaryLine;
import org.openstreetmap.atlas.geography.atlas.raw.temporary.TemporaryPoint;
import org.openstreetmap.atlas.geography.atlas.raw.temporary.TemporaryRelation;
import org.openstreetmap.atlas.geography.atlas.raw.temporary.TemporaryRelationMember;
import org.openstreetmap.atlas.geography.atlas.sub.AtlasCutType;
import org.openstreetmap.atlas.geography.boundary.CountryBoundaryMap;
import org.openstreetmap.atlas.geography.converters.jts.JtsUtility;
import org.openstreetmap.atlas.geography.sharding.Shard;
import org.openstreetmap.atlas.tags.RelationTypeTag;
import org.openstreetmap.atlas.tags.SyntheticBoundaryNodeTag;
import org.openstreetmap.atlas.tags.Taggable;
import org.openstreetmap.atlas.tags.annotations.validation.Validators;
import org.openstreetmap.atlas.utilities.collections.Iterables;
import org.openstreetmap.atlas.utilities.collections.MultiIterable;
import org.openstreetmap.atlas.utilities.maps.MultiMap;
import org.openstreetmap.atlas.utilities.time.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RawAtlasRelationSlicer
extends RawAtlasSlicer {
    private static final Logger logger = LoggerFactory.getLogger(RawAtlasRelationSlicer.class);
    private final Shard initialShard;
    private final RelationChangeSet slicedRelationChanges;
    private final Set<Long> pointCandidatesForRemoval;

    private static boolean containsSlicedMember(Iterable<RelationMember> members) {
        for (RelationMember member : members) {
            if (new ReverseIdentifierFactory().getCountryCode(member.getEntity().getIdentifier()) == 0L) continue;
            return true;
        }
        return false;
    }

    public RawAtlasRelationSlicer(Atlas atlas, Shard initialShard, AtlasLoadingOption loadingOption) {
        super(loadingOption, new CoordinateToNewPointMapping(), atlas);
        this.initialShard = initialShard;
        this.slicedRelationChanges = new RelationChangeSet();
        this.pointCandidatesForRemoval = new HashSet<Long>();
    }

    @Override
    public Atlas slice() {
        Time time = Time.now();
        logger.info("Started Relation Slicing for Atlas {}", (Object)this.getShardOrAtlasName());
        this.sliceRelations();
        this.removeDeletedPoints();
        RelationChangeSetHandler relationChangeBuilder = new RelationChangeSetHandler(this.getStartingAtlas(), this.slicedRelationChanges);
        Atlas fullySlicedAtlas = ((ChangeSetHandler)relationChangeBuilder).applyChanges();
        logger.info("Finished Relation Slicing for Atlas {} in {}", (Object)this.getShardOrAtlasName(), (Object)time.elapsedSince());
        this.getStatistics().summary();
        return this.cutSubAtlasForOriginalShard(fullySlicedAtlas);
    }

    private List<LinearRing> buildRings(List<RelationMember> members, long relationIdentifier) {
        ArrayList<LinearRing> results = new ArrayList<LinearRing>();
        ArrayList<PolyLine> linePieces = new ArrayList<PolyLine>(members.size());
        for (RelationMember member : members) {
            Line line = this.getStartingAtlas().line(member.getEntity().getIdentifier());
            if (line == null) {
                throw new CoreException("Relation {} has a member {} that's not in the original Atlas {}", relationIdentifier, member.getEntity().getIdentifier(), this.getShardOrAtlasName());
            }
            linePieces.add(line.asPolyLine());
        }
        try {
            Iterable<Polygon> polygons = MULTIPLE_POLY_LINE_TO_POLYGON_CONVERTER.convert((Iterable<PolyLine>)linePieces);
            polygons.forEach(polygon -> results.add(JTS_LINEAR_RING_CONVERTER.convert((Polygon)polygon)));
        }
        catch (Exception e) {
            logger.error("One of the members for relation {} for Atlas {} is invalid and does not form a closed ring!", new Object[]{relationIdentifier, this.getShardOrAtlasName(), e});
        }
        return results;
    }

    private long[] createIdentifierSeeds(Relation relation) {
        long[] seeds = new long[relation.members().size()];
        long[] identifiers = new long[relation.members().size()];
        for (int seedIndex = 0; seedIndex < seeds.length; ++seedIndex) {
            long identifier;
            identifiers[seedIndex] = identifier = relation.members().get(seedIndex).getEntity().getIdentifier();
        }
        HashSet<Long> generatedIds = new HashSet<Long>();
        for (int seedIndex = 0; seedIndex < seeds.length; ++seedIndex) {
            long identifier = identifiers[seedIndex];
            CountrySlicingIdentifierFactory identifierFactory = new CountrySlicingIdentifierFactory(identifier);
            while (this.getStartingAtlas().line(identifier) != null || generatedIds.contains(identifier)) {
                identifier = identifierFactory.nextIdentifier();
            }
            seeds[seedIndex] = identifier;
            generatedIds.add(identifier);
        }
        return seeds;
    }

    private void createNewLineMemberForRelation(LineString lineString, long relationIdentifier, CountrySlicingIdentifierFactory pointIdentifierGenerator, CountrySlicingIdentifierFactory lineIdentifierGenerator) {
        ArrayList<Long> newLineShapePoints = new ArrayList<Long>(lineString.getNumPoints());
        Coordinate[] lineCoordinates = PRECISION_REDUCER.edit(lineString.getCoordinates(), lineString);
        if (this.isOutsideWorkingBound(lineString)) {
            return;
        }
        for (Coordinate pointCoordinate : lineCoordinates) {
            Location pointLocation = JTS_LOCATION_CONVERTER.backwardConvert(pointCoordinate);
            Iterable<Point> rawAtlasPointsAtCoordinate = this.getStartingAtlas().pointsAt(pointLocation);
            if (Iterables.isEmpty(rawAtlasPointsAtCoordinate)) {
                if (this.getCoordinateToPointMapping().containsCoordinate(pointCoordinate)) {
                    newLineShapePoints.add(this.getCoordinateToPointMapping().getPointForCoordinate(pointCoordinate));
                    continue;
                }
                Location scaledLocation = JTS_LOCATION_CONVERTER.backwardConvert(this.getCoordinateToPointMapping().getScaledCoordinate(pointCoordinate));
                Iterable<Point> rawAtlasPointsAtScaledCoordinate = this.getStartingAtlas().pointsAt(scaledLocation);
                if (Iterables.isEmpty(rawAtlasPointsAtScaledCoordinate)) {
                    Map<String, String> newPointTags = this.createPointTags(scaledLocation, false);
                    newPointTags.put("synthetic_boundary_node", SyntheticBoundaryNodeTag.YES.toString());
                    long newPointIdentifier = this.createNewPointIdentifier(pointIdentifierGenerator, pointCoordinate);
                    TemporaryPoint newPoint = new TemporaryPoint(newPointIdentifier, scaledLocation, newPointTags);
                    this.getCoordinateToPointMapping().storeMapping(pointCoordinate, newPoint.getIdentifier());
                    newLineShapePoints.add(newPoint.getIdentifier());
                    this.slicedRelationChanges.createPoint(newPoint);
                    continue;
                }
                for (Point rawAtlasPoint : rawAtlasPointsAtScaledCoordinate) {
                    newLineShapePoints.add(rawAtlasPoint.getIdentifier());
                }
                continue;
            }
            for (Point rawAtlasPoint : rawAtlasPointsAtCoordinate) {
                newLineShapePoints.add(rawAtlasPoint.getIdentifier());
            }
        }
        Map<String, String> newLineTags = RawAtlasRelationSlicer.createLineTags(lineString, new HashMap<String, String>());
        long newLineIdentifier = lineIdentifierGenerator.nextIdentifier();
        TemporaryLine newLine = new TemporaryLine(newLineIdentifier, newLineShapePoints, newLineTags);
        this.slicedRelationChanges.createLine(newLine);
        TemporaryRelationMember newOuterMember = new TemporaryRelationMember(newLine.getIdentifier(), "outer", ItemType.LINE);
        this.slicedRelationChanges.addRelationMember(relationIdentifier, newOuterMember);
        this.updateSyntheticRelationMemberTag(relationIdentifier, newLineIdentifier);
    }

    private long createNewPointIdentifier(CountrySlicingIdentifierFactory pointIdentifierFactory, Coordinate coordinate) {
        if (!pointIdentifierFactory.hasMore()) {
            throw new CoreException("Country Slicing exceeded maximum number {} of supported new points at Coordinate {} for Atlas {}", pointIdentifierFactory.getIdentifierScale(), this.getShardOrAtlasName(), coordinate);
        }
        long identifier = pointIdentifierFactory.nextIdentifier();
        return this.getStartingAtlas().point(identifier) == null && !this.slicedRelationChanges.getCreatedPoints().containsKey(identifier) ? identifier : this.createNewPointIdentifier(pointIdentifierFactory, coordinate);
    }

    private Atlas cutSubAtlasForOriginalShard(Atlas atlas) {
        try {
            if (this.initialShard != null) {
                Predicate<AtlasEntity> isInCountry = entity -> {
                    Optional<String> countriesTag = entity.getTag("iso_country_code");
                    if (countriesTag.isPresent()) {
                        HashSet<String> countries = new HashSet<String>(Arrays.asList(countriesTag.get().split(",")));
                        for (String country : countries) {
                            if (!this.getCountries().contains(country)) continue;
                            return true;
                        }
                    }
                    return false;
                };
                Atlas countrySubAtlas = atlas.subAtlas(isInCountry, AtlasCutType.SILK_CUT).orElseThrow(() -> new CoreException("Cannot have an empty atlas after relation slicing {}", this.getShardOrAtlasName()));
                return countrySubAtlas.subAtlas(this.initialShard.bounds(), AtlasCutType.SILK_CUT).orElseThrow(() -> new CoreException("Cannot have an empty atlas after relation slicing {}", this.getShardOrAtlasName()));
            }
            return atlas;
        }
        catch (Exception e) {
            throw new CoreException("Error creating sub-atlas for original shard bounds", e);
        }
    }

    private void findEnclosedRings(MultiMap<Integer, Integer> outerToInnerMap, List<LinearRing> outerRings, List<LinearRing> innerRings) {
        for (int innerIndex = 0; innerIndex < innerRings.size(); ++innerIndex) {
            LinearRing inner = innerRings.get(innerIndex);
            boolean foundEnclosingOuter = false;
            for (int outerIndex = 0; outerIndex < outerRings.size(); ++outerIndex) {
                LinearRing outer = outerRings.get(outerIndex);
                org.locationtech.jts.geom.Polygon outerPolygon = new org.locationtech.jts.geom.Polygon(outer, null, JtsUtility.GEOMETRY_FACTORY);
                if (!outerPolygon.contains(inner)) continue;
                foundEnclosingOuter = true;
                outerToInnerMap.add(outerIndex, innerIndex);
            }
            if (foundEnclosingOuter) continue;
            logger.error("Found isolated inner member for Multipolygon Relation geometry while slicing Atlas {}: {}", (Object)this.getShardOrAtlasName(), (Object)inner);
        }
    }

    private MultiMap<Integer, Integer> findIntersectingMembers(List<Line> closedOuterLines, List<Line> closedInnerLines) {
        MultiMap<Integer, Integer> outerToInnerIntersectionMap = new MultiMap<Integer, Integer>();
        if (!closedOuterLines.isEmpty() && !closedInnerLines.isEmpty()) {
            for (int innerIndex = 0; innerIndex < closedInnerLines.size(); ++innerIndex) {
                Line inner = closedInnerLines.get(innerIndex);
                for (int outerIndex = 0; outerIndex < closedOuterLines.size(); ++outerIndex) {
                    Line outer = closedOuterLines.get(outerIndex);
                    if (!RawAtlasRelationSlicer.fromSameCountry(outer, inner) || !outer.intersects(new Polygon(inner))) continue;
                    outerToInnerIntersectionMap.add(outerIndex, innerIndex);
                }
            }
        }
        return outerToInnerIntersectionMap;
    }

    private List<RelationMember> generateMemberList(long relationIdentifier, List<RelationMember> members, boolean closed) {
        if (members != null && !members.isEmpty()) {
            return members.stream().filter(member -> {
                Line line = this.getStartingAtlas().line(member.getEntity().getIdentifier());
                if (line == null) {
                    logger.error("Line member {} for Relation {} is not the in Atlas {}", new Object[]{member.getEntity().getIdentifier(), relationIdentifier, this.getShardOrAtlasName()});
                    return false;
                }
                boolean isClosed = line.isClosed();
                return closed ? isClosed : !isClosed;
            }).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private Map<String, List<TemporaryRelationMember>> groupRelationMembersByCountry(List<TemporaryRelationMember> members) {
        MultiMap<String, TemporaryRelationMember> countryEntityMap = new MultiMap<String, TemporaryRelationMember>();
        for (TemporaryRelationMember member : members) {
            TemporaryEntity temporaryEntity;
            AtlasEntity entity;
            ItemType memberType = member.getType();
            long memberIdentifier = member.getIdentifier();
            switch (memberType) {
                case POINT: {
                    entity = this.getStartingAtlas().point(memberIdentifier);
                    break;
                }
                case LINE: {
                    entity = this.getStartingAtlas().line(memberIdentifier);
                    break;
                }
                case RELATION: {
                    entity = this.getStartingAtlas().relation(memberIdentifier);
                    break;
                }
                default: {
                    throw new CoreException("Unsupported Relation Member of Type {} for Atlas {}", new Object[]{member.getType(), this.getShardOrAtlasName()});
                }
            }
            if (entity != null) {
                Optional<String> countryCodeString = entity.getTag("iso_country_code");
                if (countryCodeString.isPresent()) {
                    String[] countryCodes;
                    for (String countryCode : countryCodes = countryCodeString.get().split(",")) {
                        countryEntityMap.add(countryCode, member);
                    }
                    continue;
                }
                Map<Long, Map<String, String>> entityIdToChangedTags = this.slicedRelationChanges.getUpdatedRelationTags();
                Map newTagsForEntity = entityIdToChangedTags.getOrDefault(entity.getIdentifier(), new HashMap());
                if (newTagsForEntity.containsKey("iso_country_code")) {
                    String[] countryCodes;
                    for (String countryCode : countryCodes = ((String)newTagsForEntity.get("iso_country_code")).split(",")) {
                        countryEntityMap.add(countryCode, member);
                    }
                    continue;
                }
                logger.warn("{} {} missing country code tag value in original Atlas {} and the current changeset", new Object[]{entity.getType(), entity.getIdentifier(), this.getShardOrAtlasName()});
                continue;
            }
            switch (memberType) {
                case POINT: {
                    temporaryEntity = this.slicedRelationChanges.getCreatedPoints().get(memberIdentifier);
                    break;
                }
                case LINE: {
                    temporaryEntity = this.slicedRelationChanges.getCreatedLines().get(memberIdentifier);
                    break;
                }
                case RELATION: {
                    temporaryEntity = this.slicedRelationChanges.getCreatedRelations().get(memberIdentifier);
                    break;
                }
                default: {
                    throw new CoreException("Unsupported Relation Member of Type {} in Atlas {}", new Object[]{member.getType(), this.getShardOrAtlasName()});
                }
            }
            if (temporaryEntity == null) continue;
            String countryCode = temporaryEntity.getTags().get("iso_country_code");
            if (countryCode != null) {
                countryEntityMap.add(countryCode, member);
                continue;
            }
            logger.error("Newly added Relation Member {} does not have a country code for Atlas {}!", (Object)member.getIdentifier(), (Object)this.getShardOrAtlasName());
        }
        return countryEntityMap;
    }

    private void markRemovedMemberLineForDeletion(Line line, long relationIdentifier) {
        boolean isPartOfOtherRelations = line.relations().stream().anyMatch(partOf -> partOf.getIdentifier() != relationIdentifier);
        if (!isPartOfOtherRelations) {
            this.slicedRelationChanges.deleteLine(line.getIdentifier());
            this.getStartingAtlas().line(line.getIdentifier()).asPolyLine().forEach(location -> this.getStartingAtlas().pointsAt((Location)location).forEach(point -> this.pointCandidatesForRemoval.add(point.getIdentifier())));
        }
    }

    private void mergeOverlappingClosedMembers(Relation relation, List<RelationMember> outers, List<RelationMember> inners) {
        if (outers == null || outers.isEmpty()) {
            return;
        }
        if (inners == null || inners.isEmpty()) {
            return;
        }
        if (!RawAtlasRelationSlicer.containsSlicedMember(new MultiIterable<RelationMember>(outers, inners))) {
            return;
        }
        long relationIdentifier = relation.getIdentifier();
        List<RelationMember> closedOuters = this.generateMemberList(relationIdentifier, outers, true);
        List<RelationMember> closedInners = this.generateMemberList(relationIdentifier, inners, true);
        ArrayList<Line> closedOuterLines = new ArrayList<Line>();
        closedOuters.forEach(outer -> closedOuterLines.add(this.getStartingAtlas().line(outer.getEntity().getIdentifier())));
        ArrayList<Line> closedInnerLines = new ArrayList<Line>();
        closedInners.forEach(inner -> closedInnerLines.add(this.getStartingAtlas().line(inner.getEntity().getIdentifier())));
        MultiMap<Integer, Integer> outerToInnerIntersectionMap = this.findIntersectingMembers(closedOuterLines, closedInnerLines);
        long[] identifierSeeds = this.createIdentifierSeeds(relation);
        CountrySlicingIdentifierFactory pointIdentifierGenerator = new CountrySlicingIdentifierFactory(identifierSeeds);
        for (Map.Entry<Integer, List<Integer>> entry : outerToInnerIntersectionMap.entrySet()) {
            LineString exteriorRing;
            Object inner2;
            int outerIndex = entry.getKey();
            List<Integer> innerIndices = entry.getValue();
            CountrySlicingIdentifierFactory lineIdentifierGenerator = new CountrySlicingIdentifierFactory(identifierSeeds[outerIndex]);
            Geometry mergedMembers = null;
            Line outer2 = (Line)closedOuterLines.get(outerIndex);
            LinearRing outerRing = JTS_LINEAR_RING_CONVERTER.convert(new Polygon(outer2.getRawGeometry()));
            org.locationtech.jts.geom.Polygon outerPolygon = new org.locationtech.jts.geom.Polygon(outerRing, null, JtsUtility.GEOMETRY_FACTORY);
            for (int innerIndex : innerIndices) {
                inner2 = (Line)closedInnerLines.get(innerIndex);
                LinearRing innerRing = JTS_LINEAR_RING_CONVERTER.convert(new Polygon(((LineItem)inner2).getRawGeometry()));
                org.locationtech.jts.geom.Polygon innerPolygon = new org.locationtech.jts.geom.Polygon(innerRing, null, JtsUtility.GEOMETRY_FACTORY);
                try {
                    mergedMembers = outerPolygon.difference(innerPolygon);
                }
                catch (Exception e) {
                    logger.error("Error combining intersecting outer {} and inner {} members for Relation {} for Atlas {}", new Object[]{outer2, inner2, relationIdentifier, this.getShardOrAtlasName(), e});
                }
            }
            if (mergedMembers == null || !(mergedMembers instanceof org.locationtech.jts.geom.Polygon) || (exteriorRing = ((org.locationtech.jts.geom.Polygon)mergedMembers).getExteriorRing()).isEmpty() || !exteriorRing.isClosed()) continue;
            TemporaryRelationMember outerToRemove = new TemporaryRelationMember(outer2.getIdentifier(), "outer", outer2.getType());
            this.slicedRelationChanges.deleteRelationMember(relationIdentifier, outerToRemove);
            this.markRemovedMemberLineForDeletion(outer2, relationIdentifier);
            inner2 = innerIndices.iterator();
            while (inner2.hasNext()) {
                int innerIndex = (Integer)inner2.next();
                Line inner3 = (Line)closedInnerLines.get(innerIndex);
                TemporaryRelationMember innerToRemove = new TemporaryRelationMember(inner3.getIdentifier(), "inner", ItemType.LINE);
                this.slicedRelationChanges.deleteRelationMember(relationIdentifier, innerToRemove);
                this.markRemovedMemberLineForDeletion(inner3, relationIdentifier);
            }
            Optional<String> possibleCountryCode = outer2.getTag("iso_country_code");
            if (!possibleCountryCode.isPresent()) {
                throw new CoreException("Relation {} contains member {} that is missing a country code for Atlas {}", relationIdentifier, outer2, this.getShardOrAtlasName());
            }
            String countryCode = possibleCountryCode.get();
            CountryBoundaryMap.setGeometryProperty(exteriorRing, "iso_country_code", countryCode);
            this.createNewLineMemberForRelation(exteriorRing, relationIdentifier, pointIdentifierGenerator, lineIdentifierGenerator);
        }
    }

    private void patchNonClosedMembers(Relation relation, List<RelationMember> outers, List<RelationMember> inners) {
        List<LinearRing> outerRings;
        if (outers == null || outers.isEmpty()) {
            return;
        }
        long relationIdentifier = relation.getIdentifier();
        List<RelationMember> nonClosedOuters = this.generateMemberList(relationIdentifier, outers, false);
        if (!nonClosedOuters.isEmpty() && (outerRings = this.buildRings(nonClosedOuters, relationIdentifier)) != null && !outerRings.isEmpty()) {
            List<LinearRing> innerRings = null;
            MultiMap<Integer, Integer> outerToInnerMap = new MultiMap<Integer, Integer>();
            List<RelationMember> nonClosedInners = null;
            if (inners != null && !inners.isEmpty() && (innerRings = this.buildRings(nonClosedInners = this.generateMemberList(relationIdentifier, inners, false), relationIdentifier)) != null && !innerRings.isEmpty()) {
                this.findEnclosedRings(outerToInnerMap, outerRings, innerRings);
            }
            for (int outerIndex = 0; outerIndex < outerRings.size(); ++outerIndex) {
                LinkedHashSet<LineString> borderLines;
                org.locationtech.jts.geom.Polygon polygon;
                LinearRing outerRing = outerRings.get(outerIndex);
                LinearRing[] holes = null;
                if (outerToInnerMap.containsKey(outerIndex)) {
                    Object innerIndexes = outerToInnerMap.get(outerIndex);
                    holes = new LinearRing[innerIndexes.size()];
                    for (int innerIndex = 0; innerIndex < innerIndexes.size(); ++innerIndex) {
                        holes[innerIndex] = innerRings.get((Integer)innerIndexes.get(innerIndex));
                    }
                }
                if (!(polygon = new org.locationtech.jts.geom.Polygon(outerRing, holes, JtsUtility.GEOMETRY_FACTORY)).isValid()) {
                    logger.error("Polygon created by Relation {} is invalid for Atlas {}", (Object)relationIdentifier, (Object)this.getShardOrAtlasName());
                    return;
                }
                try {
                    borderLines = Sets.newLinkedHashSet(this.getCountryBoundaryMap().clipBoundary(relationIdentifier, polygon));
                }
                catch (Exception e) {
                    logger.error("Error processing Relation {} for Atlas {}, message: {}, geometry: {}", new Object[]{relationIdentifier, this.getShardOrAtlasName(), e.getMessage(), polygon.toString(), e});
                    return;
                }
                if (borderLines == null || borderLines.size() == 0) {
                    return;
                }
                if ((long)borderLines.size() >= 1000L) {
                    logger.error("Borderline got cut into more than 999 pieces for Relation {} for Atlas {}", (Object)relationIdentifier, (Object)this.getShardOrAtlasName());
                    return;
                }
                long[] identifierSeeds = this.createIdentifierSeeds(relation);
                CountrySlicingIdentifierFactory lineIdentifierGenerator = new CountrySlicingIdentifierFactory(identifierSeeds[0]);
                CountrySlicingIdentifierFactory pointIdentifierGenerator = new CountrySlicingIdentifierFactory(identifierSeeds);
                borderLines.forEach(borderLine -> this.createNewLineMemberForRelation((LineString)borderLine, relationIdentifier, pointIdentifierGenerator, lineIdentifierGenerator));
            }
        }
    }

    private void preProcessMultiPolygonRelation(Relation relation) {
        Map<String, List<RelationMember>> roleMap = relation.members().stream().filter(member -> member.getEntity().getType() == ItemType.LINE).collect(Collectors.groupingBy(RelationMember::getRole));
        List<RelationMember> outers = roleMap.get("outer");
        List<RelationMember> inners = roleMap.get("inner");
        this.patchNonClosedMembers(relation, outers, inners);
        this.mergeOverlappingClosedMembers(relation, outers, inners);
    }

    private void removeDeletedPoints() {
        for (long identifier : this.pointCandidatesForRemoval) {
            boolean newLineUsesExistingPoint;
            Location location = this.getStartingAtlas().point(identifier).getLocation();
            boolean partOfExistingNonDeletedLine = Iterables.stream(this.getStartingAtlas().linesContaining(location)).anyMatch(line -> !this.slicedRelationChanges.getDeletedLines().contains(line.getIdentifier()));
            boolean isPartOfNewLine = this.slicedRelationChanges.getCreatedLines().values().stream().anyMatch(line -> line.getShapePointIdentifiers().contains(identifier));
            boolean isNewPoint = this.slicedRelationChanges.getCreatedPoints().containsKey(identifier);
            boolean bl = newLineUsesExistingPoint = isPartOfNewLine && !isNewPoint;
            if (partOfExistingNonDeletedLine || newLineUsesExistingPoint) continue;
            this.slicedRelationChanges.deletePoint(identifier);
        }
    }

    private void sliceRelation(Relation relation) {
        this.getStatistics().recordProcessedRelation();
        if (Validators.isOfType((Taggable)relation, RelationTypeTag.class, (Enum[])new RelationTypeTag[]{RelationTypeTag.BOUNDARY, RelationTypeTag.MULTIPOLYGON})) {
            this.preProcessMultiPolygonRelation(relation);
        }
        this.updateAndSplitRelation(relation);
    }

    private void sliceRelations() {
        this.getStartingAtlas().relationsLowerOrderFirst().forEach(this::sliceRelation);
    }

    private void updateAndSplitRelation(Relation relation) {
        HashMap<String, String> tags;
        ArrayList<TemporaryRelationMember> members = new ArrayList<TemporaryRelationMember>();
        Set removedMembers = Optional.ofNullable(this.slicedRelationChanges.getDeletedRelationMembers().get(relation.getIdentifier())).orElse(new HashSet());
        block4: for (RelationMember member : relation.members()) {
            long memberIdentifier = member.getEntity().getIdentifier();
            ItemType memberType = member.getEntity().getType();
            TemporaryRelationMember temporaryMember = new TemporaryRelationMember(memberIdentifier, member.getRole(), memberType);
            if (removedMembers.contains(temporaryMember)) continue;
            switch (memberType) {
                case POINT: 
                case LINE: {
                    members.add(temporaryMember);
                    continue block4;
                }
                case RELATION: {
                    Object replacementIdentifiers = this.slicedRelationChanges.getDeletedToCreatedRelationMapping().get(memberIdentifier);
                    if (replacementIdentifiers == null) {
                        members.add(temporaryMember);
                        continue block4;
                    }
                    replacementIdentifiers.forEach(identifier -> {
                        TemporaryRelation newSubRelation = this.slicedRelationChanges.getCreatedRelations().get(identifier);
                        TemporaryRelationMember newMember = new TemporaryRelationMember(newSubRelation.getIdentifier(), member.getRole(), memberType);
                        members.add(newMember);
                    });
                    continue block4;
                }
            }
            throw new CoreException("Unsupported {} Member for Relation {} for Atlas {}", new Object[]{memberType, relation.getIdentifier(), this.getShardOrAtlasName()});
        }
        Set addedMembers = Optional.ofNullable(this.slicedRelationChanges.getAddedRelationMembers().get(relation.getIdentifier())).orElse(new HashSet());
        addedMembers.forEach(members::add);
        Map<String, List<TemporaryRelationMember>> countryEntityMap = this.groupRelationMembersByCountry(members);
        List<Object> membersWithoutCountry = countryEntityMap.containsKey("N/A") ? countryEntityMap.remove("N/A") : Collections.emptyList();
        int countryCount = countryEntityMap.size();
        if (countryCount == 0) {
            tags = new HashMap<String, String>();
            tags.put("iso_country_code", "N/A");
            this.slicedRelationChanges.updateRelationTags(relation.getIdentifier(), tags);
        } else if (countryCount == 1) {
            tags = new HashMap();
            tags.put("iso_country_code", countryEntityMap.keySet().iterator().next());
            this.slicedRelationChanges.updateRelationTags(relation.getIdentifier(), tags);
        } else {
            this.slicedRelationChanges.deleteRelation(relation.getIdentifier());
            CountrySlicingIdentifierFactory relationIdentifierFactory = new CountrySlicingIdentifierFactory(relation.getIdentifier());
            countryEntityMap.entrySet().forEach(entry -> {
                ArrayList candidateMembers = new ArrayList();
                candidateMembers.addAll((Collection)entry.getValue());
                candidateMembers.addAll(membersWithoutCountry);
                if (!candidateMembers.isEmpty()) {
                    Map<String, String> relationTags = relation.getTags();
                    relationTags.put("iso_country_code", (String)entry.getKey());
                    if (this.slicedRelationChanges.getUpdatedRelationTags().containsKey(relation.getIdentifier())) {
                        relationTags.putAll(this.slicedRelationChanges.getUpdatedRelationTags().get(relation.getIdentifier()));
                    }
                    TemporaryRelation newRelation = new TemporaryRelation(relationIdentifierFactory.nextIdentifier(), relationTags);
                    candidateMembers.forEach(newRelation::addMember);
                    this.slicedRelationChanges.createRelation(newRelation);
                    this.slicedRelationChanges.createDeletedToCreatedMapping(relation.getIdentifier(), newRelation.getIdentifier());
                }
            });
        }
    }

    private void updateSyntheticRelationMemberTag(long relationIdentifier, long newLineIdentifier) {
        Map<String, String> updatedTags = this.slicedRelationChanges.getUpdatedRelationTags().get(relationIdentifier);
        if (updatedTags == null) {
            HashMap<String, String> newTags = new HashMap<String, String>();
            newTags.put("synthetic_relation_member_added", String.valueOf(newLineIdentifier));
            this.slicedRelationChanges.updateRelationTags(relationIdentifier, newTags);
        } else {
            if (updatedTags.containsKey("synthetic_relation_member_added")) {
                String newValue = updatedTags.get("synthetic_relation_member_added") + "," + String.valueOf(newLineIdentifier);
                updatedTags.put("synthetic_relation_member_added", newValue);
            } else {
                updatedTags.put("synthetic_relation_member_added", String.valueOf(newLineIdentifier));
            }
            this.slicedRelationChanges.updateRelationTags(relationIdentifier, updatedTags);
        }
    }
}

