/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.raw.slicing;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.TopologyException;
import org.locationtech.jts.operation.linemerge.LineMerger;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.geography.Location;
import org.openstreetmap.atlas.geography.Polygon;
import org.openstreetmap.atlas.geography.atlas.Atlas;
import org.openstreetmap.atlas.geography.atlas.items.Line;
import org.openstreetmap.atlas.geography.atlas.items.Point;
import org.openstreetmap.atlas.geography.atlas.pbf.AtlasLoadingOption;
import org.openstreetmap.atlas.geography.atlas.pbf.slicing.identifier.CountrySlicingIdentifierFactory;
import org.openstreetmap.atlas.geography.atlas.pbf.slicing.identifier.PointIdentifierFactory;
import org.openstreetmap.atlas.geography.atlas.raw.slicing.CoordinateToNewPointMapping;
import org.openstreetmap.atlas.geography.atlas.raw.slicing.RawAtlasSlicer;
import org.openstreetmap.atlas.geography.atlas.raw.slicing.changeset.ChangeSetHandler;
import org.openstreetmap.atlas.geography.atlas.raw.slicing.changeset.SimpleChangeSet;
import org.openstreetmap.atlas.geography.atlas.raw.slicing.changeset.SimpleChangeSetHandler;
import org.openstreetmap.atlas.geography.atlas.raw.temporary.TemporaryEntity;
import org.openstreetmap.atlas.geography.atlas.raw.temporary.TemporaryLine;
import org.openstreetmap.atlas.geography.atlas.raw.temporary.TemporaryPoint;
import org.openstreetmap.atlas.geography.boundary.CountryBoundaryMap;
import org.openstreetmap.atlas.tags.SyntheticBoundaryNodeTag;
import org.openstreetmap.atlas.utilities.collections.Iterables;
import org.openstreetmap.atlas.utilities.time.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RawAtlasPointAndLineSlicer
extends RawAtlasSlicer {
    private static final Logger logger = LoggerFactory.getLogger(RawAtlasPointAndLineSlicer.class);
    private final SimpleChangeSet slicedPointAndLineChanges;
    private final Set<Long> pointsMarkedForRemoval = new HashSet<Long>();

    public RawAtlasPointAndLineSlicer(Atlas atlas, AtlasLoadingOption loadingOption) {
        super(loadingOption, new CoordinateToNewPointMapping(), atlas);
        this.slicedPointAndLineChanges = new SimpleChangeSet();
    }

    @Override
    public Atlas slice() {
        Time time = Time.now();
        logger.info("Starting Point and Line Slicing for Atlas {}", (Object)this.getShardOrAtlasName());
        this.sliceLines();
        this.slicePoints();
        SimpleChangeSetHandler simpleChangeBuilder = new SimpleChangeSetHandler(this.getStartingAtlas(), this.slicedPointAndLineChanges);
        Atlas atlasWithSlicedWaysAndPoints = ((ChangeSetHandler)simpleChangeBuilder).applyChanges();
        logger.info("Finished Point and Line Slicing for Atlas {} in {}", (Object)this.getShardOrAtlasName(), (Object)time.elapsedSince());
        this.getStatistics().summary();
        return atlasWithSlicedWaysAndPoints;
    }

    private void addRawAtlasPointsToLine(Location location, Iterable<Point> rawAtlasPoints, List<Long> line) {
        Map<String, String> pointTags = this.createPointTags(location, true);
        for (Point rawAtlasPoint : rawAtlasPoints) {
            this.pointsMarkedForRemoval.remove(rawAtlasPoint.getIdentifier());
            this.slicedPointAndLineChanges.updatePointTags(rawAtlasPoint.getIdentifier(), pointTags);
            line.add(rawAtlasPoint.getIdentifier());
        }
    }

    private List<Geometry> convertToJtsGeometryAndSlice(Line line) {
        long lineIdentifier = line.getIdentifier();
        Geometry geometry = this.isAtlasEdge(line) ? JTS_POLYLINE_CONVERTER.convert(line.asPolyLine()) : (line.isClosed() ? JTS_POLYGON_CONVERTER.convert(new Polygon(line)) : JTS_POLYLINE_CONVERTER.convert(line.asPolyLine()));
        List<Geometry> result = this.sliceGeometry(geometry, line);
        if ((result == null || result.isEmpty()) && line.isClosed()) {
            geometry = JTS_POLYLINE_CONVERTER.convert(line.asPolyLine());
            result = this.sliceGeometry(geometry, line);
        }
        if (result == null || result.isEmpty()) {
            logger.error("Invalid Geometry for line {} for Atlas {}", (Object)lineIdentifier, (Object)this.getShardOrAtlasName());
        }
        return result;
    }

    private long createNewPointIdentifier(PointIdentifierFactory pointIdentifierFactory, long lineIdentifier) {
        while (pointIdentifierFactory.hasMore()) {
            long identifier = pointIdentifierFactory.nextIdentifier();
            if (this.getStartingAtlas().point(identifier) != null) continue;
            return identifier;
        }
        throw new CoreException("Slicing Line {} exceeded maximum number {} of supported new Points for Atlas {}", pointIdentifierFactory.getIdentifierScale(), lineIdentifier, this.getShardOrAtlasName());
    }

    private boolean isOutsideWorkingBound(Map<String, String> tags) {
        if (this.getCountries() != null && !this.getCountries().isEmpty()) {
            String[] countryCodes;
            String tagValue = tags.get("iso_country_code");
            for (String countryCode : countryCodes = tagValue.split(",")) {
                if (!this.getCountries().contains(countryCode)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private SortedMap<String, Collection<Geometry>> preprocessSlices(List<Geometry> slices) {
        TreeMap<String, Collection<Geometry>> processedSlices = new TreeMap<String, Collection<Geometry>>();
        Map<String, List<Geometry>> slicesByCountryCode = slices.stream().collect(Collectors.groupingBy(geometry -> CountryBoundaryMap.getGeometryProperty(geometry, "iso_country_code")));
        slicesByCountryCode.keySet().forEach(countryCode -> {
            TreeSet sortedSlices = new TreeSet();
            List slicesForCountry = (List)slicesByCountryCode.get(countryCode);
            HashMap<String, String> mergedLineTags = new HashMap<String, String>();
            mergedLineTags.put("iso_country_code", (String)countryCode);
            slicesForCountry.forEach(slice -> CountryBoundaryMap.getGeometryProperties(slice).forEach((key, value) -> {
                if (!mergedLineTags.containsKey(key)) {
                    mergedLineTags.put((String)key, (String)value);
                }
            }));
            LineMerger merger = new LineMerger();
            merger.add(slicesForCountry);
            merger.getMergedLineStrings().forEach(geometry -> mergedLineTags.forEach((key, value) -> CountryBoundaryMap.setGeometryProperty((Geometry)geometry, key, value)));
            sortedSlices.addAll(merger.getMergedLineStrings());
            processedSlices.put((String)countryCode, sortedSlices);
        });
        return processedSlices;
    }

    private void processLineSlices(Line line, List<Geometry> slices) {
        CountrySlicingIdentifierFactory lineIdentifierFactory = new CountrySlicingIdentifierFactory(line.getIdentifier());
        PointIdentifierFactory pointIdentifierFactory = new PointIdentifierFactory(line.getIdentifier());
        ArrayList createdLines = new ArrayList();
        slices.forEach(slice -> {
            org.locationtech.jts.geom.Polygon polygonForSlice;
            if (slice instanceof org.locationtech.jts.geom.Polygon && (polygonForSlice = (org.locationtech.jts.geom.Polygon)slice).getNumInteriorRing() > 0) {
                logger.warn("Line {} had a multipolygon result for slicing for Atlas {}!", (Object)line.getIdentifier(), (Object)this.getShardOrAtlasName());
            }
        });
        SortedMap<String, Collection<Geometry>> mergedSlices = this.preprocessSlices(slices);
        mergedSlices.keySet().forEach(countryCode -> {
            for (Geometry slice : (Collection)mergedSlices.get(countryCode)) {
                if (this.isOutsideWorkingBound(slice)) {
                    lineIdentifierFactory.nextIdentifier();
                    this.removeShapePointsFromFilteredSliced(slice);
                    continue;
                }
                long lineSliceIdentifier = lineIdentifierFactory.nextIdentifier();
                List<Long> newLineShapePoints = this.processSlice(slice, pointIdentifierFactory, line);
                Map<String, String> lineTags = RawAtlasPointAndLineSlicer.createLineTags(slice, line.getTags());
                createdLines.add(new TemporaryLine(lineSliceIdentifier, newLineShapePoints, lineTags));
            }
        });
        createdLines.forEach(this.slicedPointAndLineChanges::createLine);
        this.slicedPointAndLineChanges.createDeletedToCreatedMapping(line.getIdentifier(), createdLines.stream().map(TemporaryEntity::getIdentifier).collect(Collectors.toSet()));
        this.getStatistics().recordSlicedLine();
    }

    private List<Long> processSlice(Geometry slice, PointIdentifierFactory pointIdentifierFactory, Line line) {
        Coordinate[] jtsSliceCoordinates;
        ArrayList<Long> newLineShapePoints = new ArrayList<Long>(slice.getNumPoints());
        for (Coordinate coordinate : jtsSliceCoordinates = PRECISION_REDUCER.edit(slice.getCoordinates(), slice)) {
            Location coordinateLocation = JTS_LOCATION_CONVERTER.backwardConvert(coordinate);
            Iterable<Point> rawAtlasPointsAtSliceVertex = this.getStartingAtlas().pointsAt(coordinateLocation);
            if (Iterables.isEmpty(rawAtlasPointsAtSliceVertex)) {
                if (this.getCoordinateToPointMapping().containsCoordinate(coordinate)) {
                    newLineShapePoints.add(this.getCoordinateToPointMapping().getPointForCoordinate(coordinate));
                    continue;
                }
                Location scaledLocation = JTS_LOCATION_CONVERTER.backwardConvert(this.getCoordinateToPointMapping().getScaledCoordinate(coordinate));
                Iterable<Point> rawAtlasPointsAtScaledCoordinate = this.getStartingAtlas().pointsAt(scaledLocation);
                if (Iterables.isEmpty(rawAtlasPointsAtScaledCoordinate)) {
                    Map<String, String> pointTags = this.createPointTags(scaledLocation, false);
                    pointTags.put("synthetic_boundary_node", SyntheticBoundaryNodeTag.YES.toString());
                    long pointIdentifier = this.createNewPointIdentifier(pointIdentifierFactory, line.getIdentifier());
                    TemporaryPoint newPoint = RawAtlasPointAndLineSlicer.createNewPoint(this.getCoordinateToPointMapping().getScaledCoordinate(coordinate), pointIdentifier, pointTags);
                    this.getCoordinateToPointMapping().storeMapping(coordinate, newPoint.getIdentifier());
                    newLineShapePoints.add(newPoint.getIdentifier());
                    this.slicedPointAndLineChanges.createPoint(newPoint);
                    continue;
                }
                this.addRawAtlasPointsToLine(scaledLocation, rawAtlasPointsAtScaledCoordinate, newLineShapePoints);
                continue;
            }
            this.addRawAtlasPointsToLine(coordinateLocation, rawAtlasPointsAtSliceVertex, newLineShapePoints);
        }
        return newLineShapePoints;
    }

    private void removeShapePointsFromFilteredSliced(Geometry slice) {
        Coordinate[] jtsSliceCoordinates;
        for (Coordinate coordinate : jtsSliceCoordinates = slice.getCoordinates()) {
            Location location = JTS_LOCATION_CONVERTER.backwardConvert(coordinate);
            Iterable<Point> existingRawAtlasPoints = this.getStartingAtlas().pointsAt(location);
            existingRawAtlasPoints.forEach(point -> this.pointsMarkedForRemoval.add(point.getIdentifier()));
        }
    }

    private List<Geometry> sliceGeometry(Geometry geometry, Line line) {
        try {
            return this.getCountryBoundaryMap().slice(line.getIdentifier(), geometry, line);
        }
        catch (TopologyException e) {
            logger.error("Topology Exception when slicing Line {} for Atlas {}", new Object[]{line.getIdentifier(), this.getShardOrAtlasName(), e});
            return Collections.emptyList();
        }
    }

    private void sliceLine(Line line) {
        this.getStatistics().recordProcessedLine();
        List<Geometry> slices = this.convertToJtsGeometryAndSlice(line);
        if (slices == null || slices.isEmpty()) {
            HashMap<String, String> tags = new HashMap<String, String>();
            tags.put("iso_country_code", "N/A");
            this.slicedPointAndLineChanges.updateLineTags(line.getIdentifier(), tags);
            this.updateLineShapePoints(line);
        } else if (this.slicesBelongToSingleCountry(slices) && !this.getCountryBoundaryMap().shouldForceSlicing(line)) {
            if (this.isOutsideWorkingBound(slices.get(0))) {
                this.slicedPointAndLineChanges.createDeletedToCreatedMapping(line.getIdentifier(), Collections.emptySet());
            } else {
                this.slicedPointAndLineChanges.updateLineTags(line.getIdentifier(), RawAtlasPointAndLineSlicer.createLineTags(slices.get(0), line.getTags()));
                this.updateLineShapePoints(line);
            }
        } else if ((long)slices.size() < 1000L) {
            this.processLineSlices(line, slices);
        } else {
            logger.error("Country slicing exceeded maximum line identifier name space of {} for Line {} for Atlas {}. It will be added as is, with two or more country codes.", new Object[]{1000L, line.getIdentifier(), this.getShardOrAtlasName()});
            this.updateLineToHaveCountryCodesFromAllSlices(line, slices);
            this.getStatistics().recordSkippedLine();
        }
    }

    private void sliceLines() {
        StreamSupport.stream(this.getStartingAtlas().lines().spliterator(), true).forEach(this::sliceLine);
    }

    private void slicePoints() {
        StreamSupport.stream(this.getStartingAtlas().points().spliterator(), true).forEach(point -> {
            long pointIdentifier = point.getIdentifier();
            if (!this.slicedPointAndLineChanges.getUpdatedPointTags().containsKey(pointIdentifier) && !this.pointsMarkedForRemoval.contains(pointIdentifier)) {
                this.getStatistics().recordProcessedPoint();
                Map<String, String> updatedTags = this.createPointTags(point.getLocation(), true);
                if (this.isOutsideWorkingBound(updatedTags)) {
                    this.slicedPointAndLineChanges.deletePoint(pointIdentifier);
                } else {
                    this.slicedPointAndLineChanges.updatePointTags(pointIdentifier, updatedTags);
                }
            }
        });
        this.pointsMarkedForRemoval.forEach(this.slicedPointAndLineChanges::deletePoint);
    }

    private boolean slicesBelongToSingleCountry(List<Geometry> slices) {
        return slices.size() == 1 || CountryBoundaryMap.isSameCountry(slices);
    }

    private void updateLineShapePoints(Line line) {
        for (Location location : line.asPolyLine()) {
            for (Point point : this.getStartingAtlas().pointsAt(location)) {
                this.getStatistics().recordProcessedPoint();
                this.slicedPointAndLineChanges.updatePointTags(point.getIdentifier(), this.createPointTags(location, true));
            }
        }
    }

    private void updateLineToHaveCountryCodesFromAllSlices(Line line, List<Geometry> slices) {
        HashMap<String, String> tags = new HashMap<String, String>();
        Set allCountries = slices.stream().map(geometry -> CountryBoundaryMap.getGeometryProperty(geometry, "iso_country_code")).collect(Collectors.toCollection(TreeSet::new));
        String countryString = String.join((CharSequence)",", allCountries);
        tags.put("iso_country_code", countryString);
        this.slicedPointAndLineChanges.updateLineTags(line.getIdentifier(), tags);
        this.updateLineShapePoints(line);
    }
}

