/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.raw.slicing;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.PrecisionModel;

public class CoordinateToNewPointMapping {
    private static final Integer SIX_DIGIT_PRECISION_SCALE = 1000000;
    private final Map<Coordinate, Long> coordinateToPointIdentifierMap = new ConcurrentHashMap<Coordinate, Long>();
    private final PrecisionModel precisionModel = new PrecisionModel(SIX_DIGIT_PRECISION_SCALE.intValue());

    public boolean containsCoordinate(Coordinate coordinate) {
        return this.coordinateToPointIdentifierMap.containsKey(coordinate);
    }

    public Long getPointForCoordinate(Coordinate coordinate) {
        return this.coordinateToPointIdentifierMap.get(coordinate);
    }

    public Coordinate getScaledCoordinate(Coordinate target) {
        Coordinate cloned = (Coordinate)target.clone();
        this.precisionModel.makePrecise(cloned);
        return cloned;
    }

    public void storeMapping(Coordinate coordinate, Long point) {
        this.coordinateToPointIdentifierMap.put(coordinate, point);
    }
}

