/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.raw.sectioning;

import org.openstreetmap.atlas.tags.HighwayTag;
import org.openstreetmap.atlas.tags.JunctionTag;
import org.openstreetmap.atlas.tags.OneWayTag;
import org.openstreetmap.atlas.tags.Taggable;
import org.openstreetmap.atlas.tags.annotations.validation.Validators;

public enum PbfOneWay {
    YES,
    NO,
    REVERSED;


    public static PbfOneWay forTag(Taggable taggable) {
        if (OneWayTag.isExplicitlyTwoWay(taggable)) {
            return NO;
        }
        if (OneWayTag.isTwoWay(taggable)) {
            if (JunctionTag.isRoundabout(taggable) || Validators.isOfType((Taggable)taggable, HighwayTag.class, (Enum[])new HighwayTag[]{HighwayTag.MOTORWAY})) {
                return YES;
            }
            return NO;
        }
        if (OneWayTag.isOneWayForward(taggable)) {
            return YES;
        }
        if (OneWayTag.isOneWayReversed(taggable)) {
            return REVERSED;
        }
        return NO;
    }
}

