/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.raw.creation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.geography.Latitude;
import org.openstreetmap.atlas.geography.Location;
import org.openstreetmap.atlas.geography.Longitude;
import org.openstreetmap.atlas.geography.PolyLine;
import org.openstreetmap.atlas.geography.atlas.builder.RelationBean;
import org.openstreetmap.atlas.geography.atlas.items.ItemType;
import org.openstreetmap.atlas.geography.atlas.items.Point;
import org.openstreetmap.atlas.geography.atlas.packed.PackedAtlasBuilder;
import org.openstreetmap.atlas.geography.atlas.pbf.AtlasLoadingOption;
import org.openstreetmap.atlas.geography.atlas.pbf.slicing.identifier.PaddingIdentifierFactory;
import org.openstreetmap.atlas.geography.atlas.raw.creation.RawAtlasStatistic;
import org.openstreetmap.atlas.geography.atlas.raw.sectioning.TagMap;
import org.openstreetmap.atlas.tags.AtlasTag;
import org.openstreetmap.atlas.tags.Taggable;
import org.openstreetmap.osmosis.core.container.v0_6.EntityContainer;
import org.openstreetmap.osmosis.core.domain.v0_6.Bound;
import org.openstreetmap.osmosis.core.domain.v0_6.Entity;
import org.openstreetmap.osmosis.core.domain.v0_6.EntityType;
import org.openstreetmap.osmosis.core.domain.v0_6.Node;
import org.openstreetmap.osmosis.core.domain.v0_6.Relation;
import org.openstreetmap.osmosis.core.domain.v0_6.RelationMember;
import org.openstreetmap.osmosis.core.domain.v0_6.Tag;
import org.openstreetmap.osmosis.core.domain.v0_6.Way;
import org.openstreetmap.osmosis.core.domain.v0_6.WayNode;
import org.openstreetmap.osmosis.core.task.v0_6.Sink;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OsmPbfReader
implements Sink {
    private static final Logger logger = LoggerFactory.getLogger(OsmPbfReader.class);
    private static final String MISSING_MEMBER_MESSAGE = "Relation {} contains {} {} as a member, but it's either filtered out or this PBF shard does not contain it.";
    private final PackedAtlasBuilder builder;
    private final AtlasLoadingOption loadingOption;
    private final Set<Long> nodeIdentifiersToInclude = new HashSet<Long>();
    private final Set<Long> wayIdentifiersToInclude = new HashSet<Long>();
    private final Set<Long> pointIdentifiersFromFilteredLines = new HashSet<Long>();
    private final List<Relation> stagedRelations = new ArrayList<Relation>();
    private final RawAtlasStatistic statistics = new RawAtlasStatistic(logger);

    public static boolean shouldProcessEntity(AtlasLoadingOption loadingOption, Entity entity) {
        if (entity instanceof Node) {
            return loadingOption.getOsmPbfNodeFilter().test(Taggable.with(entity.getTags()));
        }
        if (entity instanceof Way) {
            return loadingOption.getOsmPbfWayFilter().test(Taggable.with(entity.getTags()));
        }
        if (entity instanceof Relation) {
            return loadingOption.getOsmPbfRelationFilter().test(Taggable.with(entity.getTags()));
        }
        return true;
    }

    public OsmPbfReader(AtlasLoadingOption loadingOption, PackedAtlasBuilder builder) {
        this.builder = builder;
        this.loadingOption = loadingOption;
    }

    @Override
    public void complete() {
    }

    @Override
    public void initialize(Map<String, Object> metaData) {
        logger.info("Initialized OSM PBF Reader successfully");
    }

    @Override
    public void process(EntityContainer entityContainer) {
        Entity rawEntity = entityContainer.getEntity();
        if (OsmPbfReader.shouldProcessEntity(this.loadingOption, rawEntity)) {
            if (rawEntity instanceof Node && this.nodeIdentifiersToInclude.contains(rawEntity.getId())) {
                this.processNode(rawEntity);
            } else if (rawEntity instanceof Way && this.wayIdentifiersToInclude.contains(rawEntity.getId())) {
                this.processWay(rawEntity);
            } else if (this.loadingOption.isLoadOsmRelation() && rawEntity instanceof Relation) {
                this.processRelation(rawEntity);
            } else if (rawEntity instanceof Bound) {
                logger.trace("Encountered PBF Bound {}, skipping over it.", (Object)rawEntity.getId());
            }
        } else {
            this.recordNodeIdentifiersFromFilteredEntity(rawEntity);
            this.logFilteredStatistics(rawEntity);
            logger.trace("Filtering out OSM {} {} from Raw Atlas", (Object)rawEntity.getType(), (Object)rawEntity.getId());
        }
    }

    @Override
    public void release() {
        this.processStagedRelations();
        this.statistics.summary();
        logger.info("Released OSM PBF Reader");
    }

    public void setIncludedNodes(Set<Long> nodesToInclude) {
        this.nodeIdentifiersToInclude.addAll(nodesToInclude);
    }

    public void setIncludedWays(Set<Long> waysToInclude) {
        this.wayIdentifiersToInclude.addAll(waysToInclude);
    }

    protected Set<Long> getPointIdentifiersFromFilteredLines() {
        return this.pointIdentifiersFromFilteredLines;
    }

    private void addRelation(Relation relation) {
        RelationBean bean = this.constructRelationBean(relation);
        if (!bean.isEmpty()) {
            this.builder.addRelation(this.padIdentifier(relation.getId()), relation.getId(), bean, this.populateEntityTags(relation));
            this.statistics.recordCreatedRelation();
        } else {
            this.statistics.recordDroppedRelation();
            logger.debug("Cannot add empty Relation {} to the Atlas. We're either filtering out the members that make up the Relation or none of the members are present in this PBF shard.", (Object)relation.getId());
        }
    }

    private RelationBean constructRelationBean(Relation relation) {
        RelationBean bean = new RelationBean();
        for (RelationMember member : relation.getMembers()) {
            long memberIdentifier = this.padIdentifier(member.getMemberId());
            EntityType memberType = member.getMemberType();
            String role = member.getMemberRole();
            if (memberType == EntityType.Node) {
                if (this.builder.peek().point(memberIdentifier) != null) {
                    bean.addItem(memberIdentifier, role, ItemType.POINT);
                    continue;
                }
                logger.trace(MISSING_MEMBER_MESSAGE, new Object[]{relation.getId(), EntityType.Node, memberIdentifier});
                continue;
            }
            if (memberType == EntityType.Way) {
                if (this.builder.peek().line(memberIdentifier) != null) {
                    bean.addItem(memberIdentifier, role, ItemType.LINE);
                    continue;
                }
                logger.trace(MISSING_MEMBER_MESSAGE, new Object[]{relation.getId(), EntityType.Way, memberIdentifier});
                continue;
            }
            if (memberType == EntityType.Relation) {
                if (this.builder.peek().relation(memberIdentifier) != null) {
                    bean.addItem(memberIdentifier, role, ItemType.RELATION);
                    continue;
                }
                logger.trace(MISSING_MEMBER_MESSAGE, new Object[]{relation.getId(), EntityType.Relation, memberIdentifier});
                continue;
            }
            logger.error("Invalid Bound member {} found for Relation {}", (Object)member.getMemberId(), (Object)relation.getId());
        }
        return bean;
    }

    private PolyLine constructWayPolyLine(Way way) {
        List<WayNode> wayNodes = way.getWayNodes();
        ArrayList wayLocations = new ArrayList();
        wayNodes.forEach(node -> wayLocations.add(this.getNodeLocation(this.padIdentifier(node.getNodeId()))));
        return new PolyLine(wayLocations);
    }

    private boolean containsUnindexedSubRelation(Relation relation) {
        return relation.getMembers().stream().anyMatch(member -> member.getMemberType() == EntityType.Relation && this.builder.peek().relation(this.padIdentifier(member.getMemberId())) == null);
    }

    private Location getNodeLocation(long identifier) {
        Point point = this.builder.peek().point(identifier);
        if (point != null) {
            return point.getLocation();
        }
        throw new CoreException("Unable to find Point {} in Atlas. It was either filtered out or the PBF file is malformed.", identifier);
    }

    private boolean isInvalidWay(Way way) {
        List<WayNode> wayNodes = way.getWayNodes();
        return wayNodes.size() < 2 || wayNodes.size() == 2 && wayNodes.get(0).getNodeId() == wayNodes.get(1).getNodeId();
    }

    private void logFilteredStatistics(Entity entity) {
        if (entity instanceof Node) {
            this.statistics.recordFilteredNode();
        } else if (entity instanceof Way) {
            this.statistics.recordFilteredWay();
        } else if (entity instanceof Relation) {
            this.statistics.recordFilteredRelation();
        }
    }

    private boolean needsPadding() {
        return this.loadingOption.isCountrySlicing() || this.loadingOption.isWaySectioning();
    }

    private long padIdentifier(long identifier) {
        if (this.needsPadding()) {
            return PaddingIdentifierFactory.pad(identifier);
        }
        return identifier;
    }

    private Map<String, String> populateEntityTags(Entity entity) {
        this.storeOsmEntityAttributesAsTags(entity);
        return new TagMap(entity.getTags()).getTags();
    }

    private void processNode(Entity entity) {
        Node node = (Node)entity;
        this.builder.addPoint(this.padIdentifier(node.getId()), new Location(Latitude.degrees(node.getLatitude()), Longitude.degrees(node.getLongitude())), this.populateEntityTags(node));
        this.statistics.recordCreatedPoint();
    }

    private void processRelation(Entity entity) {
        Relation relation = (Relation)entity;
        if (this.containsUnindexedSubRelation(relation)) {
            this.stagedRelations.add(relation);
        } else {
            this.addRelation(relation);
        }
    }

    private void processStagedRelations() {
        int previousStagedRelationSize = Integer.MAX_VALUE;
        List<Relation> stagedRelations = this.stagedRelations;
        int currentStagedRelationSize = stagedRelations.size();
        while (!stagedRelations.isEmpty() && currentStagedRelationSize < previousStagedRelationSize) {
            ArrayList<Relation> updatedStagedRelations = new ArrayList<Relation>();
            for (Relation relation : stagedRelations) {
                if (this.containsUnindexedSubRelation(relation)) {
                    updatedStagedRelations.add(relation);
                    continue;
                }
                this.addRelation(relation);
            }
            stagedRelations = updatedStagedRelations;
            previousStagedRelationSize = currentStagedRelationSize;
            currentStagedRelationSize = stagedRelations.size();
        }
        if (currentStagedRelationSize == previousStagedRelationSize && !stagedRelations.isEmpty()) {
            stagedRelations.forEach(this::addRelation);
        }
    }

    private void processWay(Entity entity) {
        Way way = (Way)entity;
        if (this.isInvalidWay(way)) {
            this.statistics.recordDroppedWay();
        } else {
            this.builder.addLine(this.padIdentifier(way.getId()), this.constructWayPolyLine(way), this.populateEntityTags(way));
            this.statistics.recordCreatedLine();
        }
    }

    private void recordNodeIdentifiersFromFilteredEntity(Entity entity) {
        if (entity instanceof Way) {
            List<WayNode> wayNodes = ((Way)entity).getWayNodes();
            wayNodes.forEach(node -> {
                this.pointIdentifiersFromFilteredLines.add(this.padIdentifier(node.getNodeId()));
                this.statistics.recordFilteredNode();
            });
        }
    }

    private void storeOsmEntityAttributesAsTags(Entity entity) {
        Collection<Tag> tags = entity.getTags();
        for (String tag : AtlasTag.TAGS_FROM_OSM) {
            if (tag.equals("last_edit_time")) {
                tags.add(new Tag(tag, String.valueOf(entity.getTimestamp().getTime())));
                continue;
            }
            if (tag.equals("last_edit_user_id")) {
                tags.add(new Tag(tag, String.valueOf(entity.getUser().getId())));
                continue;
            }
            if (tag.equals("last_edit_user_name")) {
                tags.add(new Tag(tag, entity.getUser().getName()));
                continue;
            }
            if (tag.equals("last_edit_version")) {
                tags.add(new Tag(tag, String.valueOf(entity.getVersion())));
                continue;
            }
            if (tag.equals("last_edit_changeset")) {
                tags.add(new Tag(tag, String.valueOf(entity.getChangesetId())));
                continue;
            }
            logger.error("Trying to add mandatory tag {}, but no behavior defined for getting the value.", (Object)tag);
        }
    }
}

