/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.raw.creation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.openstreetmap.atlas.geography.GeometricSurface;
import org.openstreetmap.atlas.geography.Latitude;
import org.openstreetmap.atlas.geography.Location;
import org.openstreetmap.atlas.geography.Longitude;
import org.openstreetmap.atlas.geography.atlas.pbf.AtlasLoadingOption;
import org.openstreetmap.atlas.geography.atlas.raw.creation.OsmPbfReader;
import org.openstreetmap.atlas.geography.atlas.raw.sectioning.TagMap;
import org.openstreetmap.atlas.tags.HighwayTag;
import org.openstreetmap.atlas.tags.RouteTag;
import org.openstreetmap.osmosis.core.container.v0_6.EntityContainer;
import org.openstreetmap.osmosis.core.domain.v0_6.Bound;
import org.openstreetmap.osmosis.core.domain.v0_6.Entity;
import org.openstreetmap.osmosis.core.domain.v0_6.EntityType;
import org.openstreetmap.osmosis.core.domain.v0_6.Node;
import org.openstreetmap.osmosis.core.domain.v0_6.Relation;
import org.openstreetmap.osmosis.core.domain.v0_6.RelationMember;
import org.openstreetmap.osmosis.core.domain.v0_6.Way;
import org.openstreetmap.osmosis.core.domain.v0_6.WayNode;
import org.openstreetmap.osmosis.core.task.v0_6.Sink;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OsmPbfCounter
implements Sink {
    private static final Logger logger = LoggerFactory.getLogger(OsmPbfCounter.class);
    private static final int MAXIMUM_NETWORK_EXTENSION = 2;
    private final AtlasLoadingOption loadingOption;
    private final GeometricSurface boundingBox;
    private final Set<Long> nodeIdentifiersToInclude = new HashSet<Long>();
    private final Set<Long> nodeIdentifiersBroughtInByWaysOrRelations = new HashSet<Long>();
    private final Set<Long> wayIdentifiersToInclude = new HashSet<Long>();
    private final Set<Long> relationIdentifiersToInclude = new HashSet<Long>();
    private final Map<Long, Way> waysToExclude = new HashMap<Long, Way>();
    private final List<Relation> stagedRelations = new ArrayList<Relation>();

    public OsmPbfCounter(AtlasLoadingOption loadingOption, GeometricSurface boundingBox) {
        this.loadingOption = loadingOption;
        this.boundingBox = boundingBox;
    }

    @Override
    public void complete() {
    }

    public Set<Long> getIncludedNodeIdentifiers() {
        return this.nodeIdentifiersToInclude;
    }

    public Set<Long> getIncludedWayIdentifiers() {
        return this.wayIdentifiersToInclude;
    }

    @Override
    public void initialize(Map<String, Object> metaData) {
        logger.info("Initialized OSM PBF Counter successfully");
    }

    public long lineCount() {
        return this.wayIdentifiersToInclude.size();
    }

    public long pointCount() {
        return this.nodeIdentifiersToInclude.size();
    }

    @Override
    public void process(EntityContainer entityContainer) {
        Entity rawEntity = entityContainer.getEntity();
        if (OsmPbfReader.shouldProcessEntity(this.loadingOption, rawEntity)) {
            if (this.shouldLoadOsmNode(rawEntity)) {
                this.nodeIdentifiersToInclude.add(rawEntity.getId());
            } else if (this.shouldLoadOsmWay(rawEntity)) {
                Way way = (Way)rawEntity;
                if (this.wayContainsNodeWithinBoundary(way)) {
                    this.addWayNodes(this.nodeIdentifiersBroughtInByWaysOrRelations, way);
                    this.wayIdentifiersToInclude.add(way.getId());
                } else {
                    this.waysToExclude.put(way.getId(), way);
                }
            } else if (this.shouldLoadOsmRelation(rawEntity)) {
                Relation relation = (Relation)rawEntity;
                if (this.relationContainsMemberWithinBoundary(relation)) {
                    this.markRelationAndMembersInsideBoundary(relation);
                } else {
                    this.stagedRelations.add(relation);
                }
            } else if (rawEntity instanceof Bound) {
                logger.trace("Encountered PBF Bound {}, skipping over it.", (Object)rawEntity.getId());
            }
        }
    }

    public long relationCount() {
        return this.relationIdentifiersToInclude.size();
    }

    @Override
    public void release() {
        this.processStagedRelations();
        this.bringInConnectedOutsideWays();
        this.nodeIdentifiersToInclude.addAll(this.nodeIdentifiersBroughtInByWaysOrRelations);
        logger.info("Released OSM PBF Counter");
    }

    private void addWayNodes(Set<Long> set, Way way) {
        way.getWayNodes().forEach(wayNode -> set.add(wayNode.getNodeId()));
    }

    private void bringInConnectedOutsideWays() {
        if (this.loadingOption.isLoadWaysSpanningCountryBoundaries()) {
            HashSet alreadyAddedWays = new HashSet();
            AtomicBoolean addedNewEdge = new AtomicBoolean(true);
            for (int extensionCounter = 0; extensionCounter < 2 && addedNewEdge.get(); ++extensionCounter) {
                logger.trace("Adding connected ways outside boundary pass {}", (Object)extensionCounter);
                addedNewEdge.set(false);
                this.waysToExclude.values().stream().filter(this::isHighwayOrFerry).filter(way -> !alreadyAddedWays.contains(way.getId())).forEach(way -> {
                    List<WayNode> wayNodes = way.getWayNodes();
                    for (WayNode wayNode : wayNodes) {
                        long identifier = wayNode.getNodeId();
                        if (!this.nodeIdentifiersBroughtInByWaysOrRelations.contains(identifier)) continue;
                        logger.trace("Adding connected way with identifier {}", (Object)way.getId());
                        this.wayIdentifiersToInclude.add(way.getId());
                        this.addWayNodes(this.nodeIdentifiersBroughtInByWaysOrRelations, (Way)way);
                        addedNewEdge.set(true);
                        alreadyAddedWays.add(way.getId());
                        break;
                    }
                });
            }
        }
    }

    private boolean isHighwayOrFerry(Way way) {
        TagMap taggableWay = new TagMap(way.getTags());
        return HighwayTag.isCoreWay(taggableWay) || RouteTag.isFerry(taggableWay);
    }

    private void markRelationAndMembersInsideBoundary(Relation relation) {
        for (RelationMember member : relation.getMembers()) {
            EntityType memberType = member.getMemberType();
            Long memberIdentifier = member.getMemberId();
            if (memberType == EntityType.Node) {
                this.nodeIdentifiersToInclude.add(memberIdentifier);
                continue;
            }
            if (memberType == EntityType.Way) {
                this.wayIdentifiersToInclude.add(memberIdentifier);
                Way toAdd = this.waysToExclude.get(memberIdentifier);
                if (toAdd == null) continue;
                this.addWayNodes(this.nodeIdentifiersBroughtInByWaysOrRelations, toAdd);
                this.waysToExclude.remove(memberIdentifier, toAdd);
                continue;
            }
            if (memberType != EntityType.Relation) continue;
            this.relationIdentifiersToInclude.add(member.getMemberId());
        }
        this.relationIdentifiersToInclude.add(relation.getId());
    }

    private boolean nodeWithinTargetBoundary(Node node) {
        return this.boundingBox.fullyGeometricallyEncloses(new Location(Latitude.degrees(node.getLatitude()), Longitude.degrees(node.getLongitude())));
    }

    private void processStagedRelations() {
        List<Relation> stagedRelations = this.stagedRelations;
        int currentStagedRelationSize = this.stagedRelations.size();
        int previousStagedRelationSize = 0;
        while (!this.stagedRelations.isEmpty() && currentStagedRelationSize != previousStagedRelationSize) {
            ArrayList<Relation> updatedStagedRelations = new ArrayList<Relation>();
            for (Relation relation : stagedRelations) {
                if (this.relationContainsMemberWithinBoundary(relation)) {
                    this.markRelationAndMembersInsideBoundary(relation);
                    continue;
                }
                updatedStagedRelations.add(relation);
            }
            stagedRelations = updatedStagedRelations;
            previousStagedRelationSize = currentStagedRelationSize;
            currentStagedRelationSize = stagedRelations.size();
        }
    }

    private boolean relationContainsMemberWithinBoundary(Relation relation) {
        if (this.relationIdentifiersToInclude.contains(relation.getId())) {
            return true;
        }
        for (RelationMember member : relation.getMembers()) {
            EntityType memberType = member.getMemberType();
            if (memberType == EntityType.Node && this.nodeIdentifiersToInclude.contains(member.getMemberId())) {
                return true;
            }
            if (memberType == EntityType.Way && this.wayIdentifiersToInclude.contains(member.getMemberId())) {
                return true;
            }
            if (memberType != EntityType.Relation || !this.relationIdentifiersToInclude.contains(member.getMemberId())) continue;
            return true;
        }
        return false;
    }

    private boolean shouldLoadOsmNode(Entity entity) {
        return this.loadingOption.isLoadOsmNode() && entity instanceof Node && this.nodeWithinTargetBoundary((Node)entity);
    }

    private boolean shouldLoadOsmRelation(Entity entity) {
        return this.loadingOption.isLoadOsmRelation() && entity instanceof Relation;
    }

    private boolean shouldLoadOsmWay(Entity entity) {
        return this.loadingOption.isLoadOsmWay() && entity instanceof Way;
    }

    private boolean wayContainsNodeWithinBoundary(Way way) {
        for (WayNode node : way.getWayNodes()) {
            if (!this.nodeIdentifiersToInclude.contains(node.getNodeId())) continue;
            this.wayIdentifiersToInclude.add(way.getId());
            return true;
        }
        return false;
    }
}

