/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.packed;

import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.proto.ProtoSerializable;
import org.openstreetmap.atlas.proto.adapters.ProtoAdapter;
import org.openstreetmap.atlas.proto.adapters.ProtoPackedTagStoreAdapter;
import org.openstreetmap.atlas.utilities.arrays.Arrays;
import org.openstreetmap.atlas.utilities.arrays.IntegerArrayOfArrays;
import org.openstreetmap.atlas.utilities.compression.IntegerDictionary;

public class PackedTagStore
implements Serializable,
ProtoSerializable {
    private static final long serialVersionUID = -5240324410665237846L;
    public static final String FIELD_KEYS = "keys";
    public static final String FIELD_VALUES = "values";
    public static final String FIELD_INDEX = "index";
    private final IntegerArrayOfArrays keys;
    private final IntegerArrayOfArrays values;
    private transient IntegerDictionary<String> dictionary;
    private long index = 0L;

    public PackedTagStore() {
        this.keys = null;
        this.values = null;
        this.dictionary = null;
    }

    public PackedTagStore(long maximumSize, int memoryBlockSize, int subArraySize, IntegerDictionary<String> dictionary) {
        this.keys = new IntegerArrayOfArrays(maximumSize, memoryBlockSize, subArraySize);
        this.values = new IntegerArrayOfArrays(maximumSize, memoryBlockSize, subArraySize);
        this.dictionary = dictionary;
    }

    public void add(long index, String key, String value) {
        if (index > this.size()) {
            throw new CoreException("Cannot add. Invalid index {} is bigger than the size {}", index, this.size());
        }
        int keyIndex = this.keysDictionary().add(key);
        int valueIndex = this.valuesDictionary().add(value);
        if (index == this.index) {
            int[] valueArray;
            int[] keyArray;
            if (key == null || value == null) {
                keyArray = new int[]{};
                valueArray = new int[]{};
            } else {
                keyArray = new int[1];
                valueArray = new int[1];
                keyArray[0] = keyIndex;
                valueArray[0] = valueIndex;
            }
            this.keys.add(keyArray);
            this.values.add(valueArray);
            ++this.index;
        } else {
            if (key == null || value == null) {
                return;
            }
            int[] keyArray = Arrays.addNewItem((int[])this.keys.get(index), keyIndex);
            int[] valueArray = Arrays.addNewItem((int[])this.values.get(index), valueIndex);
            this.keys.set(index, keyArray);
            this.values.set(index, valueArray);
        }
    }

    public boolean containsKey(long index, String key) {
        int[] keyArray;
        if (key == null) {
            throw new CoreException("Cannot test if a null key is contained");
        }
        for (int keyIndex : keyArray = (int[])this.keys.get(index)) {
            if (!key.equals(this.keysDictionary().word(keyIndex))) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object other) {
        if (other instanceof PackedTagStore) {
            if (this == other) {
                return true;
            }
            PackedTagStore that = (PackedTagStore)other;
            if (!this.keys.equals(that.keys)) {
                return false;
            }
            if (!this.values.equals(that.values)) {
                return false;
            }
            if (!Objects.equals(this.keysDictionary(), that.keysDictionary())) {
                return false;
            }
            return Objects.equals(this.valuesDictionary(), that.valuesDictionary());
        }
        return false;
    }

    public String get(long index, String key) {
        if (key == null) {
            throw new CoreException("Cannot get a null key's value");
        }
        int[] keyArray = (int[])this.keys.get(index);
        for (int i = 0; i < keyArray.length; ++i) {
            int keyIndex = keyArray[i];
            if (!key.equals(this.keysDictionary().word(keyIndex))) continue;
            int valueIndex = ((int[])this.values.get(index))[i];
            return this.valuesDictionary().word(valueIndex);
        }
        return null;
    }

    @Override
    public ProtoAdapter getProtoAdapter() {
        return new ProtoPackedTagStoreAdapter();
    }

    public int hashCode() {
        int initialPrime = 31;
        int hashSeed = 37;
        int hash = 1147 + this.keys.hashCode();
        hash = 37 * hash + this.values.hashCode();
        int keysDictionaryHash = this.keysDictionary() == null ? 0 : this.keysDictionary().hashCode();
        int valuesDictionaryHash = this.valuesDictionary() == null ? 0 : this.valuesDictionary().hashCode();
        hash = 37 * hash + keysDictionaryHash;
        hash = 37 * hash + valuesDictionaryHash;
        return hash;
    }

    public IntegerDictionary<String> keysDictionary() {
        return this.dictionary;
    }

    public Set<String> keySet(long index) {
        int[] keyArray;
        HashSet<String> result = new HashSet<String>();
        for (int keyIndex : keyArray = (int[])this.keys.get(index)) {
            result.add(this.keysDictionary().word(keyIndex));
        }
        return result;
    }

    public Map<String, String> keyValuePairs(long index) {
        HashMap<String, String> result = new HashMap<String, String>();
        if (this.keys.size() == 0L) {
            return result;
        }
        int[] keyArray = (int[])this.keys.get(index);
        int[] valueArray = (int[])this.values.get(index);
        for (int i = 0; i < keyArray.length; ++i) {
            int keyIndex = keyArray[i];
            int valueIndex = valueArray[i];
            result.put(this.keysDictionary().word(keyIndex), this.valuesDictionary().word(valueIndex));
        }
        return result;
    }

    public void setDictionary(IntegerDictionary<String> dictionary) {
        this.dictionary = dictionary;
    }

    public long size() {
        return this.index;
    }

    public void trim() {
        this.keys.trim();
        this.values.trim();
    }

    public IntegerDictionary<String> valuesDictionary() {
        return this.dictionary;
    }
}

