/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.packed;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.geography.atlas.packed.PackedAtlas;
import org.openstreetmap.atlas.proto.ProtoSerializable;
import org.openstreetmap.atlas.proto.adapters.ProtoAdapter;
import org.openstreetmap.atlas.streaming.CounterOutputStream;
import org.openstreetmap.atlas.streaming.Streams;
import org.openstreetmap.atlas.streaming.resource.ByteArrayResource;
import org.openstreetmap.atlas.streaming.resource.File;
import org.openstreetmap.atlas.streaming.resource.Resource;
import org.openstreetmap.atlas.streaming.resource.WritableResource;
import org.openstreetmap.atlas.streaming.resource.zip.ZipFileWritableResource;
import org.openstreetmap.atlas.streaming.resource.zip.ZipResource;
import org.openstreetmap.atlas.streaming.resource.zip.ZipWritableResource;
import org.openstreetmap.atlas.utilities.collections.Iterables;
import org.openstreetmap.atlas.utilities.collections.MultiIterable;
import org.openstreetmap.atlas.utilities.collections.StreamIterable;
import org.openstreetmap.atlas.utilities.collections.StringList;
import org.openstreetmap.atlas.utilities.time.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PackedAtlasSerializer {
    private static final Logger logger = LoggerFactory.getLogger(PackedAtlasSerializer.class);
    private static final StringList EXCLUDED_FIELDS = new StringList("bounds", "serialVersionUID", "logger", "$SWITCH_TABLE$", "serializer", "saveSerializationFormat", "loadSerializationFormat", "FIELD_", "$jacocoData");
    public static final String META_DATA_ERROR_MESSAGE = "MetaData not here!";
    private final PackedAtlas atlas;
    private final ZipResource source;

    protected static PackedAtlas load(Resource resource) {
        PackedAtlas atlas = new PackedAtlas();
        PackedAtlasSerializer serializer = new PackedAtlasSerializer(atlas, resource);
        serializer.assign();
        PackedAtlasSerializer.determineAtlasLoadFormat(atlas);
        return atlas;
    }

    private static void determineAtlasLoadFormat(PackedAtlas atlas) {
        PackedAtlas.AtlasSerializationFormat[] possibleFormats;
        for (PackedAtlas.AtlasSerializationFormat candidateFormat : possibleFormats = PackedAtlas.AtlasSerializationFormat.values()) {
            logger.debug("Trying load format {}", (Object)candidateFormat);
            atlas.setLoadSerializationFormat(candidateFormat);
            try {
                atlas.metaData();
            }
            catch (CoreException exception) {
                logger.debug("Load format {} invalid", (Object)candidateFormat, (Object)exception);
                continue;
            }
            logger.debug("Using load format {}", (Object)candidateFormat);
            return;
        }
        throw new CoreException("Could not determine a valid load format for atlas");
    }

    protected PackedAtlasSerializer(PackedAtlas atlas, Resource resource) {
        this.atlas = atlas;
        this.source = resource instanceof File && !resource.isGzipped() ? new ZipFileWritableResource((File)resource) : (resource instanceof WritableResource ? new ZipWritableResource((WritableResource)resource) : new ZipResource(resource));
    }

    protected void deserializeIfNeeded(String name) {
        try {
            Field field = this.readField(name);
            Object member = this.getField(field);
            if (member == null) {
                if (this.source == null) {
                    throw new CoreException("The PackedAtlasSerializer has not been properly assigned.");
                }
                this.load(name);
            }
        }
        catch (Exception e) {
            throw new CoreException("Unable to read Atlas field {}", name, e);
        }
    }

    protected void save() {
        if (!(this.source instanceof ZipWritableResource)) {
            throw new CoreException("The ZipResource {} is not writable.", this.source);
        }
        this.atlas.getSerializer().ifPresent(PackedAtlasSerializer::deserializeAllFieldsIfNeeded);
        ZipWritableResource destination = (ZipWritableResource)this.source;
        Field metaData = this.readField("metaData");
        Iterable<Resource> firstResource = Iterables.from(this.fieldTranslator(metaData));
        Iterable<Resource> fieldResources = this.fields().filter(field -> {
            String fieldName = field.getName();
            return !"metaData".equals(fieldName) && !EXCLUDED_FIELDS.startsWithContains(fieldName);
        }).map(this::fieldTranslator).collect();
        MultiIterable result = new MultiIterable(firstResource, fieldResources);
        destination.writeAndClose(result);
    }

    private void assign() {
        this.setField(this.readField("serializer"), this);
    }

    private boolean canLoadWithRandomAccess() {
        return this.source instanceof ZipFileWritableResource;
    }

    private OutputStream compress(OutputStream out) throws IOException {
        return out;
    }

    private InputStream decompress(InputStream input) throws IOException {
        return input;
    }

    private void deserializeAllFields() {
        Iterables.stream(this.source.entries()).forEach(resource -> {
            String name = resource.getName();
            try {
                Field field = this.readField(name);
                Object value = this.deserializeResource((Resource)resource, name);
                this.setField(field, value);
            }
            catch (MissingFieldException e) {
                this.deserializeJavaResource((Resource)resource);
            }
        });
    }

    private void deserializeAllFieldsIfNeeded() {
        this.fields().map(Field::getName).forEach(this::deserializeIfNeeded);
    }

    private Object deserializeJavaResource(Resource resource) {
        Object object;
        ObjectInputStream input = new ObjectInputStream(this.decompress(resource.read()));
        try {
            Time start = Time.now();
            Object result = input.readObject();
            Streams.close(input);
            logger.trace("Loaded Field {} from {} in {}", new Object[]{resource.getName(), this.source, start.elapsedSince()});
            object = result;
        }
        catch (Throwable throwable) {
            try {
                try {
                    input.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new CoreException("Could not load Field {} from {}", resource.getName(), this.source, e);
            }
        }
        input.close();
        return object;
    }

    private Object deserializeProtoResource(Resource resource, String fieldName) {
        Field field = this.readField(fieldName);
        Class<?> fieldClass = field.getType();
        Constructor<?> fieldClassConstructor = null;
        try {
            fieldClassConstructor = fieldClass.getDeclaredConstructor(new Class[0]);
        }
        catch (Exception exception) {
            throw new CoreException("Class {} does not implement a nullary constructor", fieldClass.getName(), exception);
        }
        fieldClassConstructor.setAccessible(true);
        Object handle = null;
        try {
            handle = fieldClassConstructor.newInstance(new Object[0]);
        }
        catch (Exception exception) {
            throw new CoreException("Failed to create instance of {}", fieldClass.getName(), exception);
        }
        ProtoSerializable protoHandle = null;
        try {
            protoHandle = handle;
        }
        catch (ClassCastException exception) {
            throw new CoreException("{} is not ProtoSerializable", fieldClass.getName(), exception);
        }
        ProtoAdapter adapter = protoHandle.getProtoAdapter();
        ProtoSerializable deserializedMember = adapter.deserialize(resource.readBytesAndClose());
        return deserializedMember;
    }

    private Object deserializeResource(Resource resource, String fieldName) {
        PackedAtlas.AtlasSerializationFormat loadFormat = this.atlas.getLoadSerializationFormat();
        switch (loadFormat) {
            case JAVA: {
                return this.deserializeJavaResource(resource);
            }
            case PROTOBUF: {
                return this.deserializeProtoResource(resource, fieldName);
            }
        }
        throw new CoreException("Unsupported serialization format {}", loadFormat.toString());
    }

    private void deserializeSingleField(String name) {
        Object result;
        if (this.canLoadWithRandomAccess()) {
            Resource resource = ((ZipFileWritableResource)this.source).entryForName(name);
            result = this.deserializeResource(resource, name);
        } else if ("metaData".equals(name)) {
            Iterable<Resource> resources = this.source.entries();
            try (ZipResource.ZipIterator iterator = (ZipResource.ZipIterator)resources.iterator();){
                Resource resource = iterator.next();
                if (resource == null) {
                    throw new CoreException(META_DATA_ERROR_MESSAGE);
                }
                result = this.deserializeResource(resource, name);
            }
        } else {
            throw new CoreException("Cannot deserialize a specific field without a ZipFileWritableResource");
        }
        this.setField(this.readField(name), result);
    }

    private StreamIterable<Field> fields() {
        return Iterables.stream(Iterables.from(PackedAtlas.class.getDeclaredFields())).filter(field -> !EXCLUDED_FIELDS.startsWithContains(field.getName())).map(field -> {
            field.setAccessible(true);
            return field;
        });
    }

    private Resource fieldTranslator(Field field) {
        PackedAtlas.AtlasSerializationFormat saveFormat = this.atlas.getSaveSerializationFormat();
        switch (saveFormat) {
            case JAVA: {
                Object objectCandidate = this.getField(field);
                return this.makeJavaResource(objectCandidate, field.getName());
            }
            case PROTOBUF: {
                ProtoSerializable protoCandidate = (ProtoSerializable)this.getField(field);
                return this.makeProtoResource(protoCandidate, field.getName());
            }
        }
        throw new CoreException("Unsupported serialization format {}", saveFormat.toString());
    }

    private Object getField(Field field) {
        try {
            return field.get(this.atlas);
        }
        catch (Exception e) {
            throw new CoreException("Unable to access field {} for {}", field.getName(), this.atlas.getName(), e);
        }
    }

    private void load(String name) {
        if (this.canLoadWithRandomAccess() || "metaData".equals(name)) {
            this.deserializeSingleField(name);
        } else {
            this.deserializeAllFields();
        }
    }

    private Resource makeJavaResource(Object field, String name) {
        CounterOutputStream counterOutputStream = new CounterOutputStream();
        try (ObjectOutputStream outCounter = new ObjectOutputStream(this.compress(new BufferedOutputStream(counterOutputStream)));){
            outCounter.writeObject(field);
        }
        catch (Exception e) {
            throw new CoreException("Could not count the size of {}.", field, e);
        }
        long count = counterOutputStream.getCount();
        ByteArrayResource resource = new ByteArrayResource(count).withName(name);
        logger.trace("Saving field {}", (Object)resource.getName());
        if (field == null) {
            logger.warn("Field {} is null in atlas {} of size {}", new Object[]{name, this.atlas.getName(), this.atlas.size()});
            return resource;
        }
        try (ObjectOutputStream out = new ObjectOutputStream(this.compress(new BufferedOutputStream(resource.write())));){
            out.writeObject(field);
        }
        catch (Exception e) {
            throw new CoreException("Could not convert {} to a readable resource.", field, e);
        }
        return resource;
    }

    private Resource makeProtoResource(ProtoSerializable field, String name) {
        ProtoAdapter adapter = field.getProtoAdapter();
        byte[] byteContents = adapter.serialize(field);
        ByteArrayResource resource = new ByteArrayResource(byteContents.length).withName(name);
        try (BufferedOutputStream out = new BufferedOutputStream(resource.write());){
            out.write(byteContents);
        }
        catch (Exception e) {
            throw new CoreException("Could not convert {} to a readable resource.", field, e);
        }
        return resource;
    }

    private Field readField(String name) throws MissingFieldException {
        try {
            Field result = PackedAtlas.class.getDeclaredField(name);
            result.setAccessible(true);
            return result;
        }
        catch (NoSuchFieldException e) {
            logger.warn("Unable to access field {}", (Object)name);
            throw new MissingFieldException("Unable to access field {}", name, e);
        }
    }

    private void setField(Field field, Object object) {
        try {
            field.set(this.atlas, object);
        }
        catch (Exception e) {
            throw new CoreException("Cannot set field {} for Atlas {}", field.getName(), this.atlas.getName(), e);
        }
    }

    private static class MissingFieldException
    extends CoreException {
        private static final long serialVersionUID = 6780849464228478451L;

        MissingFieldException(String message) {
            super(message);
        }

        MissingFieldException(String message, Object ... items) {
            super(message, items);
        }

        MissingFieldException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

