/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.packed;

import java.util.Map;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.geography.Location;
import org.openstreetmap.atlas.geography.PolyLine;
import org.openstreetmap.atlas.geography.Polygon;
import org.openstreetmap.atlas.geography.atlas.Atlas;
import org.openstreetmap.atlas.geography.atlas.AtlasMetaData;
import org.openstreetmap.atlas.geography.atlas.builder.AtlasBuilder;
import org.openstreetmap.atlas.geography.atlas.builder.AtlasSize;
import org.openstreetmap.atlas.geography.atlas.builder.RelationBean;
import org.openstreetmap.atlas.geography.atlas.exception.AtlasIntegrityException;
import org.openstreetmap.atlas.geography.atlas.items.AtlasItem;
import org.openstreetmap.atlas.geography.atlas.items.Relation;
import org.openstreetmap.atlas.geography.atlas.items.RelationMember;
import org.openstreetmap.atlas.geography.atlas.packed.PackedAtlas;
import org.openstreetmap.atlas.utilities.collections.Iterables;
import org.openstreetmap.atlas.utilities.scalars.Distance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PackedAtlasBuilder
implements AtlasBuilder {
    private static final Logger logger = LoggerFactory.getLogger(PackedAtlasBuilder.class);
    private static final int MAXIMUM_RELATION_MEMBER_DEPTH = 500;
    private static final Distance NODE_SEARCH_DISTANCE = Distance.ONE_METER;
    private static final Distance NODE_TOLERANCE_DISTANCE = Distance.meters(0.1);
    private PackedAtlas atlas;
    private AtlasSize sizeEstimates = AtlasSize.DEFAULT;
    private boolean locked = false;
    private String name;
    private AtlasMetaData metaData = new AtlasMetaData();

    @Override
    public void addArea(long identifier, Polygon geometry, Map<String, String> tags) {
        this.initialize();
        try {
            this.atlas.addArea(identifier, geometry, tags);
        }
        catch (Exception e) {
            logger.error("Error adding Area ({}): {}", new Object[]{identifier, geometry.toWkt(), e});
        }
    }

    @Override
    public void addEdge(long identifier, PolyLine geometry, Map<String, String> tags) {
        this.initialize();
        Location start = geometry.first();
        Location end = geometry.last();
        Long startNodeIdentifier = this.atlas.nodeIdentifierForLocation(start);
        Long endNodeIdentifier = this.atlas.nodeIdentifierForLocation(end);
        if (startNodeIdentifier == null) {
            startNodeIdentifier = this.atlas.nodeIdentifierForEnlargedLocation(start, NODE_SEARCH_DISTANCE, NODE_TOLERANCE_DISTANCE);
            if (startNodeIdentifier == null) {
                throw new AtlasIntegrityException("Atlas does not contain Node for Location {} for edge {}", start, identifier);
            }
            logger.warn("Atlas does not contain Node for Location {} for edge {}. Found very close node {} and using it instead.", new Object[]{start, identifier, startNodeIdentifier});
        }
        if (endNodeIdentifier == null) {
            endNodeIdentifier = this.atlas.nodeIdentifierForEnlargedLocation(end, NODE_SEARCH_DISTANCE, NODE_TOLERANCE_DISTANCE);
            if (endNodeIdentifier == null) {
                throw new AtlasIntegrityException("Atlas does not contain Node for Location {} for edge {}", end, identifier);
            }
            logger.warn("Atlas does not contain Node for Location {} for edge {}. Found very close node {} and using it instead.", new Object[]{end, identifier, endNodeIdentifier});
        }
        try {
            this.atlas.addEdge(identifier, startNodeIdentifier, endNodeIdentifier, geometry, tags);
        }
        catch (AtlasIntegrityException e) {
            throw e;
        }
        catch (Exception e) {
            logger.error("Error adding Edge ({}): {}", new Object[]{identifier, geometry.toWkt(), e});
        }
    }

    @Override
    public void addLine(long identifier, PolyLine geometry, Map<String, String> tags) {
        this.initialize();
        try {
            this.atlas.addLine(identifier, geometry, tags);
        }
        catch (AtlasIntegrityException e) {
            throw e;
        }
        catch (Exception e) {
            logger.error("Error adding Line ({}): {}", new Object[]{identifier, geometry.toWkt(), e});
        }
    }

    @Override
    public void addNode(long identifier, Location geometry, Map<String, String> tags) {
        this.initialize();
        try {
            this.atlas.addNode(identifier, geometry, tags);
        }
        catch (AtlasIntegrityException e) {
            throw e;
        }
        catch (Exception e) {
            logger.error("Error adding Node ({}): {}", new Object[]{identifier, geometry.toWkt(), e});
        }
    }

    @Override
    public void addPoint(long identifier, Location geometry, Map<String, String> tags) {
        this.initialize();
        try {
            this.atlas.addPoint(identifier, geometry, tags);
        }
        catch (AtlasIntegrityException e) {
            throw e;
        }
        catch (Exception e) {
            logger.error("Error adding Point ({}): {}", new Object[]{identifier, geometry.toWkt(), e});
        }
    }

    @Override
    public void addRelation(long identifier, long osmIdentifier, RelationBean structure, Map<String, String> tags) {
        if (structure.isEmpty()) {
            throw new CoreException("Cannot add relation {} with an empty member list.", identifier);
        }
        this.initialize();
        try {
            this.atlas.addRelation(identifier, osmIdentifier, structure.getMemberIdentifiers(), structure.getMemberTypes(), structure.getMemberRoles(), tags);
        }
        catch (AtlasIntegrityException e) {
            throw e;
        }
        catch (Exception e) {
            logger.error("Error adding Relation ({}): {}", new Object[]{identifier, structure.toString(), e});
        }
    }

    @Override
    public Atlas get() {
        this.initialize();
        this.locked = true;
        if (this.atlas.isEmpty()) {
            logger.warn("An Atlas is Located, and therefore cannot be empty.");
            return null;
        }
        if (Iterables.size(this.atlas) == this.atlas.numberOfRelations()) {
            logger.warn("An Atlas is Located, and therefore cannot be made of only relations (which cannot be loacted as there are no other features).");
            return null;
        }
        this.verifyNegativeEdgesHaveMasterEdge();
        this.atlas.relations().forEach(relation -> {
            try {
                this.validateRelation((Relation)relation, relation.getIdentifier(), 0);
            }
            catch (Exception e) {
                throw new CoreException("Relation {} is corrupted. Invalidating Atlas!", relation.getIdentifier(), e);
            }
        });
        AtlasSize updatedAtlasSize = new AtlasSize(this.atlas.numberOfEdges(), this.atlas.numberOfNodes(), this.atlas.numberOfAreas(), this.atlas.numberOfLines(), this.atlas.numberOfPoints(), this.atlas.numberOfRelations());
        this.atlas.setMetaData(this.metaData.copyWithNewSize(updatedAtlasSize));
        return this.atlas;
    }

    public PackedAtlas peek() {
        this.initialize();
        return this.atlas;
    }

    @Override
    public void setMetaData(AtlasMetaData metaData) {
        this.metaData = metaData;
    }

    @Override
    public void setSizeEstimates(AtlasSize estimates) {
        this.sizeEstimates = estimates;
    }

    public PackedAtlasBuilder withMetaData(AtlasMetaData metaData) {
        this.setMetaData(metaData);
        return this;
    }

    public PackedAtlasBuilder withName(String name) {
        this.name = name;
        return this;
    }

    public PackedAtlasBuilder withSizeEstimates(AtlasSize estimates) {
        this.setSizeEstimates(estimates);
        return this;
    }

    private void initialize() {
        if (this.locked) {
            throw new CoreException("Cannot keep adding items to a locked graph.");
        }
        if (this.atlas == null) {
            this.atlas = new PackedAtlas(this.sizeEstimates);
            this.atlas.setName(this.name);
        }
    }

    private void validateRelation(Relation relation, long parentIdentifier, int depth) {
        if (depth > 500) {
            throw new CoreException("Relation {} referencing each other more than {} levels deep, without hitting any bounded feature.", parentIdentifier, 500);
        }
        for (RelationMember member : relation.members()) {
            if (member.getEntity() instanceof AtlasItem) {
                return;
            }
            this.validateRelation((Relation)member.getEntity(), parentIdentifier, depth + 1);
        }
    }

    private void verifyNegativeEdgesHaveMasterEdge() {
        this.atlas.edges().forEach(edge -> {
            long edgeIdentifier = edge.getIdentifier();
            if (edgeIdentifier < 0L && this.atlas.edge(-edgeIdentifier) == null) {
                throw new AtlasIntegrityException("Cannot build an Atlas with a negative edge without its positive counterpart: {}", edgeIdentifier);
            }
        });
    }
}

