/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.multi;

import java.util.ArrayList;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.geography.Location;
import org.openstreetmap.atlas.geography.atlas.Atlas;
import org.openstreetmap.atlas.geography.atlas.items.Edge;
import org.openstreetmap.atlas.geography.atlas.items.Route;
import org.openstreetmap.atlas.utilities.collections.StringList;

public class TemporaryRoad {
    private final SortedSet<Edge> members = new TreeSet<Edge>();
    private final long osmIdentifier;
    private final Atlas subAtlas;
    private Route route;

    public TemporaryRoad(Atlas subAtlas, long osmIdentifier) {
        this.subAtlas = subAtlas;
        this.osmIdentifier = osmIdentifier;
    }

    public void add(Edge edge) {
        if (this.route != null) {
            throw new CoreException("Cannot add new edges when the route has already been created");
        }
        if (edge.getIdentifier() < 0L) {
            return;
        }
        if (this.subAtlas != edge.getAtlas()) {
            throw new CoreException("Cannot add an edge that is not from the right Atlas");
        }
        this.members.add(edge);
    }

    public Set<Edge> getMembers() {
        return this.members;
    }

    public Route getRoute() {
        if (this.route == null) {
            this.route = Route.fromNonArrangedEdgeSet(this.members, false);
        }
        return this.route;
    }

    public Iterable<Location> locations() {
        ArrayList<Location> locations = new ArrayList<Location>();
        boolean processedFirstEdge = false;
        for (Edge member : this.getMembers()) {
            boolean isFirstNode = true;
            for (Location location : member.getRawGeometry()) {
                if (processedFirstEdge && isFirstNode) {
                    isFirstNode = false;
                    continue;
                }
                locations.add(location);
            }
            processedFirstEdge = true;
        }
        return locations;
    }

    public String toString() {
        StringList memberList = new StringList();
        this.members.forEach(member -> memberList.add(member.toString()));
        return "[TemporaryRoad: subAtlas = " + this.subAtlas.getName() + ", osm = " + this.osmIdentifier + ", members = \n\t" + memberList.join("\n\t") + "\n]";
    }
}

