/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.multi;

import org.openstreetmap.atlas.geography.atlas.items.Node;
import org.openstreetmap.atlas.utilities.scalars.Ratio;

public class TemporaryOrderedNode
implements Comparable<TemporaryOrderedNode> {
    private final long nodeIdentifier;
    private final Node node;
    private final Ratio offset;
    private final int occurrenceIndex;

    public TemporaryOrderedNode(Node node, Ratio offset, int occurrenceIndex) {
        this.nodeIdentifier = node.getIdentifier();
        this.node = node;
        this.offset = offset;
        this.occurrenceIndex = occurrenceIndex;
    }

    @Override
    public int compareTo(TemporaryOrderedNode other) {
        double delta = this.getOffset().asRatio() - other.getOffset().asRatio();
        return delta > 0.0 ? 1 : (delta < 0.0 ? -1 : 0);
    }

    public boolean equals(Object other) {
        if (other instanceof TemporaryOrderedNode) {
            TemporaryOrderedNode that = (TemporaryOrderedNode)other;
            return this.node.getLocation().equals(that.node.getLocation()) && this.offset.equals(that.offset) && this.occurrenceIndex == that.getOccurrenceIndex();
        }
        return false;
    }

    public Node getNode() {
        return this.node;
    }

    public long getNodeIdentifier() {
        return this.nodeIdentifier;
    }

    public int getOccurrenceIndex() {
        return this.occurrenceIndex;
    }

    public Ratio getOffset() {
        return this.offset;
    }

    public int hashCode() {
        return this.node.hashCode() + this.occurrenceIndex;
    }

    public String toString() {
        return "[TemporaryOrderedNode: id = " + this.nodeIdentifier + " (" + this.node.getLocation() + "), offset = " + this.offset + ", occurrence = " + this.occurrenceIndex + "]";
    }
}

