/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.multi;

import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.openstreetmap.atlas.geography.PolyLine;
import org.openstreetmap.atlas.geography.atlas.items.Edge;
import org.openstreetmap.atlas.geography.atlas.items.Node;
import org.openstreetmap.atlas.geography.atlas.items.Relation;
import org.openstreetmap.atlas.geography.atlas.multi.MultiAtlas;
import org.openstreetmap.atlas.geography.atlas.multi.MultiNode;

public class MultiEdge
extends Edge {
    private static final long serialVersionUID = -3986525201031430336L;
    private final long identifier;
    private Edge subEdge;

    protected MultiEdge(MultiAtlas atlas, long identifier) {
        super(atlas);
        this.identifier = identifier;
    }

    @Override
    public PolyLine asPolyLine() {
        return this.getSubEdge().asPolyLine();
    }

    @Override
    public Node end() {
        return new MultiNode(this.multiAtlas(), this.masteriseNodeIdentifier(this.getSubEdge().end().getIdentifier()));
    }

    @Override
    public long getIdentifier() {
        return this.identifier;
    }

    @Override
    public Map<String, String> getTags() {
        return this.getSubEdge().getTags();
    }

    @Override
    public Set<Relation> relations() {
        return this.multiAtlas().multifyRelations(this.getSubEdge());
    }

    @Override
    public Node start() {
        return new MultiNode(this.multiAtlas(), this.masteriseNodeIdentifier(this.getSubEdge().start().getIdentifier()));
    }

    private Edge getSubEdge() {
        if (this.subEdge == null) {
            this.subEdge = this.multiAtlas().subEdge(this.identifier);
        }
        return this.subEdge;
    }

    private Long masteriseNodeIdentifier(long identifier) {
        Optional<Long> masterNodeIdentifier = this.multiAtlas().masterNode(identifier);
        if (masterNodeIdentifier.isPresent()) {
            return masterNodeIdentifier.get();
        }
        return identifier;
    }

    private MultiAtlas multiAtlas() {
        return (MultiAtlas)this.getAtlas();
    }
}

