/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.multi;

import com.google.common.collect.Sets;
import java.util.AbstractSet;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.openstreetmap.atlas.geography.Polygon;
import org.openstreetmap.atlas.geography.atlas.items.Area;
import org.openstreetmap.atlas.geography.atlas.items.Relation;
import org.openstreetmap.atlas.geography.atlas.multi.MultiAtlas;
import org.openstreetmap.atlas.geography.atlas.multi.SubAreaList;

public class MultiArea
extends Area {
    private static final long serialVersionUID = 4710025391581335160L;
    private final long identifier;
    private SubAreaList subAreaList;

    protected MultiArea(MultiAtlas atlas, long identifier) {
        super(atlas);
        this.identifier = identifier;
    }

    @Override
    public Polygon asPolygon() {
        return this.getRepresentativeSubArea().asPolygon();
    }

    @Override
    public long getIdentifier() {
        return this.identifier;
    }

    public SubAreaList getSubAreas() {
        if (this.subAreaList == null) {
            this.subAreaList = this.multiAtlas().subAreas(this.identifier);
        }
        return this.subAreaList;
    }

    @Override
    public Map<String, String> getTags() {
        return this.getRepresentativeSubArea().getTags();
    }

    @Override
    public Set<Relation> relations() {
        AbstractSet unionOfAllParentRelations = new HashSet<Relation>();
        for (Area subArea : this.getSubAreas().getSubAreas()) {
            Set<Relation> currentSubAreaParentRelations = this.multiAtlas().multifyRelations(subArea);
            unionOfAllParentRelations = Sets.union(unionOfAllParentRelations, currentSubAreaParentRelations);
        }
        return unionOfAllParentRelations;
    }

    private Area getRepresentativeSubArea() {
        return this.getSubAreas().getSubAreas().get(0);
    }

    private MultiAtlas multiAtlas() {
        return (MultiAtlas)this.getAtlas();
    }
}

