/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.items.complex.islands;

import java.util.Map;
import java.util.Set;
import org.openstreetmap.atlas.geography.atlas.Atlas;
import org.openstreetmap.atlas.geography.atlas.items.Relation;
import org.openstreetmap.atlas.geography.atlas.items.complex.Finder;
import org.openstreetmap.atlas.geography.atlas.items.complex.islands.ComplexIsland;
import org.openstreetmap.atlas.geography.atlas.items.complex.waters.ComplexWaterEntityFinder;
import org.openstreetmap.atlas.streaming.resource.File;
import org.openstreetmap.atlas.streaming.resource.InputStreamResource;
import org.openstreetmap.atlas.utilities.collections.Iterables;
import org.openstreetmap.atlas.utilities.collections.Sets;
import org.openstreetmap.atlas.utilities.configuration.Configuration;
import org.openstreetmap.atlas.utilities.configuration.ConfigurationReader;
import org.openstreetmap.atlas.utilities.configuration.ConfiguredFilter;
import org.openstreetmap.atlas.utilities.configuration.StandardConfiguration;

public class ComplexIslandFinder
implements Finder<ComplexIsland> {
    private final Configuration configuration;
    private final Set<String> validWaterTypes;
    private static final Set<String> ACCEPTABLE_WATER_FEATURES = Sets.hashSet("lake", "river", "reservoir");

    public ComplexIslandFinder() {
        this.configuration = new StandardConfiguration(new InputStreamResource(() -> ComplexWaterEntityFinder.class.getResourceAsStream("water-handlers.json")));
        this.validWaterTypes = this.getWaterTypesFromConfiguration();
    }

    public ComplexIslandFinder(String resource) {
        this.configuration = new StandardConfiguration(new File(resource));
        this.validWaterTypes = this.getWaterTypesFromConfiguration();
    }

    private Set<String> getWaterTypesFromConfiguration() {
        Set validWaterTypes = new ConfigurationReader("global.filters").configurationValue(this.configuration, Map::keySet);
        validWaterTypes.retainAll(ACCEPTABLE_WATER_FEATURES);
        return validWaterTypes;
    }

    private boolean testWaterType(Relation relation) {
        return this.validWaterTypes.stream().anyMatch(type -> ConfiguredFilter.from(type, this.configuration).test(relation));
    }

    @Override
    public Iterable<ComplexIsland> find(Atlas atlas) {
        Iterable<Relation> relations = atlas.relations(relation -> relation.isMultiPolygon() && relation.hasMultiPolygonMembers(Relation.Ring.INNER) && this.testWaterType((Relation)relation));
        return Iterables.translate(relations, ComplexIsland::new);
    }
}

