/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.items.complex.buildings.converters;

import org.openstreetmap.atlas.geography.atlas.Atlas;
import org.openstreetmap.atlas.geography.atlas.AtlasResourceLoader;
import org.openstreetmap.atlas.geography.atlas.items.complex.buildings.ComplexBuildingFinder;
import org.openstreetmap.atlas.geography.geojson.GeoJsonSaver;
import org.openstreetmap.atlas.streaming.resource.File;
import org.openstreetmap.atlas.streaming.resource.WritableResource;
import org.openstreetmap.atlas.utilities.collections.Iterables;
import org.openstreetmap.atlas.utilities.runtime.Command;
import org.openstreetmap.atlas.utilities.runtime.CommandMap;

public class ComplexBuildingToGeojsonConverter
extends Command {
    public static final Command.Switch<Atlas> ATLAS_FOLDER = new Command.Switch("atlasFolder", "Folder containing the Atlas files to transcribe", value -> new AtlasResourceLoader().load(new File((String)value)), Command.Optionality.REQUIRED);
    public static final Command.Switch<File> OUTPUT = new Command.Switch("output", "The output GeoJson file", value -> new File((String)value), Command.Optionality.REQUIRED);

    public static void main(String[] args) {
        new ComplexBuildingToGeojsonConverter().run(args);
    }

    @Override
    protected int onRun(CommandMap command) {
        Atlas atlas = (Atlas)command.get(ATLAS_FOLDER);
        File output = (File)command.get(OUTPUT);
        Iterable shapes = Iterables.translateMulti(new ComplexBuildingFinder().find(atlas), building -> building.getOutline().outers());
        GeoJsonSaver.save(shapes, (WritableResource)output);
        return 0;
    }

    @Override
    protected Command.SwitchList switches() {
        return new Command.SwitchList().with(ATLAS_FOLDER, OUTPUT);
    }
}

