/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.items.complex.buildings;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.geography.Altitude;
import org.openstreetmap.atlas.geography.MultiPolygon;
import org.openstreetmap.atlas.geography.atlas.items.Area;
import org.openstreetmap.atlas.geography.atlas.items.AtlasEntity;
import org.openstreetmap.atlas.geography.atlas.items.Relation;
import org.openstreetmap.atlas.geography.atlas.items.RelationMember;
import org.openstreetmap.atlas.geography.atlas.items.complex.ComplexEntity;
import org.openstreetmap.atlas.geography.atlas.items.complex.RelationOrAreaToMultiPolygonConverter;
import org.openstreetmap.atlas.geography.atlas.items.complex.buildings.BuildingPart;
import org.openstreetmap.atlas.geography.atlas.items.complex.buildings.HeightConverter;
import org.openstreetmap.atlas.tags.BuildingLevelsTag;
import org.openstreetmap.atlas.tags.BuildingMinLevelTag;
import org.openstreetmap.atlas.tags.MinHeightTag;
import org.openstreetmap.atlas.utilities.scalars.Distance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComplexBuilding
extends ComplexEntity {
    private static final long serialVersionUID = 5351464852316720525L;
    private static final Logger logger = LoggerFactory.getLogger(ComplexBuilding.class);
    private static final RelationOrAreaToMultiPolygonConverter RELATION_OR_AREA_TO_MULTI_POLYGON_CONVERTER = new RelationOrAreaToMultiPolygonConverter();
    private static final HeightConverter HEIGHT_CONVERTER = new HeightConverter();
    private final Set<BuildingPart> buildingParts = new HashSet<BuildingPart>();
    private MultiPolygon outline = null;
    private AtlasEntity outlineSource;
    private Set<Long> containedOSMIDs = new HashSet<Long>();

    protected ComplexBuilding(AtlasEntity source) {
        super(source);
        try {
            this.populateBuildingPartsAndOutline();
        }
        catch (Exception e) {
            this.setInvalidReason("Unable to create complex building", e);
            logger.warn("Unable to create complex building from {}", (Object)source, (Object)e);
            return;
        }
    }

    public Optional<Altitude> baseHeight() {
        return MinHeightTag.get(this.getSource());
    }

    public boolean containsOSMIdentifier(long identifier) {
        return this.containedOSMIDs.contains(identifier);
    }

    @Override
    public List<ComplexEntity.ComplexEntityError> getAllInvalidations() {
        ArrayList<ComplexEntity.ComplexEntityError> returnValue = new ArrayList<ComplexEntity.ComplexEntityError>();
        if (!this.isValid()) {
            this.getError().ifPresent(returnValue::add);
            this.buildingParts.stream().filter(part -> !part.isValid()).map(ComplexEntity::getAllInvalidations).flatMap(Collection::stream).forEach(returnValue::add);
        }
        return returnValue;
    }

    public Set<BuildingPart> getBuildingParts() {
        return this.buildingParts;
    }

    public MultiPolygon getOutline() {
        return this.outline;
    }

    public AtlasEntity getOutlineSource() {
        return this.outlineSource;
    }

    @Override
    public boolean isValid() {
        if (super.isValid()) {
            for (BuildingPart part : this.buildingParts) {
                if (part.isValid()) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public Optional<Double> levels() {
        return BuildingLevelsTag.get(this.getSource());
    }

    public Optional<Double> minimumLevel() {
        return BuildingMinLevelTag.get(this.getSource());
    }

    public Optional<Distance> topHeight() {
        Map<String, String> tags = this.getSource().getTags();
        String heightTag = tags.get("height");
        try {
            if (heightTag != null) {
                return Optional.of(HEIGHT_CONVERTER.convert(heightTag));
            }
            tags = this.outlineSource.getTags();
            heightTag = tags.get("height");
            if (heightTag != null) {
                return Optional.of(HEIGHT_CONVERTER.convert(heightTag));
            }
        }
        catch (Exception e) {
            logger.warn("Invalid height {} for building id {}", (Object)heightTag, (Object)this.getSource().getIdentifier());
        }
        return Optional.empty();
    }

    @Override
    public String toString() {
        StringBuilder parts = new StringBuilder();
        for (BuildingPart part : this.buildingParts) {
            parts.append(part);
        }
        return String.format("[ComplexBuilding:\n\tOutline = %s,\n\tParts = %s]", this.outline == null ? "MISSING" : this.outline.toReadableString(), parts.toString());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void populateBuildingPartsAndOutline() {
        this.containedOSMIDs.add(this.getOsmIdentifier());
        AtlasEntity source = this.getSource();
        if (source instanceof Area) {
            this.outline = RELATION_OR_AREA_TO_MULTI_POLYGON_CONVERTER.convert(source);
            this.outlineSource = source;
        } else {
            if (!(source instanceof Relation)) throw new CoreException("A building can only be made of a Relation or an Area. This was a {}", source.getClass().getName());
            Relation relation = (Relation)source;
            String type = relation.tag("type");
            if ("multipolygon".equals(type)) {
                this.outline = RELATION_OR_AREA_TO_MULTI_POLYGON_CONVERTER.convert(relation);
                this.outlineSource = relation;
            } else {
                if (!"building".equals(type)) throw new CoreException("A building relation can only be of type=multipolygon or type=building");
                for (RelationMember member : relation.members()) {
                    this.containedOSMIDs.add(member.getEntity().getOsmIdentifier());
                    if (!"outline".equals(member.getRole())) continue;
                    this.outline = RELATION_OR_AREA_TO_MULTI_POLYGON_CONVERTER.convert(member.getEntity());
                    this.outlineSource = member.getEntity();
                }
                if (this.outline == null) {
                    throw new CoreException("Building part relation does not contain a building outline member");
                }
                for (RelationMember member : relation.members()) {
                    this.containedOSMIDs.add(member.getEntity().getOsmIdentifier());
                    if (!"part".equals(member.getRole())) continue;
                    this.buildingParts.add(new BuildingPart(member.getEntity()));
                }
            }
        }
        if (this.outline.outers().isEmpty()) {
            throw new CoreException("A building cannot have no geometry.");
        }
        try {
            this.outline.surface();
            return;
        }
        catch (IllegalArgumentException oops) {
            throw new CoreException("Negative surface area", oops);
        }
    }
}

