/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.items.complex.aoi;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.geography.MultiPolygon;
import org.openstreetmap.atlas.geography.atlas.items.Area;
import org.openstreetmap.atlas.geography.atlas.items.AtlasEntity;
import org.openstreetmap.atlas.geography.atlas.items.Relation;
import org.openstreetmap.atlas.geography.atlas.items.complex.ComplexEntity;
import org.openstreetmap.atlas.geography.atlas.items.complex.RelationOrAreaToMultiPolygonConverter;
import org.openstreetmap.atlas.tags.Taggable;
import org.openstreetmap.atlas.tags.filters.TaggableFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ComplexAreaOfInterest
extends ComplexEntity {
    private static final Logger logger = LoggerFactory.getLogger(ComplexAreaOfInterest.class);
    private static final RelationOrAreaToMultiPolygonConverter RELATION_OR_AREA_TO_MULTI_POLYGON_CONVERTER = new RelationOrAreaToMultiPolygonConverter();
    private static final String AOI_RESOURCE = "aoi-tag-filter.json";
    private MultiPolygon multiPolygon;
    private static List<TaggableFilter> defaultTaggableFilter;

    public static Optional<ComplexAreaOfInterest> getComplexAOI(AtlasEntity source) {
        return ComplexAreaOfInterest.getComplexAOI(source, customAoiFilter -> false);
    }

    public static Optional<ComplexAreaOfInterest> getComplexAOI(AtlasEntity source, Predicate<Taggable> aoiFilter) {
        try {
            if (defaultTaggableFilter == null) {
                ComplexAreaOfInterest.computeDefaultFilter();
            }
            return !(!(source instanceof Relation) && !(source instanceof Area) || !ComplexAreaOfInterest.hasAOITag(source) && !aoiFilter.test(source)) ? Optional.of(new ComplexAreaOfInterest(source)) : Optional.empty();
        }
        catch (Exception exception) {
            logger.warn("Unable to create complex AOI relations from {}", (Object)source, (Object)exception);
            return Optional.empty();
        }
    }

    private static void computeDefaultFilter() {
        try (InputStreamReader reader = new InputStreamReader(ComplexAreaOfInterest.class.getResourceAsStream(AOI_RESOURCE));){
            JsonElement element = new JsonParser().parse(reader);
            JsonArray filters = element.getAsJsonObject().get("filters").getAsJsonArray();
            defaultTaggableFilter = StreamSupport.stream(filters.spliterator(), false).map(jsonElement -> TaggableFilter.forDefinition(jsonElement.getAsString())).collect(Collectors.toList());
        }
        catch (Exception exception) {
            throw new CoreException("There was a problem parsing aoi-tag-filter.json. Check if the JSON file has valid structure.", exception);
        }
    }

    private static boolean hasAOITag(AtlasEntity source) {
        return defaultTaggableFilter.stream().anyMatch(taggableFilter -> taggableFilter.test(source));
    }

    private ComplexAreaOfInterest(AtlasEntity source) {
        super(source);
        try {
            this.multiPolygon = RELATION_OR_AREA_TO_MULTI_POLYGON_CONVERTER.convert(source);
        }
        catch (Exception exception) {
            this.setInvalidReason("Unable to convert the AtlasEntity to MultiPolygon", exception);
            throw new CoreException("Unable to convert the AtlasEntity to MultiPolygon", exception);
        }
    }

    @Override
    public String toString() {
        return this.getClass().getName() + " " + this.getSource();
    }

    public MultiPolygon getGeometry() {
        return this.multiPolygon;
    }

    @Override
    public List<ComplexEntity.ComplexEntityError> getAllInvalidations() {
        ArrayList<ComplexEntity.ComplexEntityError> returnValue = new ArrayList<ComplexEntity.ComplexEntityError>();
        if (!this.isValid()) {
            this.getError().ifPresent(returnValue::add);
        }
        return returnValue;
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof ComplexAreaOfInterest && super.equals(other);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}

