/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.items;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.builder.CompareToBuilder;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.geography.Located;
import org.openstreetmap.atlas.geography.Location;
import org.openstreetmap.atlas.geography.PolyLine;
import org.openstreetmap.atlas.geography.Rectangle;
import org.openstreetmap.atlas.geography.atlas.items.Edge;
import org.openstreetmap.atlas.geography.atlas.items.Node;
import org.openstreetmap.atlas.geography.atlas.items.TurnRestriction;
import org.openstreetmap.atlas.utilities.collections.Iterables;
import org.openstreetmap.atlas.utilities.collections.MultiIterable;
import org.openstreetmap.atlas.utilities.collections.StringList;
import org.openstreetmap.atlas.utilities.scalars.Distance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Route
implements Iterable<Edge>,
Located,
Serializable {
    public static final Comparator<Route> ROUTE_COMPARATOR = (route1, route2) -> new CompareToBuilder().append(route2.size(), route1.size()).append(route1.hashCode(), route2.hashCode()).toComparison();
    private static final Logger logger = LoggerFactory.getLogger(Route.class);

    public static Route buildFullRouteIgnoringReverseEdges(Set<Edge> candidates, Node startNode, Node endNode) {
        Route route = null;
        int numberOfConsecutiveFailures = 0;
        long maxEdgesToAdd = candidates.stream().map(edge -> edge.getMasterEdgeIdentifier()).distinct().count();
        HashSet<Long> idsAdded = new HashSet<Long>();
        if (maxEdgesToAdd == 0L) {
            throw new CoreException("Can't have a route with no members");
        }
        while (route == null || (long)route.size() < maxEdgesToAdd && (!route.start().start().equals(startNode) || !route.end().end().equals(endNode))) {
            if (route == null) {
                for (Edge edge2 : candidates) {
                    if (!edge2.start().equals(startNode)) continue;
                    route = Route.forEdge(edge2);
                    idsAdded.add(edge2.getMasterEdgeIdentifier());
                    break;
                }
                if (route != null) continue;
                throw new CoreException("Can't find an edge that connects to the startNode. StartNode: {} EndNode: {}", startNode.getIdentifier(), endNode.getIdentifier());
            }
            boolean edgeAdded = false;
            for (Edge edge3 : candidates) {
                if (idsAdded.contains(edge3.getMasterEdgeIdentifier()) || !edge3.start().equals(route.end().end())) continue;
                edgeAdded = true;
                numberOfConsecutiveFailures = 0;
                route = route.append(edge3);
                idsAdded.add(edge3.getMasterEdgeIdentifier());
                break;
            }
            if (edgeAdded || (long)(++numberOfConsecutiveFailures) < maxEdgesToAdd) continue;
            throw new CoreException("No edge that connects to the current route. StartNode: {} EndNode: {}", startNode.getIdentifier(), endNode.getIdentifier());
        }
        if ((long)route.size() != maxEdgesToAdd) {
            throw new CoreException("A route was found from start to end, but not every unique edge was used. StartNode: {} EndNode: {}", startNode.getIdentifier(), endNode.getIdentifier());
        }
        return route;
    }

    public static Route forEdge(Edge edge) {
        if (edge == null) {
            throw new CoreException("Cannot create a Route from a null Edge.");
        }
        return new SingleRoute(edge);
    }

    public static Route forEdges(Edge ... edges) {
        return Route.forEdges(Iterables.asList(edges));
    }

    public static Route forEdges(Iterable<Edge> edges) {
        if (!edges.iterator().hasNext()) {
            throw new CoreException("Cannot have no edges");
        }
        int counter = 0;
        Route result = null;
        for (Edge edge : edges) {
            result = counter == 0 ? Route.forEdge(edge) : result.append(edge);
            ++counter;
        }
        return result;
    }

    public static Route forRoutes(Iterable<Route> routes) {
        if (!routes.iterator().hasNext()) {
            throw new CoreException("Cannot have no edges");
        }
        Route result = null;
        for (Route route : routes) {
            if (result == null) {
                result = route;
                continue;
            }
            result = result.append(route);
        }
        return result;
    }

    public static Route forRoutes(Route ... routes) {
        return Route.forRoutes(Iterables.asList(routes));
    }

    public static Route fromNonArrangedEdgeSet(Set<Edge> candidates, boolean shuffle) {
        Route route = null;
        int numberFailures = 0;
        ArrayList<Edge> members = new ArrayList<Edge>();
        members.addAll(candidates);
        if (members.isEmpty()) {
            throw new CoreException("Cannot have a route with no members");
        }
        while (route == null || route.size() < members.size()) {
            if (route == null) {
                route = Route.forEdge((Edge)members.iterator().next());
                continue;
            }
            int initialSize = route.size();
            for (Edge edge2 : members) {
                if (route.includes(edge2)) continue;
                if (edge2.start().equals(route.end().end())) {
                    route = route.append(edge2);
                    break;
                }
                if (!edge2.end().equals(route.start().start())) continue;
                route = route.prepend(edge2);
                break;
            }
            if (initialSize + 1 == route.size()) continue;
            if (shuffle && ++numberFailures < candidates.size()) {
                Edge firstMember = (Edge)members.remove(0);
                members.add(firstMember);
                route = null;
                continue;
            }
            StringList edges = new StringList();
            StringList debug = new StringList();
            candidates.forEach(edge -> edges.add(edge.getIdentifier()));
            candidates.forEach(edge -> debug.add(edge.asPolyLine().toWkt()));
            throw new CoreException("Unable to build a route from edges {}\nLocations:\n{}", edges.join(", "), debug.join("\n"));
        }
        return route;
    }

    protected Route() {
    }

    public Route append(Edge edge) {
        return this.append(Route.forEdge(edge));
    }

    public Route append(Route route) {
        if (route == null) {
            throw new CoreException("Cannot append a route that is null to a route {} that ends at {}", this, this.end());
        }
        if (!this.end().end().equals(route.start().start())) {
            throw new CoreException("Cannot append a disconnected route:\nOne: {}\nAt: {}\nTo\nTwo: {}\nAt: {}", this, this.end(), route, route.start());
        }
        return new MultiRoute(this, route);
    }

    public abstract PolyLine asPolyLine();

    public Set<Edge> connectedEdges() {
        HashSet<Edge> result = new HashSet<Edge>();
        for (Edge edge : this.end().end().connectedEdges()) {
            if (this.includes(edge)) continue;
            result.add(edge);
        }
        for (Edge edge : this.start().start().connectedEdges()) {
            if (this.includes(edge)) continue;
            result.add(edge);
        }
        return result;
    }

    public abstract Edge end();

    public boolean equals(Object other) {
        if (other instanceof Route) {
            Route that = (Route)other;
            if (this.size() == that.size()) {
                return new EqualsBuilder().append(this.start().start().getLocation(), that.start().start().getLocation()).append(this.end().end().getLocation(), that.end().end().getLocation()).append(Iterables.asList(this), Iterables.asList(that)).isEquals();
            }
        }
        return false;
    }

    public abstract Edge get(int var1);

    public int hashCode() {
        return new HashCodeBuilder().append(this.start().start().getLocation()).append(this.end().end().getLocation()).append(Iterables.asList(this)).hashCode();
    }

    public boolean includes(Edge edge) {
        return this.indexOf(edge) >= 0;
    }

    public abstract int indexOf(Edge var1);

    public boolean isOverlapping(Route route) {
        return this.overlapIndex(route) > -1;
    }

    public boolean isOverlappingForAtLeastOneOf(Iterable<Route> routes) {
        return this.overlapIndex(routes) > -1;
    }

    public boolean isSimpleUTurn() {
        int numberOfEdges = this.size();
        if (numberOfEdges % 2 == 1) {
            return false;
        }
        for (int index = 0; index < numberOfEdges / 2; ++index) {
            if (this.get(index).isReversedEdge(this.get(numberOfEdges - index - 1))) continue;
            return false;
        }
        return true;
    }

    public boolean isSubRoute(Route route) {
        return this.subRouteIndex(route) > -1;
    }

    public boolean isSubRouteForAtLeastOneOf(Iterable<Route> routes) {
        return this.subRouteIndex(routes) > -1;
    }

    public boolean isTurnRestriction() {
        return TurnRestriction.isTurnRestriction(this);
    }

    public abstract Distance length();

    public abstract List<Node> nodes();

    public int overlapIndex(Iterable<Route> routes) {
        for (Route route : routes) {
            int overlapIndex = this.overlapIndex(route);
            if (overlapIndex <= -1) continue;
            return overlapIndex;
        }
        return -1;
    }

    public int overlapIndex(Route route) {
        int overlapIndex;
        boolean givenPathIsLonger = false;
        if (route.size() > this.size()) {
            givenPathIsLonger = true;
            overlapIndex = route.subRouteIndex(this);
        } else {
            overlapIndex = this.subRouteIndex(route);
        }
        if (givenPathIsLonger && overlapIndex > -1) {
            Edge lastOverlap = route.get(overlapIndex);
            if (this.includes(lastOverlap)) {
                return this.indexOf(lastOverlap);
            }
            logger.error("Detected overlap at edge {}, but unable to find in current route {}", (Object)lastOverlap.getIdentifier(), (Object)this);
            overlapIndex = -1;
        }
        return overlapIndex;
    }

    public Route prepend(Edge edge) {
        return this.prepend(Route.forEdge(edge));
    }

    public Route prepend(Route route) {
        if (!this.start().start().equals(route.end().end())) {
            throw new CoreException("Cannot prepend a disconnected route.");
        }
        return new MultiRoute(route, this);
    }

    public abstract Optional<Route> reverse();

    public abstract int size();

    public abstract Edge start();

    public boolean startsWith(Route other) {
        if (other.size() > this.size()) {
            return false;
        }
        Iterator otherIterator = other.iterator();
        Iterator thisIterator = this.iterator();
        while (otherIterator.hasNext()) {
            Edge otherEdge = (Edge)otherIterator.next();
            Edge thisEdge = (Edge)thisIterator.next();
            if (thisEdge.equals(otherEdge)) continue;
            return false;
        }
        return true;
    }

    public Route subRoute(int startIndex, int endIndex) {
        return Route.forEdges(new ArrayList<Edge>(Iterables.asList(this).subList(startIndex, endIndex)));
    }

    public int subRouteIndex(Iterable<Route> routes) {
        for (Route route : routes) {
            int overlapIndex = this.subRouteIndex(route);
            if (overlapIndex <= -1) continue;
            return overlapIndex;
        }
        return -1;
    }

    public int subRouteIndex(Route route) {
        int lastOverlapIndex = -1;
        if (route == null || route.size() > this.size()) {
            return -1;
        }
        for (Edge routeEdge : route) {
            int index = this.indexOf(routeEdge);
            if (index <= lastOverlapIndex) {
                return -1;
            }
            lastOverlapIndex = index;
        }
        return lastOverlapIndex;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[Route: ");
        StringList edgeIdentifiers = new StringList();
        this.forEach(edge -> edgeIdentifiers.add(String.valueOf(edge.getIdentifier())));
        builder.append(edgeIdentifiers.join(", "));
        builder.append("]");
        return builder.toString();
    }

    private static final class SingleRoute
    extends Route {
        private static final long serialVersionUID = -3870416343539125425L;
        private final Edge edge;

        SingleRoute(Edge edge) {
            this.edge = edge;
        }

        @Override
        public PolyLine asPolyLine() {
            return this.edge.asPolyLine();
        }

        @Override
        public Rectangle bounds() {
            return this.edge.bounds();
        }

        @Override
        public Edge end() {
            return this.edge;
        }

        @Override
        public Edge get(int index) {
            if (index != 0) {
                throw new CoreException("Invalid SingleRoute index: {}. Only 0 is permitted.", index);
            }
            return this.edge;
        }

        @Override
        public int indexOf(Edge edge) {
            return this.edge.getIdentifier() == edge.getIdentifier() ? 0 : -1;
        }

        @Override
        public Iterator<Edge> iterator() {
            return Iterables.from(this.edge).iterator();
        }

        @Override
        public Distance length() {
            return this.edge.length();
        }

        @Override
        public List<Node> nodes() {
            ArrayList<Node> result = new ArrayList<Node>();
            result.add(this.edge.start());
            result.add(this.edge.end());
            return result;
        }

        @Override
        public Optional<Route> reverse() {
            return this.edge.hasReverseEdge() ? Optional.of(new SingleRoute(this.edge.reversed().orElseThrow(() -> new CoreException("Edge should have a reverse.")))) : Optional.empty();
        }

        @Override
        public int size() {
            return 1;
        }

        @Override
        public Edge start() {
            return this.edge;
        }
    }

    private static final class MultiRoute
    extends Route {
        private static final long serialVersionUID = -4562811506650155750L;
        private final Route upstream;
        private final Route downstream;

        private MultiRoute(Route upstream, Route downstream) {
            this.upstream = upstream;
            this.downstream = downstream;
        }

        @Override
        public PolyLine asPolyLine() {
            PolyLine one = this.upstream.asPolyLine();
            PolyLine two = this.downstream.asPolyLine();
            ArrayList<Location> points = new ArrayList<Location>();
            one.forEach(points::add);
            for (int i = 1; i < two.size(); ++i) {
                points.add(two.get(i));
            }
            return new PolyLine((List<? extends Location>)points);
        }

        @Override
        public Rectangle bounds() {
            return Rectangle.forLocated(this.upstream, this.downstream);
        }

        @Override
        public Edge end() {
            return this.downstream.end();
        }

        @Override
        public Edge get(int index) {
            int size = this.size();
            if (index < 0 || index >= size) {
                throw new CoreException("Index {} out of Route's bounds: size = {}", index, size);
            }
            int upstreamSize = this.upstream.size();
            if (index < upstreamSize) {
                return this.upstream.get(index);
            }
            return this.downstream.get(index - upstreamSize);
        }

        @Override
        public int indexOf(Edge edge) {
            int indexUp = this.upstream.indexOf(edge);
            if (indexUp >= 0) {
                return indexUp;
            }
            int indexDown = this.downstream.indexOf(edge);
            if (indexDown >= 0) {
                return this.upstream.size() + indexDown;
            }
            return indexDown;
        }

        @Override
        public Iterator<Edge> iterator() {
            return new MultiIterable(this.upstream, this.downstream).iterator();
        }

        @Override
        public Distance length() {
            return this.upstream.length().add(this.downstream.length());
        }

        @Override
        public List<Node> nodes() {
            ArrayList<Node> nodes = new ArrayList<Node>();
            nodes.addAll(this.upstream.nodes());
            List<Node> downNodes = this.downstream.nodes();
            for (int i = 1; i < downNodes.size(); ++i) {
                nodes.add(downNodes.get(i));
            }
            return nodes;
        }

        @Override
        public Optional<Route> reverse() {
            Route reversed = null;
            for (Edge edge : this) {
                if (edge.hasReverseEdge()) {
                    Edge reverse = edge.reversed().orElseThrow(() -> new CoreException("Edge should have a reverse edge."));
                    if (reversed == null) {
                        reversed = Route.forEdge(reverse);
                        continue;
                    }
                    reversed = reversed.prepend(reverse);
                    continue;
                }
                return Optional.empty();
            }
            return Optional.ofNullable(reversed);
        }

        @Override
        public int size() {
            return this.upstream.size() + this.downstream.size();
        }

        @Override
        public Edge start() {
            return this.upstream.start();
        }
    }
}

