/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.items;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.geography.Located;
import org.openstreetmap.atlas.geography.Rectangle;
import org.openstreetmap.atlas.geography.atlas.builder.RelationBean;
import org.openstreetmap.atlas.geography.atlas.items.Area;
import org.openstreetmap.atlas.geography.atlas.items.Edge;
import org.openstreetmap.atlas.geography.atlas.items.ItemType;
import org.openstreetmap.atlas.geography.atlas.items.Line;
import org.openstreetmap.atlas.geography.atlas.items.Node;
import org.openstreetmap.atlas.geography.atlas.items.Point;
import org.openstreetmap.atlas.geography.atlas.items.Relation;
import org.openstreetmap.atlas.geography.atlas.items.RelationMember;
import org.openstreetmap.atlas.utilities.collections.Iterables;

public class RelationMemberList
extends AbstractCollection<RelationMember>
implements Located {
    private final List<RelationMember> members;
    private final Set<RelationBean.RelationBeanItem> explicitlyExcluded;

    public RelationMemberList(Iterable<RelationMember> members) {
        if (members instanceof List) {
            this.members = (List)members;
        } else {
            this.members = new ArrayList<RelationMember>();
            members.forEach(this.members::add);
        }
        this.explicitlyExcluded = new HashSet<RelationBean.RelationBeanItem>();
    }

    public void addItemExplicitlyExcluded(RelationBean.RelationBeanItem item) {
        this.explicitlyExcluded.add(item);
    }

    public RelationBean asBean() {
        RelationBean result = new RelationBean();
        for (RelationMember member : this.members) {
            result.addItem(member.getEntity().getIdentifier(), member.getRole(), member.getEntity().getType());
        }
        this.explicitlyExcluded.forEach(result::addItemExplicitlyExcluded);
        return result;
    }

    @Override
    public Rectangle bounds() {
        return Rectangle.forLocated(this.members);
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof RelationMemberList) {
            RelationMemberList that = (RelationMemberList)other;
            if (this.getMemberList().size() != that.getMemberList().size()) {
                return false;
            }
            int index = 0;
            for (RelationMember thisMember : this.members) {
                RelationMember thatMember = that.get(index++);
                if (thisMember == null && thatMember != null || thisMember != null && thatMember == null) {
                    return false;
                }
                if (thisMember == null && thatMember == null || thisMember.equals(thatMember)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean equalsIncludingExplicitlyExcluded(Object other) {
        if (other instanceof RelationMemberList) {
            boolean basicEquals = this.equals(other);
            RelationMemberList otherBean = (RelationMemberList)other;
            return basicEquals && this.explicitlyExcluded.equals(otherBean.explicitlyExcluded);
        }
        return false;
    }

    public RelationMember get(int index) {
        if (index < 0 || index >= this.size()) {
            throw new CoreException("No RelationMember with index {}. This list has only {} members.", index, this.size());
        }
        return this.members.get(index);
    }

    public RelationMember get(long identifier, ItemType type) {
        for (RelationMember member : this) {
            if (member.getEntity().getIdentifier() != identifier) continue;
            switch (type) {
                case NODE: {
                    if (!(member.getEntity() instanceof Node)) break;
                    return member;
                }
                case EDGE: {
                    if (!(member.getEntity() instanceof Edge)) break;
                    return member;
                }
                case AREA: {
                    if (!(member.getEntity() instanceof Area)) break;
                    return member;
                }
                case LINE: {
                    if (!(member.getEntity() instanceof Line)) break;
                    return member;
                }
                case POINT: {
                    if (!(member.getEntity() instanceof Point)) break;
                    return member;
                }
                case RELATION: {
                    if (!(member.getEntity() instanceof Relation)) break;
                    return member;
                }
            }
        }
        return null;
    }

    @Override
    public int hashCode() {
        return this.members.hashCode();
    }

    @Override
    public Iterator<RelationMember> iterator() {
        return Iterables.filter(this.members, member -> member != null).iterator();
    }

    @Override
    public int size() {
        return this.members.size();
    }

    @Override
    public String toString() {
        return this.members.toString();
    }

    private List<RelationMember> getMemberList() {
        return this.members;
    }
}

