/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.items;

import com.google.gson.JsonObject;
import java.util.Map;
import org.openstreetmap.atlas.geography.GeometricSurface;
import org.openstreetmap.atlas.geography.Location;
import org.openstreetmap.atlas.geography.Rectangle;
import org.openstreetmap.atlas.geography.Snapper;
import org.openstreetmap.atlas.geography.atlas.Atlas;
import org.openstreetmap.atlas.geography.atlas.items.Area;
import org.openstreetmap.atlas.geography.atlas.items.AtlasItem;
import org.openstreetmap.atlas.geography.atlas.items.LineItem;
import org.openstreetmap.atlas.geography.atlas.items.Node;
import org.openstreetmap.atlas.geography.atlas.items.RelationMember;
import org.openstreetmap.atlas.geography.geojson.GeoJsonBuilder;
import org.openstreetmap.atlas.utilities.collections.StringList;

public abstract class LocationItem
extends AtlasItem {
    private static final long serialVersionUID = -2616559591051747286L;

    protected LocationItem(Atlas atlas) {
        super(atlas);
    }

    @Override
    public JsonObject asGeoJsonGeometry() {
        return this.getLocation().asGeoJsonGeometry();
    }

    @Override
    public Rectangle bounds() {
        return this.getLocation().bounds();
    }

    public abstract Location getLocation();

    @Override
    public Iterable<Location> getRawGeometry() {
        return this.getLocation();
    }

    @Override
    public boolean intersects(GeometricSurface surface) {
        return surface.fullyGeometricallyEncloses(this.getLocation());
    }

    public Snapper.SnappedLocation snapTo(Area other) {
        return this.getLocation().snapTo(other.asPolygon());
    }

    public Snapper.SnappedLocation snapTo(LineItem other) {
        return this.getLocation().snapTo(other.asPolyLine());
    }

    @Override
    public GeoJsonBuilder.LocationIterableProperties toGeoJsonBuildingBlock() {
        Map<String, String> tags = this.getTags();
        tags.put("identifier", String.valueOf(this.getIdentifier()));
        tags.put("osmIdentifier", String.valueOf(this.getOsmIdentifier()));
        tags.put("itemType", String.valueOf((Object)this.getType()));
        if (this instanceof Node) {
            StringList inEdges = new StringList();
            StringList outEdges = new StringList();
            ((Node)this).inEdges().forEach(edge -> inEdges.add(edge != null ? Long.valueOf(edge.getIdentifier()) : "null"));
            ((Node)this).outEdges().forEach(edge -> outEdges.add(edge != null ? Long.valueOf(edge.getIdentifier()) : "null"));
            tags.put("inEdges", inEdges.join(", "));
            tags.put("outEdges", outEdges.join(", "));
        }
        Location location = this.getLocation();
        tags.put("latitude", String.valueOf(location.getLatitude().asDm7()));
        tags.put("longitude", String.valueOf(location.getLongitude().asDm7()));
        StringList parentRelations = new StringList();
        this.relations().forEach(relation -> {
            RelationMember member = relation.members().get(this.getIdentifier(), this.getType());
            parentRelations.add(member.getRelationIdentifier() + "-" + member.getRole());
        });
        if (!parentRelations.isEmpty()) {
            tags.put("parentRelations", parentRelations.join(", "));
        }
        return new GeoJsonBuilder.LocationIterableProperties(this.getRawGeometry(), tags);
    }

    @Override
    public boolean within(GeometricSurface surface) {
        return this.getLocation().within(surface);
    }

    @Override
    public byte[] toWkb() {
        return this.getLocation().toWkb();
    }

    @Override
    public String toWkt() {
        return this.getLocation().toWkt();
    }
}

