/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.items;

import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.geography.atlas.Atlas;
import org.openstreetmap.atlas.geography.atlas.items.Area;
import org.openstreetmap.atlas.geography.atlas.items.AtlasEntity;
import org.openstreetmap.atlas.geography.atlas.items.Edge;
import org.openstreetmap.atlas.geography.atlas.items.Line;
import org.openstreetmap.atlas.geography.atlas.items.Node;
import org.openstreetmap.atlas.geography.atlas.items.Point;
import org.openstreetmap.atlas.geography.atlas.items.Relation;

public enum ItemType {
    NODE(0){

        public Iterable<Node> entitiesForIdentifiers(Atlas atlas, Long ... identifiers) {
            return atlas.nodes(identifiers);
        }
    }
    ,
    EDGE(1){

        public Iterable<Edge> entitiesForIdentifiers(Atlas atlas, Long ... identifiers) {
            return atlas.edges(identifiers);
        }
    }
    ,
    AREA(2){

        public Iterable<Area> entitiesForIdentifiers(Atlas atlas, Long ... identifiers) {
            return atlas.areas(identifiers);
        }
    }
    ,
    LINE(3){

        public Iterable<Line> entitiesForIdentifiers(Atlas atlas, Long ... identifiers) {
            return atlas.lines(identifiers);
        }
    }
    ,
    POINT(4){

        public Iterable<Point> entitiesForIdentifiers(Atlas atlas, Long ... identifiers) {
            return atlas.points(identifiers);
        }
    }
    ,
    RELATION(5){

        public Iterable<Relation> entitiesForIdentifiers(Atlas atlas, Long ... identifiers) {
            return atlas.relations(identifiers);
        }
    };

    private final int value;

    public static ItemType forEntity(AtlasEntity entity) {
        return entity.getType();
    }

    public static ItemType forValue(int value) {
        for (ItemType type : ItemType.values()) {
            if (type.getValue() != value) continue;
            return type;
        }
        throw new CoreException("Invalid value: {}", value);
    }

    public static ItemType shortValueOf(String value) {
        switch (value) {
            case "N": {
                return NODE;
            }
            case "E": {
                return EDGE;
            }
            case "A": {
                return AREA;
            }
            case "L": {
                return LINE;
            }
            case "P": {
                return POINT;
            }
            case "R": {
                return RELATION;
            }
        }
        throw new CoreException("Invalid short value {}", value);
    }

    private ItemType(int value) {
        this.value = value;
    }

    public AtlasEntity entityForIdentifier(Atlas atlas, long identifier) {
        switch (this) {
            case NODE: {
                return atlas.node(identifier);
            }
            case EDGE: {
                return atlas.edge(identifier);
            }
            case AREA: {
                return atlas.area(identifier);
            }
            case LINE: {
                return atlas.line(identifier);
            }
            case POINT: {
                return atlas.point(identifier);
            }
            case RELATION: {
                return atlas.relation(identifier);
            }
        }
        throw new CoreException("Invalid type {}", new Object[]{this});
    }

    public abstract <E extends AtlasEntity> Iterable<E> entitiesForIdentifiers(Atlas var1, Long ... var2);

    public <M extends AtlasEntity> Class<M> getMemberClass() {
        switch (this) {
            case NODE: {
                return Node.class;
            }
            case EDGE: {
                return Edge.class;
            }
            case AREA: {
                return Area.class;
            }
            case LINE: {
                return Line.class;
            }
            case POINT: {
                return Point.class;
            }
            case RELATION: {
                return Relation.class;
            }
        }
        throw new CoreException("Invalid type {}", new Object[]{this});
    }

    public int getValue() {
        return this.value;
    }

    public String toShortString() {
        switch (this) {
            case NODE: {
                return "N";
            }
            case EDGE: {
                return "E";
            }
            case AREA: {
                return "A";
            }
            case LINE: {
                return "L";
            }
            case POINT: {
                return "P";
            }
            case RELATION: {
                return "R";
            }
        }
        throw new CoreException("Invalid type {}", new Object[]{this});
    }
}

