/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.items;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.openstreetmap.atlas.geography.GeometricSurface;
import org.openstreetmap.atlas.geography.GeometryPrintable;
import org.openstreetmap.atlas.geography.atlas.Atlas;
import org.openstreetmap.atlas.geography.atlas.items.AtlasObject;
import org.openstreetmap.atlas.geography.atlas.items.DiffViewFriendlyItem;
import org.openstreetmap.atlas.geography.atlas.items.ItemType;
import org.openstreetmap.atlas.geography.atlas.items.Relation;
import org.openstreetmap.atlas.geography.atlas.pbf.slicing.identifier.ReverseIdentifierFactory;
import org.openstreetmap.atlas.geography.geojson.GeoJsonBuilder;
import org.openstreetmap.atlas.geography.geojson.GeoJsonFeature;
import org.openstreetmap.atlas.geography.geojson.GeoJsonType;
import org.openstreetmap.atlas.utilities.collections.StringList;
import org.openstreetmap.atlas.utilities.scalars.Duration;
import org.openstreetmap.atlas.utilities.time.Time;

public abstract class AtlasEntity
implements AtlasObject,
DiffViewFriendlyItem,
GeometryPrintable,
GeoJsonFeature {
    private static final long serialVersionUID = -6072525057489468736L;
    private final Atlas atlas;

    protected AtlasEntity(Atlas atlas) {
        this.atlas = atlas;
    }

    public boolean containsKey(Iterable<String> matches) {
        Map<String, String> tags = this.getTags();
        for (String candidate : matches) {
            if (!tags.containsKey(candidate)) continue;
            return true;
        }
        return false;
    }

    public Optional<String> getName() {
        return this.getTag("name");
    }

    public boolean containsKeyStartsWith(Iterable<String> matches) {
        Map<String, String> tags = this.getTags();
        for (String candidate : matches) {
            for (String key : tags.keySet()) {
                if (!key.startsWith(candidate)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other != null && this.getClass() == other.getClass()) {
            AtlasEntity that = (AtlasEntity)other;
            return this.getAtlas() == that.getAtlas() && this.getIdentifier() == that.getIdentifier();
        }
        return false;
    }

    @Override
    public JsonObject getGeoJsonProperties() {
        JsonObject properties = new JsonObject();
        this.getTags().forEach(properties::addProperty);
        properties.addProperty("identifier", this.getIdentifier());
        properties.addProperty("osmIdentifier", this.getOsmIdentifier());
        properties.addProperty("itemType", String.valueOf((Object)this.getType()));
        Set<Relation> relations = this.relations();
        if (relations.size() > 0) {
            JsonArray relationsArray = new JsonArray();
            properties.add("relations", relationsArray);
            for (Relation relation : relations) {
                JsonObject relationObject = relation.getGeoJsonPropertiesWithoutMembers();
                relationsArray.add(relationObject);
            }
        }
        return properties;
    }

    @Override
    public Atlas getAtlas() {
        return this.atlas;
    }

    @Override
    public GeoJsonType getGeoJsonType() {
        return GeoJsonType.FEATURE;
    }

    @Override
    public long getOsmIdentifier() {
        return new ReverseIdentifierFactory().getOsmIdentifier(this.getIdentifier());
    }

    @Override
    public Optional<String> getTag(String key) {
        return Optional.ofNullable(this.getTags().get(key));
    }

    public abstract ItemType getType();

    public int hashCode() {
        return new HashCodeBuilder().append(this.getIdentifier()).append(this.getClass()).hashCode();
    }

    public abstract boolean intersects(GeometricSurface var1);

    public Optional<Time> lastEdit() {
        String tag = this.tag("last_edit_time");
        if (tag == null) {
            return Optional.empty();
        }
        return Optional.of(new Time(Duration.milliseconds(Long.valueOf(tag))));
    }

    public Optional<String> lastUserIdentifier() {
        String tag = this.tag("last_edit_user_id");
        if (tag == null) {
            return Optional.empty();
        }
        return Optional.of(tag);
    }

    public Optional<String> lastUserName() {
        String tag = this.tag("last_edit_user_name");
        if (tag == null) {
            return Optional.empty();
        }
        return Optional.of(tag);
    }

    public abstract Set<Relation> relations();

    @Override
    public String toDiffViewFriendlyString() {
        throw new UnsupportedOperationException("This operation is not supported for type " + this.getClass().getName());
    }

    public abstract GeoJsonBuilder.LocationIterableProperties toGeoJsonBuildingBlock();

    protected String parentRelationsAsDiffViewFriendlyString() {
        StringList relationIds = new StringList();
        for (Relation relation : this.relations()) {
            relationIds.add(relation.getIdentifier());
        }
        String relationsString = relationIds.join(",");
        return relationsString;
    }

    protected String tagString() {
        StringBuilder builder = new StringBuilder();
        Map<String, String> tags = this.getTags();
        int index = 0;
        builder.append("[Tags: ");
        for (String key : tags.keySet()) {
            String value = tags.get(key);
            builder.append("[");
            builder.append(key);
            builder.append(" => ");
            builder.append(value);
            builder.append("]");
            if (index < tags.size() - 1) {
                builder.append(", ");
            }
            ++index;
        }
        builder.append("]");
        return builder.toString();
    }
}

