/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.geojson;

import com.google.gson.JsonObject;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.openstreetmap.atlas.geography.atlas.Atlas;
import org.openstreetmap.atlas.geography.atlas.AtlasResourceLoader;
import org.openstreetmap.atlas.geography.atlas.items.AtlasEntity;
import org.openstreetmap.atlas.geography.atlas.items.Edge;
import org.openstreetmap.atlas.geography.atlas.items.ItemType;
import org.openstreetmap.atlas.geography.atlas.items.Relation;
import org.openstreetmap.atlas.streaming.resource.File;
import org.openstreetmap.atlas.streaming.resource.FileSuffix;
import org.openstreetmap.atlas.streaming.resource.Resource;
import org.openstreetmap.atlas.tags.RelationTypeTag;
import org.openstreetmap.atlas.tags.Taggable;
import org.openstreetmap.atlas.tags.annotations.validation.Validators;
import org.openstreetmap.atlas.utilities.runtime.Command;
import org.openstreetmap.atlas.utilities.runtime.CommandMap;
import org.openstreetmap.atlas.utilities.time.Time;
import org.openstreetmap.atlas.utilities.vectortiles.TippecanoeCommands;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LineDelimitedGeoJsonConverter
extends Command {
    private static final int DEFAULT_THREADS = 8;
    public static final String EVERYTHING = "EVERYTHING.geojson";
    public static final int EXIT_FAILURE = 1;
    private static final Logger logger = LoggerFactory.getLogger(LineDelimitedGeoJsonConverter.class);
    private static final AtlasResourceLoader ATLAS_RESOURCE_LOADER = new AtlasResourceLoader();
    private static final Command.Switch<Path> ATLAS_DIRECTORY = new Command.Switch("atlasDirectory", "The directory of atlases to convert.", x$0 -> Paths.get(x$0, new String[0]), Command.Optionality.REQUIRED);
    protected static final Command.Switch<Path> GEOJSON_DIRECTORY = new Command.Switch("geojsonDirectory", "The directory to write line-delimited GeoJSON.", x$0 -> Paths.get(x$0, new String[0]), Command.Optionality.REQUIRED);
    protected static final Command.Switch<Boolean> OVERWRITE = new Command.Switch("overwrite", "Choose to automatically overwrite a GeoJSON file if it exists at the given path.", Boolean::parseBoolean, Command.Optionality.OPTIONAL, "false");
    private static final Command.Switch<Integer> THREADS = new Command.Switch("threads", "The number of threads to work on processing atlas shards.", Integer::valueOf, Command.Optionality.OPTIONAL, String.valueOf(8));
    private static final Predicate<AtlasEntity> ENTITY_PREDICATE = entity -> {
        Set<Relation> relations;
        Edge edge;
        if (ItemType.EDGE.equals((Object)entity.getType()) && !(edge = (Edge)entity).isMasterEdge()) {
            return false;
        }
        if (ItemType.AREA.equals((Object)entity.getType()) && !(relations = entity.relations()).isEmpty()) {
            return relations.stream().noneMatch(relation -> Validators.isOfType((Taggable)relation, RelationTypeTag.class, (Enum[])new RelationTypeTag[]{RelationTypeTag.MULTIPOLYGON}));
        }
        return true;
    };
    private BiConsumer<AtlasEntity, JsonObject> jsonMutator = (atlasEntity, feature) -> {};

    public static void main(String[] args) {
        new LineDelimitedGeoJsonConverter().run(args);
    }

    private static List<File> fetchAtlasFilesInDirectory(Path directory) {
        return new File(directory.toFile()).listFilesRecursively().stream().filter(AtlasResourceLoader.IS_ATLAS).collect(Collectors.toList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected int onRun(CommandMap command) {
        List<File> atlases;
        Time time = Time.now();
        Path atlasDirectory = (Path)command.get(ATLAS_DIRECTORY);
        Path geojsonDirectory = (Path)command.get(GEOJSON_DIRECTORY);
        Boolean overwrite = (Boolean)command.get(OVERWRITE);
        int threads = (Integer)command.get(THREADS);
        if (overwrite.booleanValue()) {
            try {
                FileUtils.deleteDirectory(geojsonDirectory.toFile());
            }
            catch (IOException noDelete) {
                logger.warn("Tried to delete GeoJSON output directory {} for overwrite, but unable.", (Object)geojsonDirectory, (Object)noDelete);
            }
        }
        if ((atlases = LineDelimitedGeoJsonConverter.fetchAtlasFilesInDirectory(atlasDirectory)).isEmpty()) {
            logger.error("There are no atlas files in {}. Exiting...", (Object)atlasDirectory);
            System.exit(1);
        }
        logger.info("About to convert {} atlas shards into line-delimited GeoJSON...", (Object)atlases.size());
        ForkJoinPool pool = new ForkJoinPool(threads);
        try {
            ((ForkJoinTask)pool.submit(() -> this.convertAtlases(atlasDirectory, geojsonDirectory))).get();
            TippecanoeCommands.concatenate(geojsonDirectory);
        }
        catch (InterruptedException interrupt) {
            logger.error("The atlas to GeoJSON workers were interrupted.", (Throwable)interrupt);
        }
        catch (ExecutionException execution) {
            logger.error("There was an execution exception on the atlas to GeoJSON workers.", (Throwable)execution);
        }
        finally {
            pool.shutdown();
        }
        logger.info("Finished converting directory of atlas shards into line-delimited GeoJSON in {}!", (Object)time.elapsedSince());
        return 0;
    }

    protected void setJsonMutator(BiConsumer<AtlasEntity, JsonObject> jsonMutator) {
        this.jsonMutator = jsonMutator;
    }

    @Override
    protected Command.SwitchList switches() {
        return new Command.SwitchList().with(ATLAS_DIRECTORY, GEOJSON_DIRECTORY, OVERWRITE, THREADS);
    }

    private void convertAtlases(Path atlasDirectory, Path geojsonDirectory) {
        List<File> atlases = LineDelimitedGeoJsonConverter.fetchAtlasFilesInDirectory(atlasDirectory);
        atlases.parallelStream().forEach(atlasFile -> {
            Time time = Time.now();
            Atlas atlas = ATLAS_RESOURCE_LOADER.load((Resource)atlasFile);
            String name = FilenameUtils.removeExtension(atlasFile.getName()) + FileSuffix.GEO_JSON.toString();
            File geojsonFile = new File(geojsonDirectory.resolve(name).toFile());
            atlas.saveAsLineDelimitedGeoJsonFeatures(geojsonFile, ENTITY_PREDICATE, this.jsonMutator);
            logger.info("Saved {} in {}.", (Object)name, (Object)time.elapsedSince());
        });
    }
}

