/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.dynamic;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.geography.GeometryPrintable;
import org.openstreetmap.atlas.geography.Location;
import org.openstreetmap.atlas.geography.MultiPolygon;
import org.openstreetmap.atlas.geography.PolyLine;
import org.openstreetmap.atlas.geography.Polygon;
import org.openstreetmap.atlas.geography.WktPrintable;
import org.openstreetmap.atlas.geography.atlas.Atlas;
import org.openstreetmap.atlas.geography.atlas.builder.RelationBean;
import org.openstreetmap.atlas.geography.atlas.dynamic.DynamicAtlas;
import org.openstreetmap.atlas.geography.atlas.dynamic.policy.DynamicAtlasPolicy;
import org.openstreetmap.atlas.geography.atlas.items.Area;
import org.openstreetmap.atlas.geography.atlas.items.AtlasEntity;
import org.openstreetmap.atlas.geography.atlas.items.LineItem;
import org.openstreetmap.atlas.geography.atlas.items.LocationItem;
import org.openstreetmap.atlas.geography.atlas.items.Relation;
import org.openstreetmap.atlas.geography.atlas.items.RelationMember;
import org.openstreetmap.atlas.geography.atlas.items.RelationMemberList;
import org.openstreetmap.atlas.geography.atlas.multi.MultiAtlas;
import org.openstreetmap.atlas.geography.sharding.Shard;
import org.openstreetmap.atlas.geography.sharding.Sharding;
import org.openstreetmap.atlas.utilities.collections.Iterables;
import org.openstreetmap.atlas.utilities.collections.StreamIterable;
import org.openstreetmap.atlas.utilities.collections.StringList;
import org.openstreetmap.atlas.utilities.time.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DynamicAtlasExpander {
    private static final Logger logger = LoggerFactory.getLogger(DynamicAtlasExpander.class);
    private final DynamicAtlas dynamicAtlas;
    private Set<Shard> shardsUsedForCurrent;
    private final Map<Shard, Atlas> loadedShards;
    private final Function<Shard, Optional<Atlas>> atlasFetcher;
    private final Sharding sharding;
    private final DynamicAtlasPolicy policy;
    private final boolean initialized;
    private boolean isAlreadyLoaded = false;
    private boolean preemptiveLoadDone = false;
    private int timesMultiAtlasWasBuiltUnderneath;

    DynamicAtlasExpander(DynamicAtlas dynamicAtlas, DynamicAtlasPolicy policy) {
        this.dynamicAtlas = dynamicAtlas;
        this.timesMultiAtlasWasBuiltUnderneath = 0;
        this.sharding = policy.getSharding();
        this.loadedShards = new HashMap<Shard, Atlas>();
        this.shardsUsedForCurrent = new HashSet<Shard>();
        this.atlasFetcher = policy.getAtlasFetcher();
        this.policy = policy;
        this.addNewShards(policy.getInitialShards());
        this.initialized = true;
    }

    boolean areaCovered(Area area) {
        Polygon polygon = area.asPolygon();
        MultiPolygon initialShardsBounds = this.policy.getInitialShardsBounds();
        if (!(this.policy.isExtendIndefinitely() || polygon.overlaps(initialShardsBounds) || initialShardsBounds.overlaps(polygon))) {
            return true;
        }
        Iterable<? extends Shard> neededShards = this.sharding.shards(polygon);
        for (Shard shard : neededShards) {
            if (this.loadedShards.containsKey(shard)) continue;
            this.newPolygon(polygon, area);
            return false;
        }
        return true;
    }

    void buildUnderlyingMultiAtlas() {
        Time buildTime = Time.now();
        Set<Shard> nonNullShards = this.nonNullShards();
        if (this.shardsUsedForCurrent.equals(nonNullShards)) {
            return;
        }
        List<Atlas> nonNullAtlasShards = this.getNonNullAtlasShards();
        if (!nonNullAtlasShards.isEmpty()) {
            this.policy.getShardSetChecker().accept(this.nonNullShards());
            if (nonNullAtlasShards.size() == 1) {
                this.dynamicAtlas.swapCurrentAtlas(nonNullAtlasShards.get(0));
            } else {
                if (logger.isDebugEnabled()) {
                    logger.debug("{}: Loading MultiAtlas with {}", (Object)this.dynamicAtlas.getName(), this.nonNullShards().stream().map(Shard::getName).collect(Collectors.toList()));
                }
                this.dynamicAtlas.swapCurrentAtlas(new MultiAtlas(nonNullAtlasShards));
                ++this.timesMultiAtlasWasBuiltUnderneath;
            }
            this.shardsUsedForCurrent = nonNullShards;
            if (this.initialized) {
                this.isAlreadyLoaded = true;
            }
        } else {
            throw new CoreException("Cannot load shards with no data!");
        }
        logger.trace("{}: Built underlying MultiAtlas in {}", (Object)this.dynamicAtlas.getName(), (Object)buildTime.elapsedSince());
    }

    <V extends AtlasEntity, T> Iterable<T> expand(Supplier<Iterable<V>> entitiesSupplier, Predicate<V> entityCoveredPredicate, Function<V, T> mapper) {
        boolean shouldStopExploring;
        StreamIterable<AtlasEntity> result = Iterables.stream(entitiesSupplier.get()).filter(Objects::nonNull);
        boolean bl = shouldStopExploring = this.policy.isDeferLoading() && !this.policy.isExtendIndefinitely() && this.preemptiveLoadDone;
        while (!shouldStopExploring && !this.entitiesCovered(result, entityCoveredPredicate)) {
            result = Iterables.stream(entitiesSupplier.get()).filter(Objects::nonNull);
        }
        return result.map(mapper).collect();
    }

    Map<Shard, Atlas> getLoadedShards() {
        return this.loadedShards;
    }

    int getTimesMultiAtlasWasBuiltUnderneath() {
        return this.timesMultiAtlasWasBuiltUnderneath;
    }

    boolean lineItemCovered(LineItem item) {
        PolyLine polyLine = item.asPolyLine();
        MultiPolygon initialShardsBounds = this.policy.getInitialShardsBounds();
        if (!this.policy.isExtendIndefinitely() && !initialShardsBounds.overlaps(polyLine)) {
            return true;
        }
        Iterable<? extends Shard> neededShards = this.sharding.shardsIntersecting(polyLine);
        for (Shard shard : neededShards) {
            if (this.loadedShards.containsKey(shard)) continue;
            this.newPolyLine(polyLine, item);
            return false;
        }
        return true;
    }

    boolean locationItemCovered(LocationItem item) {
        Location location = item.getLocation();
        MultiPolygon initialShardsBounds = this.policy.getInitialShardsBounds();
        if (!this.policy.isExtendIndefinitely() && !initialShardsBounds.fullyGeometricallyEncloses(location)) {
            return true;
        }
        Iterable<? extends Shard> neededShards = this.sharding.shardsCovering(location);
        for (Shard shard : neededShards) {
            if (this.loadedShards.containsKey(shard)) continue;
            this.newLocation(location, item);
            return false;
        }
        return true;
    }

    void preemptiveLoad() {
        if (!this.policy.isDeferLoading()) {
            logger.warn("{}: Skipping preemptive loading as it is useful only when the DynamicAtlasPolicy is deferLoading = true.", (Object)this.dynamicAtlas.getName());
            return;
        }
        if (this.preemptiveLoadDone) {
            return;
        }
        this.browseForPotentialNewShards();
        this.buildUnderlyingMultiAtlas();
        HashSet<Shard> currentShards = new HashSet<Shard>(this.loadedShards.keySet());
        this.browseForPotentialNewShards();
        this.browseForPotentialNewShardsFromAggressiveRelations();
        while (!this.loadedShards.keySet().equals(currentShards)) {
            if (logger.isInfoEnabled()) {
                HashSet<Shard> missingShards = new HashSet<Shard>(this.loadedShards.keySet());
                missingShards.removeAll(currentShards);
                logger.info("{}: Preemptive load found new unexpected 2nd degree shard(s): {}", (Object)this.dynamicAtlas.getName(), missingShards.stream().map(Shard::getName).collect(Collectors.toList()));
            }
            this.buildUnderlyingMultiAtlas();
            currentShards = new HashSet<Shard>(this.loadedShards.keySet());
            this.browseForPotentialNewShards();
            this.browseForPotentialNewShardsFromAggressiveRelations();
        }
        this.preemptiveLoadDone = true;
    }

    boolean relationCovered(Relation relation) {
        HashSet<Long> parentRelationIdentifierTree = new HashSet<Long>();
        parentRelationIdentifierTree.add(relation.getIdentifier());
        return this.relationCoveredInternal(relation, parentRelationIdentifierTree);
    }

    private void addNewShardLog(Shard shard) {
        if (logger.isInfoEnabled()) {
            Atlas loaded = this.loadedShards.get(shard);
            if (loaded == null) {
                logger.info("{}: Loading new shard {} found no new Atlas.", (Object)this.dynamicAtlas.getName(), (Object)shard.getName());
            } else {
                logger.info("{}: Loading new shard {} found a new Atlas {} of size {}", new Object[]{this.dynamicAtlas.getName(), shard.getName(), loaded.getName(), loaded.size()});
            }
        }
    }

    private void addNewShards(Iterable<? extends Shard> shards) {
        Set<Shard> initialNonEmptyLoadedShards = this.nonNullShards();
        for (Shard shard : shards) {
            if (this.loadedShards.containsKey(shard)) continue;
            this.loadedShards.put(shard, this.atlasFetcher.apply(shard).orElse(null));
            this.addNewShardLog(shard);
        }
        List<Atlas> nonNullAtlasShards = this.getNonNullAtlasShards();
        if (!nonNullAtlasShards.isEmpty()) {
            if (this.shouldBuildUnderlyingMultiAtlasWhenAddingNewShards(initialNonEmptyLoadedShards)) {
                this.buildUnderlyingMultiAtlas();
            }
        } else {
            throw new CoreException("{}: There is no data to load for initial shard!", this.dynamicAtlas.getName());
        }
    }

    private boolean areaCoversInitialShardBounds(Area area) {
        return this.policy.getInitialShardsBounds().overlaps(area.asPolygon());
    }

    private void browseForPotentialNewShards() {
        this.dynamicAtlas.entities();
    }

    private void browseForPotentialNewShardsFromAggressiveRelations() {
        if (this.policy.isAggressivelyExploreRelations() && !this.policy.isExtendIndefinitely() && this.policy.isDeferLoading()) {
            Set<Shard> neighboringShardsContainingRelation;
            HashSet<Shard> onlyNeighboringShards = new HashSet<Shard>();
            this.loadedShards.keySet().forEach(shard -> this.sharding.neighbors((Shard)shard).forEach(onlyNeighboringShards::add));
            onlyNeighboringShards.removeAll(this.loadedShards.keySet());
            if (logger.isTraceEnabled()) {
                Set shardNames = onlyNeighboringShards.stream().map(Shard::getName).collect(Collectors.toSet());
                String wktCollection = WktPrintable.toWktCollection(onlyNeighboringShards);
                logger.trace("{}: Aggressively exploring relations in shards {} - {}", new Object[]{this.dynamicAtlas.getName(), shardNames, wktCollection});
            }
            if (!(neighboringShardsContainingRelation = this.neighboringShardsContainingInitialRelation(onlyNeighboringShards)).isEmpty()) {
                this.addNewShards(neighboringShardsContainingRelation);
            }
        }
    }

    private <V extends AtlasEntity> boolean entitiesCovered(Iterable<V> entities, Predicate<V> entityCoveredPredicate) {
        return Iterables.stream(entities).filter(entity -> this.policy.getAtlasEntitiesToConsiderForExpansion().test((AtlasEntity)entity)).allMatch(entityCoveredPredicate);
    }

    private List<Atlas> getNonNullAtlasShards() {
        return this.loadedShards.values().stream().filter(Objects::nonNull).collect(Collectors.toList());
    }

    private boolean lineItemCoversInitialShardBounds(LineItem lineItem) {
        return this.policy.getInitialShardsBounds().overlaps(lineItem.asPolyLine());
    }

    private boolean loadedShardsfullyGeometricallyEncloseLocation(Location location) {
        return Iterables.stream(this.sharding.shardsCovering(location)).allMatch(this.loadedShards::containsKey);
    }

    private boolean loadedShardsfullyGeometricallyEnclosePolygon(Polygon polygon) {
        return Iterables.stream(this.sharding.shards(polygon)).allMatch(this.loadedShards::containsKey);
    }

    private boolean loadedShardsfullyGeometricallyEnclosePolyLine(PolyLine polyLine) {
        return Iterables.stream(this.sharding.shardsIntersecting(polyLine)).allMatch(this.loadedShards::containsKey);
    }

    private boolean locationItemCoversInitialShardBounds(LocationItem locationItem) {
        return this.policy.getInitialShardsBounds().fullyGeometricallyEncloses(locationItem.getLocation());
    }

    private boolean neighboringAtlasContainingInitialRelation(Atlas atlas) {
        for (Relation newRelation : atlas.relations()) {
            Relation currentRelation = this.dynamicAtlas.subRelation(newRelation.getIdentifier());
            if (currentRelation == null || !this.policy.getAtlasEntitiesToConsiderForExpansion().test(currentRelation) || !this.relationCoversInitialShardBounds(currentRelation)) continue;
            RelationBean newMembers = newRelation.members().asBean();
            RelationBean currentMembers = currentRelation.members().asBean();
            for (RelationBean.RelationBeanItem newMember : newMembers) {
                if (currentMembers.contains(newMember)) continue;
                this.newShapeLog(newRelation, currentRelation);
                return true;
            }
        }
        return false;
    }

    private Set<Shard> neighboringShardsContainingInitialRelation(Set<Shard> neighboringShardCandidates) {
        HashSet<Shard> neighboringShardsContainingRelation = new HashSet<Shard>();
        neighboringShardCandidates.forEach(shard -> this.policy.getAtlasFetcher().apply((Shard)shard).ifPresent(atlas -> {
            if (this.neighboringAtlasContainingInitialRelation((Atlas)atlas)) {
                neighboringShardsContainingRelation.add((Shard)shard);
            }
        }));
        return neighboringShardsContainingRelation;
    }

    private void newLocation(Location location, LocationItem ... source) {
        if (!this.loadedShardsfullyGeometricallyEncloseLocation(location)) {
            this.newShapeLog(location, source);
            this.addNewShards(this.sharding.shardsCovering(location));
        }
    }

    private void newPolygon(Polygon polygon, AtlasEntity ... source) {
        if (!this.loadedShardsfullyGeometricallyEnclosePolygon(polygon)) {
            this.newShapeLog(polygon, source);
            this.addNewShards(this.sharding.shards(polygon));
        }
    }

    private void newPolyLine(PolyLine polyLine, LineItem ... source) {
        if (!this.loadedShardsfullyGeometricallyEnclosePolyLine(polyLine)) {
            this.newShapeLog(polyLine, source);
            this.addNewShards(this.sharding.shardsIntersecting(polyLine));
        }
    }

    private void newShapeLog(GeometryPrintable geometry, AtlasEntity ... source) {
        if (logger.isDebugEnabled()) {
            logger.debug("{}: Triggering new shard load for {}{}", new Object[]{this.dynamicAtlas.getName(), source.length > 0 ? "Atlas " + new StringList(Iterables.stream(Iterables.asList(source)).map(item -> (Object)((Object)item.getType()) + " " + item.getIdentifier())).join(", ") + " with shape " : "", geometry.toWkt()});
        }
    }

    private Set<Shard> nonNullShards() {
        return new HashSet<Shard>(this.loadedShards.keySet().stream().filter(shard -> this.loadedShards.get(shard) != null).collect(Collectors.toSet()));
    }

    private boolean relationCoveredInternal(Relation relation, Set<Long> parentRelationIdentifierTree) {
        RelationMemberList members = relation.members();
        boolean result = true;
        for (RelationMember member : members) {
            AtlasEntity entity = member.getEntity();
            if (entity instanceof Area) {
                if (this.areaCovered((Area)entity)) continue;
                result = false;
                continue;
            }
            if (entity instanceof LineItem) {
                if (this.lineItemCovered((LineItem)entity)) continue;
                result = false;
                continue;
            }
            if (entity instanceof LocationItem) {
                if (this.locationItemCovered((LocationItem)entity)) continue;
                result = false;
                continue;
            }
            if (entity instanceof Relation) {
                result = this.relationMemberCoveredInternal(relation, (Relation)entity, parentRelationIdentifierTree);
                continue;
            }
            throw new CoreException("Unknown Relation Member Type: {}", entity.getClass().getName());
        }
        return result;
    }

    private boolean relationCoversInitialShardBounds(Relation relation) {
        HashSet<Long> parentRelationIdentifierTree = new HashSet<Long>();
        parentRelationIdentifierTree.add(relation.getIdentifier());
        return this.relationCoversInitialShardBoundsInternal(relation, parentRelationIdentifierTree);
    }

    private boolean relationCoversInitialShardBoundsInternal(Relation relation, Set<Long> parentRelationIdentifierTree) {
        RelationMemberList members = relation.members();
        boolean result = false;
        for (RelationMember member : members) {
            AtlasEntity entity = member.getEntity();
            if (entity instanceof Area) {
                if (!this.areaCoversInitialShardBounds((Area)entity)) continue;
                result = true;
                continue;
            }
            if (entity instanceof LineItem) {
                if (!this.lineItemCoversInitialShardBounds((LineItem)entity)) continue;
                result = true;
                continue;
            }
            if (entity instanceof LocationItem) {
                if (!this.locationItemCoversInitialShardBounds((LocationItem)entity)) continue;
                result = true;
                continue;
            }
            if (entity instanceof Relation) {
                result = this.relationMemberCoversInitialShardBoundsInternal(relation, (Relation)entity, parentRelationIdentifierTree);
                continue;
            }
            throw new CoreException("Unknown Relation Member Type: {}", entity.getClass().getName());
        }
        return result;
    }

    private boolean relationMemberCoveredInternal(Relation parentRelation, Relation relation, Set<Long> parentRelationIdentifierTree) {
        boolean result = true;
        long newIdentifier = relation.getIdentifier();
        if (parentRelationIdentifierTree.contains(newIdentifier)) {
            logger.error("Skipping! Unable to expand on relation which has a loop: {}. Parent tree: {}", (Object)parentRelation, parentRelationIdentifierTree);
        } else {
            HashSet<Long> newParentRelationIdentifierTree = new HashSet<Long>();
            newParentRelationIdentifierTree.addAll(parentRelationIdentifierTree);
            newParentRelationIdentifierTree.add(newIdentifier);
            if (!this.relationCoveredInternal(relation, newParentRelationIdentifierTree)) {
                result = false;
            }
        }
        return result;
    }

    private boolean relationMemberCoversInitialShardBoundsInternal(Relation parentRelation, Relation relation, Set<Long> parentRelationIdentifierTree) {
        boolean result = false;
        long newIdentifier = relation.getIdentifier();
        if (parentRelationIdentifierTree.contains(newIdentifier)) {
            logger.error("Skipping! Unable to expand on relation which has a loop: {}. Parent tree: {}", (Object)parentRelation, parentRelationIdentifierTree);
        } else {
            HashSet<Long> newParentRelationIdentifierTree = new HashSet<Long>();
            newParentRelationIdentifierTree.addAll(parentRelationIdentifierTree);
            newParentRelationIdentifierTree.add(newIdentifier);
            if (this.relationCoversInitialShardBoundsInternal(relation, newParentRelationIdentifierTree)) {
                result = true;
            }
        }
        return result;
    }

    private boolean shouldBuildUnderlyingMultiAtlasWhenAddingNewShards(Set<Shard> initialNonEmptyLoadedShards) {
        boolean thereAreNewViableShards = !initialNonEmptyLoadedShards.equals(this.nonNullShards());
        boolean dynamicAtlasNotInitializedYet = !this.initialized;
        boolean loadingIsNotDeferredOrItIsAndAlreadyHappened = !this.policy.isDeferLoading() || this.isAlreadyLoaded;
        boolean shouldBuildUnderlyingMultiAtlas = thereAreNewViableShards && (dynamicAtlasNotInitializedYet || loadingIsNotDeferredOrItIsAndAlreadyHappened);
        return shouldBuildUnderlyingMultiAtlas;
    }
}

