/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.converters;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.openstreetmap.atlas.geography.Location;
import org.openstreetmap.atlas.geography.MultiPolygon;
import org.openstreetmap.atlas.geography.Rectangle;
import org.openstreetmap.atlas.geography.atlas.Atlas;
import org.openstreetmap.atlas.geography.atlas.AtlasResourceLoader;
import org.openstreetmap.atlas.geography.atlas.pbf.AtlasLoadingOption;
import org.openstreetmap.atlas.geography.atlas.raw.creation.RawAtlasGenerator;
import org.openstreetmap.atlas.geography.atlas.raw.sectioning.WaySectionProcessor;
import org.openstreetmap.atlas.geography.atlas.raw.slicing.RawAtlasCountrySlicer;
import org.openstreetmap.atlas.geography.atlas.routing.AStarRouter;
import org.openstreetmap.atlas.geography.boundary.CountryBoundaryMap;
import org.openstreetmap.atlas.geography.boundary.converters.CountryListTwoWayStringConverter;
import org.openstreetmap.atlas.geography.converters.MultiPolygonStringConverter;
import org.openstreetmap.atlas.utilities.collections.StringList;
import org.openstreetmap.atlas.utilities.runtime.Command;
import org.openstreetmap.atlas.utilities.runtime.CommandMap;
import org.openstreetmap.atlas.utilities.scalars.Distance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtlasDebugTool
extends Command {
    private static final Logger logger = LoggerFactory.getLogger(AtlasDebugTool.class);
    private static final Command.Switch<org.openstreetmap.atlas.streaming.resource.File> PBF = new Command.Switch("pbf", "The protobuf file", path -> new org.openstreetmap.atlas.streaming.resource.File((String)path), Command.Optionality.OPTIONAL);
    private static final Command.Switch<org.openstreetmap.atlas.streaming.resource.File> ATLAS = new Command.Switch("atlas", "The atlas file", path -> new org.openstreetmap.atlas.streaming.resource.File((String)path), Command.Optionality.REQUIRED);
    private static final Command.Switch<org.openstreetmap.atlas.streaming.resource.File> GEOJSON = new Command.Switch("geojson", "The geojson file", path -> new org.openstreetmap.atlas.streaming.resource.File((String)path), Command.Optionality.OPTIONAL);
    private static final Command.Switch<org.openstreetmap.atlas.streaming.resource.File> TEXT = new Command.Switch("text", "The text file", path -> new org.openstreetmap.atlas.streaming.resource.File((String)path), Command.Optionality.OPTIONAL);
    private static final Command.Switch<File> BOUNDARY = new Command.Switch("boundary", "The country boundary file", path -> new File((String)path), Command.Optionality.OPTIONAL);
    private static final Command.Switch<String> COUNTRY = new Command.Switch("country", "The country name which will be loaded", name -> name, Command.Optionality.OPTIONAL);
    private static final Command.Switch<List<Location>> ROUTE = new Command.Switch("route", "The lat,lon:lat,lon representing a start and end points to get a route", value -> {
        StringList split = StringList.split(value, ":");
        ArrayList<Location> result = new ArrayList<Location>();
        result.add(Location.forString(split.get(0)));
        result.add(Location.forString(split.get(1)));
        return result;
    }, Command.Optionality.OPTIONAL);
    private static final Command.Switch<Rectangle> BOUND = new Command.Switch("bound", "Data will be loaded only in this bounding box", value -> Rectangle.forString(value));
    private static final Command.Switch<MultiPolygon> MULTIPOLYGON = new Command.Switch("multipolygon", "Data will be loaded only in this multipolygon", value -> new MultiPolygonStringConverter().convert((String)value));

    public static void main(String[] args) {
        new AtlasDebugTool().run(args);
    }

    @Override
    protected int onRun(CommandMap command) {
        Atlas atlas;
        org.openstreetmap.atlas.streaming.resource.File pbf = (org.openstreetmap.atlas.streaming.resource.File)command.get(PBF);
        org.openstreetmap.atlas.streaming.resource.File atlasFile = (org.openstreetmap.atlas.streaming.resource.File)command.get(ATLAS);
        org.openstreetmap.atlas.streaming.resource.File geojson = (org.openstreetmap.atlas.streaming.resource.File)command.get(GEOJSON);
        org.openstreetmap.atlas.streaming.resource.File text = (org.openstreetmap.atlas.streaming.resource.File)command.get(TEXT);
        File boundaryFile = (File)command.get(BOUNDARY);
        String country = (String)command.get(COUNTRY);
        Rectangle bound = (Rectangle)command.get(BOUND);
        MultiPolygon inputMultipolygon = (MultiPolygon)command.get(MULTIPOLYGON);
        List startEndRoute = (List)command.get(ROUTE);
        if (pbf != null && pbf.exists()) {
            AtlasLoadingOption option;
            MultiPolygon multiPolygon = MultiPolygon.forPolygon(Rectangle.MAXIMUM);
            if (boundaryFile != null) {
                CountryBoundaryMap boundaryMap = CountryBoundaryMap.fromShapeFile(boundaryFile);
                option = AtlasLoadingOption.createOptionWithAllEnabled(boundaryMap);
                if (country != null) {
                    if (new CountryListTwoWayStringConverter().convert(country).size() == 1) {
                        multiPolygon = boundaryMap.countryBoundary(country).get(0).getBoundary();
                    }
                    option.setAdditionalCountryCodes(country);
                }
            } else {
                option = AtlasLoadingOption.createOptionWithNoSlicing();
            }
            if (bound != null) {
                multiPolygon = MultiPolygon.forPolygon(bound);
            }
            if (inputMultipolygon != null) {
                multiPolygon = inputMultipolygon;
            }
            atlas = new RawAtlasGenerator(pbf, option, multiPolygon).build();
            if (option.isCountrySlicing()) {
                atlas = new RawAtlasCountrySlicer(option).slice(atlas);
            }
            atlas = new WaySectionProcessor(atlas, option).run();
            atlas.save(atlasFile);
        } else if (atlasFile != null && atlasFile.exists()) {
            atlas = new AtlasResourceLoader().load(atlasFile);
        } else {
            logger.error("Must have at least one source, -pbf or -atlas");
            atlas = null;
            System.exit(1);
        }
        logger.info("Loaded {}", (Object)atlas.summary());
        if (geojson != null) {
            atlas.saveAsGeoJson(geojson);
        }
        if (text != null) {
            atlas.saveAsText(text);
        }
        if (startEndRoute != null) {
            logger.info("Route between {} and {} = {}", new Object[]{startEndRoute.get(0), startEndRoute.get(1), AStarRouter.dijkstra(atlas, Distance.TEN_MILES).route((Location)startEndRoute.get(0), (Location)startEndRoute.get(1))});
        }
        return 0;
    }

    @Override
    protected Command.SwitchList switches() {
        return new Command.SwitchList().with(ATLAS, GEOJSON, TEXT, PBF, BOUNDARY, COUNTRY, ROUTE, BOUND, MULTIPOLYGON);
    }
}

