/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.complete;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.geography.Rectangle;
import org.openstreetmap.atlas.geography.atlas.Atlas;
import org.openstreetmap.atlas.geography.atlas.builder.RelationBean;
import org.openstreetmap.atlas.geography.atlas.change.eventhandling.event.TagChangeEvent;
import org.openstreetmap.atlas.geography.atlas.change.eventhandling.listener.TagChangeListener;
import org.openstreetmap.atlas.geography.atlas.complete.CompleteEntity;
import org.openstreetmap.atlas.geography.atlas.complete.CompleteItemType;
import org.openstreetmap.atlas.geography.atlas.complete.EmptyAtlas;
import org.openstreetmap.atlas.geography.atlas.complete.TagChangeDelegate;
import org.openstreetmap.atlas.geography.atlas.items.AtlasEntity;
import org.openstreetmap.atlas.geography.atlas.items.AtlasObject;
import org.openstreetmap.atlas.geography.atlas.items.Relation;
import org.openstreetmap.atlas.geography.atlas.items.RelationMember;
import org.openstreetmap.atlas.geography.atlas.items.RelationMemberList;
import org.openstreetmap.atlas.utilities.collections.Iterables;

public class CompleteRelation
extends Relation
implements CompleteEntity<CompleteRelation> {
    private static final long serialVersionUID = -8295865049110084558L;
    private Rectangle bounds;
    private long identifier;
    private Map<String, String> tags;
    private RelationBean members;
    private List<Long> allRelationsWithSameOsmIdentifier;
    private RelationBean allKnownOsmMembers;
    private Long osmRelationIdentifier;
    private Set<Long> relationIdentifiers;
    private final TagChangeDelegate tagChangeDelegate = TagChangeDelegate.newTagChangeDelegate();

    public static CompleteRelation from(Relation relation) {
        return new CompleteRelation(relation.getIdentifier(), relation.getTags(), relation.bounds(), relation.members().asBean(), relation.allRelationsWithSameOsmIdentifier().stream().map(AtlasObject::getIdentifier).collect(Collectors.toList()), relation.allKnownOsmMembers().asBean(), relation.osmRelationIdentifier(), relation.relations().stream().map(AtlasObject::getIdentifier).collect(Collectors.toSet()));
    }

    public static CompleteRelation shallowFrom(Relation relation) {
        return new CompleteRelation(relation.getIdentifier()).withBoundsExtendedBy(relation.bounds());
    }

    CompleteRelation(long identifier) {
        this(identifier, null, null, null, null, null, null, null);
    }

    public CompleteRelation(Long identifier, Map<String, String> tags, Rectangle bounds, RelationBean members, List<Long> allRelationsWithSameOsmIdentifier, RelationBean allKnownOsmMembers, Long osmRelationIdentifier, Set<Long> relationIdentifiers) {
        super(new EmptyAtlas());
        if (identifier == null) {
            throw new CoreException("Identifier can never be null.");
        }
        this.bounds = bounds != null ? bounds : null;
        this.identifier = identifier;
        this.tags = tags;
        this.members = members;
        this.allRelationsWithSameOsmIdentifier = allRelationsWithSameOsmIdentifier;
        this.allKnownOsmMembers = allKnownOsmMembers;
        this.osmRelationIdentifier = osmRelationIdentifier;
        this.relationIdentifiers = relationIdentifiers;
    }

    protected CompleteRelation(Atlas atlas) {
        super(atlas);
    }

    @Override
    public RelationMemberList allKnownOsmMembers() {
        return this.membersFor(this.allKnownOsmMembers);
    }

    @Override
    public List<Relation> allRelationsWithSameOsmIdentifier() {
        return this.allRelationsWithSameOsmIdentifier == null ? null : this.allRelationsWithSameOsmIdentifier.stream().map(CompleteRelation::new).collect(Collectors.toList());
    }

    @Override
    public Rectangle bounds() {
        return this.bounds;
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof CompleteRelation) {
            CompleteRelation that = (CompleteRelation)other;
            return CompleteEntity.basicEqual(this, that) && CompleteEntity.equalThroughGet(this.members(), that.members(), RelationMemberList::asBean) && Objects.equals(this.allRelationsWithSameOsmIdentifier(), that.allRelationsWithSameOsmIdentifier()) && CompleteEntity.equalThroughGet(this.allKnownOsmMembers(), that.allKnownOsmMembers(), RelationMemberList::asBean) && Objects.equals(this.osmRelationIdentifier(), that.osmRelationIdentifier());
        }
        return false;
    }

    @Override
    public long getIdentifier() {
        return this.identifier;
    }

    @Override
    public Map<String, String> getTags() {
        return this.tags;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean isShallow() {
        return this.bounds == null && this.members == null && this.allRelationsWithSameOsmIdentifier == null && this.allKnownOsmMembers == null && this.osmRelationIdentifier == null && this.tags == null && this.relationIdentifiers == null;
    }

    @Override
    public RelationMemberList members() {
        return this.membersFor(this.members);
    }

    @Override
    public Long osmRelationIdentifier() {
        return this.osmRelationIdentifier;
    }

    @Override
    public Set<Relation> relations() {
        return this.relationIdentifiers == null ? null : this.relationIdentifiers.stream().map(CompleteRelation::new).collect(Collectors.toSet());
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + " [identifier=" + this.identifier + ", tags=" + this.tags + ", members=" + this.members + ", relationIdentifiers=" + this.relationIdentifiers + "]";
    }

    public CompleteRelation withAllKnownOsmMembers(RelationBean allKnownOsmMembers) {
        this.allKnownOsmMembers = allKnownOsmMembers;
        return this;
    }

    public CompleteRelation withAllRelationsWithSameOsmIdentifier(List<Long> allRelationsWithSameOsmIdentifier) {
        this.allRelationsWithSameOsmIdentifier = allRelationsWithSameOsmIdentifier;
        return this;
    }

    public CompleteRelation withBoundsExtendedBy(Rectangle bounds) {
        if (this.bounds == null) {
            this.bounds = bounds;
            return this;
        }
        this.bounds = Rectangle.forLocated(this.bounds, bounds);
        return this;
    }

    public CompleteRelation withExtraMember(AtlasEntity newMember, AtlasEntity memberFromWhichToCopyRole) {
        Relation sourceRelation = Iterables.stream(memberFromWhichToCopyRole.relations()).firstMatching(relation -> relation.getIdentifier() == this.getIdentifier()).orElseThrow(() -> new CoreException("Cannot copy role from {} {} as it does not have relation {} as parent", new Object[]{memberFromWhichToCopyRole.getType(), memberFromWhichToCopyRole.getIdentifier(), this.getIdentifier()}));
        String role = sourceRelation.members().asBean().getItemFor(memberFromWhichToCopyRole.getIdentifier(), memberFromWhichToCopyRole.getType()).orElseThrow(() -> new CoreException("Cannot copy role from {} {} as it is not a member of {} {}", new Object[]{memberFromWhichToCopyRole.getType(), memberFromWhichToCopyRole.getIdentifier(), this.getClass().getSimpleName(), this})).getRole();
        return this.withExtraMember(newMember, role);
    }

    public CompleteRelation withExtraMember(AtlasEntity newMember, String role) {
        this.members.addItem(new RelationBean.RelationBeanItem(newMember.getIdentifier(), role, newMember.getType()));
        this.updateBounds(newMember.bounds());
        return this;
    }

    @Override
    public CompleteRelation withIdentifier(long identifier) {
        this.identifier = identifier;
        return this;
    }

    public CompleteRelation withMembers(RelationBean members, Rectangle bounds) {
        this.members = members;
        this.updateBounds(bounds);
        return this;
    }

    public CompleteRelation withMembers(RelationMemberList members) {
        return this.withMembers(members.asBean(), members.bounds());
    }

    public CompleteRelation withMembersAndSource(RelationBean members, Relation source, Rectangle bounds) {
        if (source == null) {
            throw new CoreException("Source relation must not be null.");
        }
        this.members = members;
        for (RelationMember member : source.members()) {
            if (members.getItemFor(member.getEntity().getIdentifier(), member.getRole(), member.getEntity().getType()).isPresent()) continue;
            this.members.addItemExplicitlyExcluded(member.getEntity().getIdentifier(), member.getRole(), member.getEntity().getType());
        }
        this.updateBounds(bounds);
        return this;
    }

    public CompleteRelation withMembersAndSource(RelationMemberList members, Relation source) {
        if (source instanceof CompleteRelation) {
            throw new CoreException("This version of withMembersAndSource must use a source Relation that is tied to an atlas, instead found Relation of type {}", source.getClass().getName());
        }
        return this.withMembersAndSource(members.asBean(), source, members.bounds());
    }

    public CompleteRelation withOsmRelationIdentifier(Long osmRelationIdentifier) {
        this.osmRelationIdentifier = osmRelationIdentifier;
        return this;
    }

    @Override
    public CompleteRelation withRelationIdentifiers(Set<Long> relationIdentifiers) {
        this.relationIdentifiers = relationIdentifiers;
        return this;
    }

    @Override
    public CompleteRelation withRelations(Set<Relation> relations) {
        this.relationIdentifiers = relations.stream().map(AtlasObject::getIdentifier).collect(Collectors.toSet());
        return this;
    }

    private RelationMemberList membersFor(RelationBean bean) {
        if (bean == null) {
            return null;
        }
        ArrayList<RelationMember> memberList = new ArrayList<RelationMember>();
        for (RelationBean.RelationBeanItem item : bean) {
            memberList.add(new RelationMember(item.getRole(), this.getAtlas().entity(item.getIdentifier(), item.getType()), this.getIdentifier()));
        }
        RelationMemberList result = new RelationMemberList(memberList);
        bean.getExplicitlyExcluded().forEach(result::addItemExplicitlyExcluded);
        return result;
    }

    private void updateBounds(Rectangle bounds) {
        this.bounds = bounds;
    }

    @Override
    public void setTags(Map tags) {
        this.tags = tags;
    }

    @Override
    public CompleteItemType completeItemType() {
        return CompleteItemType.RELATION;
    }

    @Override
    public void addTagChangeListener(TagChangeListener tagChangeListener) {
        this.tagChangeDelegate.addTagChangeListener(tagChangeListener);
    }

    @Override
    public void fireTagChangeEvent(TagChangeEvent tagChangeEvent) {
        this.tagChangeDelegate.fireTagChangeEvent(tagChangeEvent);
    }

    @Override
    public void removeTagChangeListeners() {
        this.tagChangeDelegate.removeTagChangeListeners();
    }
}

