/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.complete;

import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.geography.Location;
import org.openstreetmap.atlas.geography.Rectangle;
import org.openstreetmap.atlas.geography.atlas.change.eventhandling.event.TagChangeEvent;
import org.openstreetmap.atlas.geography.atlas.change.eventhandling.listener.TagChangeListener;
import org.openstreetmap.atlas.geography.atlas.complete.CompleteEdge;
import org.openstreetmap.atlas.geography.atlas.complete.CompleteEntity;
import org.openstreetmap.atlas.geography.atlas.complete.CompleteItemType;
import org.openstreetmap.atlas.geography.atlas.complete.CompleteLocationItem;
import org.openstreetmap.atlas.geography.atlas.complete.CompleteRelation;
import org.openstreetmap.atlas.geography.atlas.complete.EmptyAtlas;
import org.openstreetmap.atlas.geography.atlas.complete.TagChangeDelegate;
import org.openstreetmap.atlas.geography.atlas.items.AtlasObject;
import org.openstreetmap.atlas.geography.atlas.items.Edge;
import org.openstreetmap.atlas.geography.atlas.items.Node;
import org.openstreetmap.atlas.geography.atlas.items.Relation;

public class CompleteNode
extends Node
implements CompleteLocationItem<CompleteNode> {
    private static final long serialVersionUID = -8229589987121555419L;
    private final TagChangeDelegate tagChangeDelegate = TagChangeDelegate.newTagChangeDelegate();
    private Rectangle bounds;
    private long identifier;
    private Location location;
    private Map<String, String> tags;
    private SortedSet<Long> inEdgeIdentifiers;
    private SortedSet<Long> outEdgeIdentifiers;
    private Set<Long> relationIdentifiers;

    public static CompleteNode from(Node node) {
        return new CompleteNode(node.getIdentifier(), node.getLocation(), node.getTags(), node.inEdges().stream().map(AtlasObject::getIdentifier).collect(Collectors.toCollection(TreeSet::new)), node.outEdges().stream().map(AtlasObject::getIdentifier).collect(Collectors.toCollection(TreeSet::new)), node.relations().stream().map(AtlasObject::getIdentifier).collect(Collectors.toSet()));
    }

    public static CompleteNode shallowFrom(Node node) {
        return new CompleteNode(node.getIdentifier()).withBoundsExtendedBy(node.bounds());
    }

    CompleteNode(long identifier) {
        this(identifier, null, null, null, null, null);
    }

    public CompleteNode(Long identifier, Location location, Map<String, String> tags, SortedSet<Long> inEdgeIdentifiers, SortedSet<Long> outEdgeIdentifiers, Set<Long> relationIdentifiers) {
        super(new EmptyAtlas());
        if (identifier == null) {
            throw new CoreException("Identifier can never be null.");
        }
        this.bounds = location != null ? location.bounds() : null;
        this.identifier = identifier;
        this.location = location;
        this.tags = tags;
        this.inEdgeIdentifiers = inEdgeIdentifiers;
        this.outEdgeIdentifiers = outEdgeIdentifiers;
        this.relationIdentifiers = relationIdentifiers;
    }

    @Override
    public Rectangle bounds() {
        return this.bounds;
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof CompleteNode) {
            CompleteNode that = (CompleteNode)other;
            return CompleteEntity.basicEqual(this, that) && Objects.equals(this.getLocation(), that.getLocation()) && Objects.equals(this.inEdges(), that.inEdges()) && Objects.equals(this.outEdges(), that.outEdges());
        }
        return false;
    }

    @Override
    public long getIdentifier() {
        return this.identifier;
    }

    @Override
    public Location getLocation() {
        return this.location;
    }

    @Override
    public Map<String, String> getTags() {
        return this.tags;
    }

    @Override
    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public SortedSet<Edge> inEdges() {
        return this.inEdgeIdentifiers == null ? null : (SortedSet)this.inEdgeIdentifiers.stream().map(CompleteEdge::new).collect(Collectors.toCollection(TreeSet::new));
    }

    @Override
    public boolean isShallow() {
        return this.location == null && this.inEdgeIdentifiers == null && this.outEdgeIdentifiers == null && this.tags == null && this.relationIdentifiers == null;
    }

    @Override
    public SortedSet<Edge> outEdges() {
        return this.outEdgeIdentifiers == null ? null : (SortedSet)this.outEdgeIdentifiers.stream().map(CompleteEdge::new).collect(Collectors.toCollection(TreeSet::new));
    }

    @Override
    public Set<Relation> relations() {
        return this.relationIdentifiers == null ? null : this.relationIdentifiers.stream().map(CompleteRelation::new).collect(Collectors.toSet());
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + " [identifier=" + this.identifier + ", inEdgeIdentifiers=" + this.inEdgeIdentifiers + ", outEdgeIdentifiers=" + this.outEdgeIdentifiers + ", location=" + this.location + ", tags=" + this.tags + ", relationIdentifiers=" + this.relationIdentifiers + "]";
    }

    public CompleteNode withBoundsExtendedBy(Rectangle bounds) {
        if (this.bounds == null) {
            this.bounds = bounds;
            return this;
        }
        this.bounds = Rectangle.forLocated(this.bounds, bounds);
        return this;
    }

    @Override
    public CompleteNode withIdentifier(long identifier) {
        this.identifier = identifier;
        return this;
    }

    public CompleteNode withInEdgeIdentifierExtra(Long extraInEdgeIdentifier) {
        this.inEdgeIdentifiers.add(extraInEdgeIdentifier);
        return this;
    }

    public CompleteNode withInEdgeIdentifierLess(Long lessInEdgeIdentifier) {
        this.inEdgeIdentifiers.remove(lessInEdgeIdentifier);
        return this;
    }

    public CompleteNode withInEdgeIdentifierReplaced(Long beforeInEdgeIdentifier, Long afterInEdgeIdentifier) {
        return this.withInEdgeIdentifierLess(beforeInEdgeIdentifier).withInEdgeIdentifierExtra(afterInEdgeIdentifier);
    }

    public CompleteNode withInEdgeIdentifiers(SortedSet<Long> inEdgeIdentifiers) {
        this.inEdgeIdentifiers = inEdgeIdentifiers;
        return this;
    }

    public CompleteNode withInEdges(Set<Edge> inEdges) {
        this.inEdgeIdentifiers = inEdges.stream().map(AtlasObject::getIdentifier).collect(Collectors.toCollection(TreeSet::new));
        return this;
    }

    @Override
    public CompleteNode withLocation(Location location) {
        this.location = location;
        this.bounds = location.bounds();
        return this;
    }

    public CompleteNode withOutEdgeIdentifierExtra(Long extraOutEdgeIdentifier) {
        this.outEdgeIdentifiers.add(extraOutEdgeIdentifier);
        return this;
    }

    public CompleteNode withOutEdgeIdentifierLess(Long lessOutEdgeIdentifier) {
        this.outEdgeIdentifiers.remove(lessOutEdgeIdentifier);
        return this;
    }

    public CompleteNode withOutEdgeIdentifierReplaced(Long beforeOutEdgeIdentifier, Long afterOutEdgeIdentifier) {
        return this.withOutEdgeIdentifierLess(beforeOutEdgeIdentifier).withOutEdgeIdentifierExtra(afterOutEdgeIdentifier);
    }

    public CompleteNode withOutEdgeIdentifiers(SortedSet<Long> outEdgeIdentifiers) {
        this.outEdgeIdentifiers = outEdgeIdentifiers;
        return this;
    }

    public CompleteNode withOutEdges(Set<Edge> outEdges) {
        this.outEdgeIdentifiers = outEdges.stream().map(AtlasObject::getIdentifier).collect(Collectors.toCollection(TreeSet::new));
        return this;
    }

    @Override
    public CompleteNode withRelationIdentifiers(Set<Long> relationIdentifiers) {
        this.relationIdentifiers = relationIdentifiers;
        return this;
    }

    @Override
    public CompleteNode withRelations(Set<Relation> relations) {
        this.relationIdentifiers = relations.stream().map(AtlasObject::getIdentifier).collect(Collectors.toSet());
        return this;
    }

    @Override
    public CompleteItemType completeItemType() {
        return CompleteItemType.NODE;
    }

    @Override
    public void addTagChangeListener(TagChangeListener tagChangeListener) {
        this.tagChangeDelegate.addTagChangeListener(tagChangeListener);
    }

    @Override
    public void fireTagChangeEvent(TagChangeEvent tagChangeEvent) {
        this.tagChangeDelegate.fireTagChangeEvent(tagChangeEvent);
    }

    @Override
    public void removeTagChangeListeners() {
        this.tagChangeDelegate.removeTagChangeListeners();
    }
}

