/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.complete;

import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.geography.PolyLine;
import org.openstreetmap.atlas.geography.Rectangle;
import org.openstreetmap.atlas.geography.atlas.change.eventhandling.event.TagChangeEvent;
import org.openstreetmap.atlas.geography.atlas.change.eventhandling.listener.TagChangeListener;
import org.openstreetmap.atlas.geography.atlas.complete.CompleteEntity;
import org.openstreetmap.atlas.geography.atlas.complete.CompleteItemType;
import org.openstreetmap.atlas.geography.atlas.complete.CompleteLineItem;
import org.openstreetmap.atlas.geography.atlas.complete.CompleteNode;
import org.openstreetmap.atlas.geography.atlas.complete.CompleteRelation;
import org.openstreetmap.atlas.geography.atlas.complete.EmptyAtlas;
import org.openstreetmap.atlas.geography.atlas.complete.TagChangeDelegate;
import org.openstreetmap.atlas.geography.atlas.items.AtlasObject;
import org.openstreetmap.atlas.geography.atlas.items.Edge;
import org.openstreetmap.atlas.geography.atlas.items.Node;
import org.openstreetmap.atlas.geography.atlas.items.Relation;

public class CompleteEdge
extends Edge
implements CompleteLineItem<CompleteEdge> {
    private static final long serialVersionUID = 309534717673911086L;
    private Rectangle bounds;
    private long identifier;
    private PolyLine polyLine;
    private Map<String, String> tags;
    private Long startNodeIdentifier;
    private Long endNodeIdentifier;
    private Set<Long> relationIdentifiers;
    private final TagChangeDelegate tagChangeDelegate = TagChangeDelegate.newTagChangeDelegate();

    public static CompleteEdge from(Edge edge) {
        return new CompleteEdge(edge.getIdentifier(), edge.asPolyLine(), edge.getTags(), edge.start().getIdentifier(), edge.end().getIdentifier(), edge.relations().stream().map(AtlasObject::getIdentifier).collect(Collectors.toSet()));
    }

    public static CompleteEdge shallowFrom(Edge edge) {
        return new CompleteEdge(edge.getIdentifier()).withBoundsExtendedBy(edge.bounds());
    }

    CompleteEdge(long identifier) {
        this(identifier, null, null, null, null, null);
    }

    public CompleteEdge(Long identifier, PolyLine polyLine, Map<String, String> tags, Long startNodeIdentifier, Long endNodeIdentifier, Set<Long> relationIdentifiers) {
        super(new EmptyAtlas());
        if (identifier == null) {
            throw new CoreException("Identifier can never be null.");
        }
        this.bounds = polyLine != null ? polyLine.bounds() : null;
        this.identifier = identifier;
        this.polyLine = polyLine;
        this.tags = tags;
        this.startNodeIdentifier = startNodeIdentifier;
        this.endNodeIdentifier = endNodeIdentifier;
        this.relationIdentifiers = relationIdentifiers;
    }

    @Override
    public PolyLine asPolyLine() {
        return this.polyLine;
    }

    @Override
    public Rectangle bounds() {
        return this.bounds;
    }

    @Override
    public Node end() {
        return this.endNodeIdentifier == null ? null : new CompleteNode(this.endNodeIdentifier);
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof CompleteEdge) {
            CompleteEdge that = (CompleteEdge)other;
            return CompleteEntity.basicEqual(this, that) && Objects.equals(this.asPolyLine(), that.asPolyLine()) && CompleteEntity.equalThroughGet(this.start(), that.start(), AtlasObject::getIdentifier) && CompleteEntity.equalThroughGet(this.end(), that.end(), AtlasObject::getIdentifier);
        }
        return false;
    }

    @Override
    public long getIdentifier() {
        return this.identifier;
    }

    @Override
    public Map<String, String> getTags() {
        return this.tags;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean isShallow() {
        return this.polyLine == null && this.startNodeIdentifier == null && this.endNodeIdentifier == null && this.tags == null && this.relationIdentifiers == null;
    }

    @Override
    public Set<Relation> relations() {
        return this.relationIdentifiers == null ? null : this.relationIdentifiers.stream().map(CompleteRelation::new).collect(Collectors.toSet());
    }

    @Override
    public Node start() {
        return this.startNodeIdentifier == null ? null : new CompleteNode(this.startNodeIdentifier);
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + " [identifier=" + this.identifier + ", startNodeIdentifier=" + this.startNodeIdentifier + ", endNodeIdentifier=" + this.endNodeIdentifier + ", polyLine=" + this.polyLine + ", tags=" + this.tags + ", relationIdentifiers=" + this.relationIdentifiers + "]";
    }

    public CompleteEdge withBoundsExtendedBy(Rectangle bounds) {
        if (this.bounds == null) {
            this.bounds = bounds;
            return this;
        }
        this.bounds = Rectangle.forLocated(this.bounds, bounds);
        return this;
    }

    public CompleteEdge withEndNodeIdentifier(Long endNodeIdentifier) {
        this.endNodeIdentifier = endNodeIdentifier;
        return this;
    }

    @Override
    public CompleteEdge withIdentifier(long identifier) {
        this.identifier = identifier;
        return this;
    }

    @Override
    public CompleteEdge withPolyLine(PolyLine polyLine) {
        this.polyLine = polyLine;
        this.bounds = polyLine.bounds();
        return this;
    }

    @Override
    public CompleteEdge withRelationIdentifiers(Set<Long> relationIdentifiers) {
        this.relationIdentifiers = relationIdentifiers;
        return this;
    }

    @Override
    public CompleteEdge withRelations(Set<Relation> relations) {
        this.relationIdentifiers = relations.stream().map(AtlasObject::getIdentifier).collect(Collectors.toSet());
        return this;
    }

    public CompleteEdge withStartNodeIdentifier(Long startNodeIdentifier) {
        this.startNodeIdentifier = startNodeIdentifier;
        return this;
    }

    @Override
    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    @Override
    public CompleteItemType completeItemType() {
        return CompleteItemType.EDGE;
    }

    @Override
    public void addTagChangeListener(TagChangeListener tagChangeListener) {
        this.tagChangeDelegate.addTagChangeListener(tagChangeListener);
    }

    @Override
    public void fireTagChangeEvent(TagChangeEvent tagChangeEvent) {
        this.tagChangeDelegate.fireTagChangeEvent(tagChangeEvent);
    }

    @Override
    public void removeTagChangeListeners() {
        this.tagChangeDelegate.removeTagChangeListeners();
    }
}

