/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.complete;

import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.geography.Polygon;
import org.openstreetmap.atlas.geography.Rectangle;
import org.openstreetmap.atlas.geography.atlas.change.eventhandling.event.TagChangeEvent;
import org.openstreetmap.atlas.geography.atlas.change.eventhandling.listener.TagChangeListener;
import org.openstreetmap.atlas.geography.atlas.complete.CompleteEntity;
import org.openstreetmap.atlas.geography.atlas.complete.CompleteItemType;
import org.openstreetmap.atlas.geography.atlas.complete.CompleteRelation;
import org.openstreetmap.atlas.geography.atlas.complete.EmptyAtlas;
import org.openstreetmap.atlas.geography.atlas.complete.TagChangeDelegate;
import org.openstreetmap.atlas.geography.atlas.items.Area;
import org.openstreetmap.atlas.geography.atlas.items.AtlasObject;
import org.openstreetmap.atlas.geography.atlas.items.Relation;

public class CompleteArea
extends Area
implements CompleteEntity<CompleteArea> {
    private static final long serialVersionUID = 309534717673911086L;
    private Rectangle bounds;
    private long identifier;
    private Polygon polygon;
    private Map<String, String> tags;
    private Set<Long> relationIdentifiers;
    private final TagChangeDelegate tagChangeDelegate = TagChangeDelegate.newTagChangeDelegate();

    public static CompleteArea from(Area area) {
        return new CompleteArea(area.getIdentifier(), area.asPolygon(), area.getTags(), area.relations().stream().map(AtlasObject::getIdentifier).collect(Collectors.toSet()));
    }

    public static CompleteArea shallowFrom(Area area) {
        return new CompleteArea(area.getIdentifier()).withBoundsExtendedBy(area.bounds());
    }

    CompleteArea(long identifier) {
        this(identifier, null, null, null);
    }

    public CompleteArea(Long identifier, Polygon polygon, Map<String, String> tags, Set<Long> relationIdentifiers) {
        super(new EmptyAtlas());
        if (identifier == null) {
            throw new CoreException("Identifier can never be null.");
        }
        this.bounds = polygon != null ? polygon.bounds() : null;
        this.identifier = identifier;
        this.polygon = polygon;
        this.tags = tags;
        this.relationIdentifiers = relationIdentifiers;
    }

    @Override
    public Polygon asPolygon() {
        return this.polygon;
    }

    @Override
    public Rectangle bounds() {
        return this.bounds;
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof CompleteArea) {
            CompleteArea that = (CompleteArea)other;
            return CompleteEntity.basicEqual(this, that) && Objects.equals(this.asPolygon(), that.asPolygon());
        }
        return false;
    }

    @Override
    public long getIdentifier() {
        return this.identifier;
    }

    @Override
    public Map<String, String> getTags() {
        return this.tags;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean isShallow() {
        return this.polygon == null && this.tags == null && this.relationIdentifiers == null;
    }

    @Override
    public Set<Relation> relations() {
        return this.relationIdentifiers == null ? null : this.relationIdentifiers.stream().map(CompleteRelation::new).collect(Collectors.toSet());
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + " [identifier=" + this.identifier + ", polygon=" + this.polygon + ", tags=" + this.tags + ", relationIdentifiers=" + this.relationIdentifiers + "]";
    }

    public CompleteArea withBoundsExtendedBy(Rectangle bounds) {
        if (this.bounds == null) {
            this.bounds = bounds;
            return this;
        }
        this.bounds = Rectangle.forLocated(this.bounds, bounds);
        return this;
    }

    @Override
    public CompleteArea withIdentifier(long identifier) {
        this.identifier = identifier;
        return this;
    }

    public CompleteArea withPolygon(Polygon polygon) {
        this.polygon = polygon;
        this.bounds = polygon.bounds();
        return this;
    }

    @Override
    public CompleteArea withRelationIdentifiers(Set<Long> relationIdentifiers) {
        this.relationIdentifiers = relationIdentifiers;
        return this;
    }

    @Override
    public CompleteArea withRelations(Set<Relation> relations) {
        this.relationIdentifiers = relations.stream().map(AtlasObject::getIdentifier).collect(Collectors.toSet());
        return this;
    }

    @Override
    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    @Override
    public CompleteItemType completeItemType() {
        return CompleteItemType.AREA;
    }

    @Override
    public void addTagChangeListener(TagChangeListener tagChangeListener) {
        this.tagChangeDelegate.addTagChangeListener(tagChangeListener);
    }

    @Override
    public void fireTagChangeEvent(TagChangeEvent tagChangeEvent) {
        this.tagChangeDelegate.fireTagChangeEvent(tagChangeEvent);
    }

    @Override
    public void removeTagChangeListeners() {
        this.tagChangeDelegate.removeTagChangeListeners();
    }
}

