/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.command;

import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.stream.StreamSupport;
import org.openstreetmap.atlas.geography.atlas.Atlas;
import org.openstreetmap.atlas.geography.atlas.command.AbstractAtlasSubCommand;
import org.openstreetmap.atlas.geography.atlas.packed.PackedAtlas;
import org.openstreetmap.atlas.geography.atlas.packed.PackedAtlasCloner;
import org.openstreetmap.atlas.geography.atlas.sub.AtlasCutType;
import org.openstreetmap.atlas.geography.sharding.SlippyTile;
import org.openstreetmap.atlas.streaming.resource.File;
import org.openstreetmap.atlas.streaming.resource.FileSuffix;
import org.openstreetmap.atlas.utilities.runtime.Command;
import org.openstreetmap.atlas.utilities.runtime.CommandMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtlasSplitterWithSlippyTileCommand
extends AbstractAtlasSubCommand {
    private static final Logger logger = LoggerFactory.getLogger(AtlasSplitterWithSlippyTileCommand.class);
    private static final Command.Switch<Integer> ZOOM_LEVEL = new Command.Switch("zoom_level", "Input zoom level", Integer::new, Command.Optionality.REQUIRED);
    private static final Command.Switch<Path> OUTPUT_FOLDER_PARAMETER = new Command.Switch("output", "The path to save Atlas files", x$0 -> Paths.get(x$0, new String[0]), Command.Optionality.REQUIRED);

    public AtlasSplitterWithSlippyTileCommand() {
        super("split", "Split one Atlas file into several small Atlas files with fixed zoom level");
    }

    @Override
    public Command.SwitchList switches() {
        return super.switches().with(ZOOM_LEVEL, OUTPUT_FOLDER_PARAMETER);
    }

    @Override
    public void usage(PrintStream writer) {
        writer.printf("-input=/path/to/atlas/files : the atlas files we want to load\n", new Object[0]);
        writer.printf("-zoom_level=<the zoom level you want to check>\n", new Object[0]);
        writer.printf("-output=/path/to/atlas/output/to/save : the path to output atlas files\n", new Object[0]);
    }

    @Override
    protected void handle(Atlas atlas, CommandMap command) {
        int zoomLevel = (Integer)command.get(ZOOM_LEVEL);
        Path path = (Path)command.get(OUTPUT_FOLDER_PARAMETER);
        try {
            Files.createDirectories(path, new FileAttribute[0]);
        }
        catch (IOException e) {
            logger.error("Error when creating output directory", (Throwable)e);
            return;
        }
        StreamSupport.stream(SlippyTile.allTiles(zoomLevel, atlas.bounds()).spliterator(), false).map(tile -> this.buildAtlasBasedOnTile((SlippyTile)tile, atlas)).forEach(newAtlas -> {
            if (newAtlas != null) {
                String outputFileName = path.toString() + "/" + atlas.getName() + "_" + newAtlas.getIdentifier() + (Object)((Object)FileSuffix.ATLAS);
                logger.info("Saving Atlas file into {}", (Object)outputFileName);
                newAtlas.save(new File(outputFileName));
            }
        });
    }

    private PackedAtlas buildAtlasBasedOnTile(SlippyTile tile, Atlas atlas) {
        return atlas.subAtlas(tile.bounds(), AtlasCutType.SOFT_CUT).map(subAtlas -> new PackedAtlasCloner().cloneFrom((Atlas)subAtlas)).orElse(null);
    }
}

