/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.command;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.TreeSet;
import java.util.stream.StreamSupport;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.geography.atlas.Atlas;
import org.openstreetmap.atlas.geography.atlas.command.AbstractAtlasSubCommand;
import org.openstreetmap.atlas.geography.atlas.items.complex.restriction.ComplexTurnRestrictionFinder;
import org.openstreetmap.atlas.streaming.resource.File;
import org.openstreetmap.atlas.utilities.runtime.Command;
import org.openstreetmap.atlas.utilities.runtime.CommandMap;

public class AtlasListValidTurnRestrictionIds
extends AbstractAtlasSubCommand {
    private static final Command.Switch<File> OUTPUT_PARAMETER = new Command.Switch("output", "The output file to list all turn restriction ids", value -> new File((String)value), Command.Optionality.REQUIRED);
    private final TreeSet<Long> turnRestrictions = new TreeSet();

    public AtlasListValidTurnRestrictionIds() {
        super("turnRestrictions", "lists turn restriction OsmIds");
    }

    @Override
    public Command.SwitchList switches() {
        return super.switches().with(OUTPUT_PARAMETER);
    }

    @Override
    public void usage(PrintStream writer) {
        writer.printf("-input=/path/to/atlas/files : the atlas files we want to load\n", new Object[0]);
    }

    @Override
    protected int finish(CommandMap command) {
        File file = (File)command.get(OUTPUT_PARAMETER);
        try (PrintStream out = new PrintStream(new FileOutputStream(file.getFile(), true));){
            this.turnRestrictions.forEach(value -> out.println(value));
        }
        catch (IOException oops) {
            throw new CoreException("Error writing turnRestriction ids to file", oops);
        }
        return 0;
    }

    @Override
    protected void handle(Atlas atlas, CommandMap command) {
        StreamSupport.stream(new ComplexTurnRestrictionFinder().find(atlas).spliterator(), false).filter(turnRestriction -> turnRestriction.isValid()).map(turnRestriction -> turnRestriction.getOsmIdentifier()).forEach(this.turnRestrictions::add);
    }
}

