/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.command;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.StreamSupport;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.geography.Rectangle;
import org.openstreetmap.atlas.geography.atlas.Atlas;
import org.openstreetmap.atlas.geography.atlas.command.AbstractAtlasSubCommand;
import org.openstreetmap.atlas.geography.atlas.items.AtlasEntity;
import org.openstreetmap.atlas.geography.atlas.multi.MultiAtlas;
import org.openstreetmap.atlas.geography.atlas.packed.PackedAtlas;
import org.openstreetmap.atlas.geography.atlas.packed.PackedAtlasCloner;
import org.openstreetmap.atlas.geography.atlas.sub.AtlasCutType;
import org.openstreetmap.atlas.streaming.resource.File;
import org.openstreetmap.atlas.utilities.runtime.Command;
import org.openstreetmap.atlas.utilities.runtime.CommandMap;
import org.openstreetmap.atlas.utilities.scalars.Distance;
import org.slf4j.LoggerFactory;

abstract class AbstractAtlasOutputTestSubCommand
extends AbstractAtlasSubCommand {
    private static final Command.Switch<Path> OUTPUT_TO_PACKED_ATLAS_PARAMETER = new Command.Switch("packed-output", "Outputs the found atlas pieces into a packed atlas for testing", x$0 -> Paths.get(x$0, new String[0]), Command.Optionality.OPTIONAL);
    private static final Command.Switch<Path> OUTPUT_TO_TEXT_PARAMETER = new Command.Switch("text-output", "Outputs the found atlas pieces into text for testing", x$0 -> Paths.get(x$0, new String[0]), Command.Optionality.OPTIONAL);
    private static final Command.Switch<Double> DISTANCE_IN_METERS_PARAMETER = new Command.Switch("expand", "Expands the search bounds by this optional parameter in meters", Double::new, Command.Optionality.OPTIONAL);
    private ConcurrentHashMap.KeySetView<Atlas, Boolean> subAtlases;
    private Optional<Double> distanceInMeters;
    private Path outputTextPath;
    private Path packedAtlasPath;

    protected AbstractAtlasOutputTestSubCommand(String name, String description) {
        super(name, description);
    }

    @Override
    public Command.SwitchList switches() {
        return super.switches().with(OUTPUT_TO_PACKED_ATLAS_PARAMETER, OUTPUT_TO_TEXT_PARAMETER, DISTANCE_IN_METERS_PARAMETER);
    }

    @Override
    public void usage(PrintStream writer) {
        writer.printf("-input=/path/to/atlas/files : the atlas files we want to load\n", new Object[0]);
        writer.printf("-packed-output=/output/to/packed/atlas : the file we should send the packed Atlas to if it exists\n", new Object[0]);
        writer.printf("-text-output=/output/to/text/file : the file we should send the text data of the Atlas if it exists\n", new Object[0]);
        writer.printf("-expand=[distance in meters] : how far we should expand around the building we've found for the subatlas we're saving\n", new Object[0]);
    }

    protected abstract boolean filter(AtlasEntity var1);

    @Override
    protected int finish(CommandMap command) {
        if (this.subAtlases.isEmpty()) {
            LoggerFactory.getLogger(this.getClass()).info("No items found");
            return -1;
        }
        if (this.packedAtlasPath != null) {
            MultiAtlas atlas = new MultiAtlas(this.subAtlases);
            try {
                PackedAtlas saveMe = new PackedAtlasCloner().cloneFrom(atlas);
                Files.createDirectories(this.packedAtlasPath.getParent(), new FileAttribute[0]);
                saveMe.save(new File(this.packedAtlasPath.toFile()));
                LoggerFactory.getLogger(this.getClass()).info("Packed atlas saved to {}", (Object)this.packedAtlasPath);
            }
            catch (IOException oops) {
                throw new CoreException("Error when saving packed atlas", oops);
            }
        }
        if (this.outputTextPath != null) {
            new MultiAtlas((List<Atlas>)ImmutableList.copyOf(this.subAtlases.iterator())).saveAsText(new File(this.outputTextPath.toFile()));
            LoggerFactory.getLogger(this.getClass()).info("Text atlas saved to {}", (Object)this.outputTextPath);
        }
        return 0;
    }

    @Override
    protected void handle(Atlas atlas, CommandMap command) {
        StreamSupport.stream(atlas.entities(i -> i.getOsmIdentifier() > 0L).spliterator(), false).filter(this::filter).forEach(this::output);
    }

    @Override
    protected void start(CommandMap command) {
        this.subAtlases = ConcurrentHashMap.newKeySet();
        this.distanceInMeters = command.getOption(DISTANCE_IN_METERS_PARAMETER);
        command.getOption(OUTPUT_TO_TEXT_PARAMETER).ifPresent(path -> {
            this.outputTextPath = path;
        });
        command.getOption(OUTPUT_TO_PACKED_ATLAS_PARAMETER).ifPresent(path -> {
            this.packedAtlasPath = path;
        });
        if (this.outputTextPath == null && this.packedAtlasPath == null) {
            throw new CoreException("Either -packed-output or -text-output must have a value");
        }
    }

    private void output(AtlasEntity item) {
        Rectangle rectangle = item.bounds();
        if (this.distanceInMeters.isPresent()) {
            rectangle = rectangle.expand(Distance.meters(this.distanceInMeters.get()));
        }
        item.getAtlas().subAtlas(rectangle, AtlasCutType.SOFT_CUT).ifPresent(this.subAtlases::add);
    }
}

