/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.change.validators;

import java.util.Optional;
import java.util.function.BiPredicate;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.geography.PolyLine;
import org.openstreetmap.atlas.geography.atlas.change.Change;
import org.openstreetmap.atlas.geography.atlas.change.ChangeType;
import org.openstreetmap.atlas.geography.atlas.change.FeatureChange;
import org.openstreetmap.atlas.geography.atlas.items.Edge;
import org.openstreetmap.atlas.geography.atlas.items.ItemType;
import org.openstreetmap.atlas.geography.atlas.items.Node;
import org.openstreetmap.atlas.utilities.time.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChangeValidator {
    private static final Logger logger = LoggerFactory.getLogger(ChangeValidator.class);
    private final Change change;

    public ChangeValidator(Change change) {
        this.change = change;
    }

    public void validate() {
        logger.trace("Starting validation of Change {}", (Object)this.change.getName());
        Time start = Time.now();
        this.validateChangeNotEmpty();
        this.validateReverseEdgesHaveForwardMatchingCounterpart();
        logger.trace("Finished validation of Change {} in {}", (Object)this.change.getName(), (Object)start.elapsedSince());
    }

    protected void validateChangeNotEmpty() {
        if (this.change.changeCount() == 0) {
            throw new CoreException("Change cannot be empty.");
        }
    }

    protected void validateReverseEdgesHaveForwardMatchingCounterpart() {
        this.change.changesFor(ItemType.EDGE).filter(featureChange -> !((Edge)featureChange.getAfterView()).isMasterEdge()).filter(featureChange -> featureChange.getChangeType() != ChangeType.REMOVE).forEach(backwardFeatureChange -> {
            long backwardEdgeIdentifier = backwardFeatureChange.getAfterView().getIdentifier();
            long forwardEdgeIdentifier = -backwardEdgeIdentifier;
            Edge backwardEdge = (Edge)backwardFeatureChange.getAfterView();
            Optional<FeatureChange> forwardFeatureChangeOption = this.change.changeFor(ItemType.EDGE, forwardEdgeIdentifier);
            if (forwardFeatureChangeOption.isPresent()) {
                FeatureChange forwardFeatureChange = forwardFeatureChangeOption.get();
                if (forwardFeatureChange.getChangeType() != backwardFeatureChange.getChangeType()) {
                    throw new CoreException("Forward edge {} is {} when backward edge is {}", new Object[]{forwardEdgeIdentifier, forwardFeatureChange.getChangeType(), backwardFeatureChange.getChangeType()});
                }
                if (forwardFeatureChange.getChangeType() == ChangeType.ADD) {
                    Edge forwardEdge = (Edge)forwardFeatureChange.getAfterView();
                    this.validateEdgeConnectedNodesMatch(forwardEdge, backwardEdge);
                    this.validateEdgePolyLinesMatch(forwardEdge, backwardEdge);
                }
            }
        });
    }

    private <T> boolean differ(T left, T right, BiPredicate<T, T> equal) {
        if (left == null && right != null || left != null && right == null) {
            return true;
        }
        if (left != null) {
            return !equal.test(left, right);
        }
        return false;
    }

    private void validateEdgeConnectedNodesMatch(Edge forwardEdge, Edge backwardEdge) {
        Node backwardStartNode;
        Node backwardEndNode;
        BiPredicate<Node, Node> equal = (left, right) -> left.getIdentifier() == right.getIdentifier();
        long forwardEdgeIdentifier = forwardEdge.getIdentifier();
        Node forwardStartNode = forwardEdge.start();
        if (this.differ(forwardStartNode, backwardEndNode = backwardEdge.end(), equal)) {
            throw new CoreException("Forward edge {} start node {} does not match its backward edge end node {}", forwardEdgeIdentifier, forwardStartNode, backwardEndNode);
        }
        Node forwardEndNode = forwardEdge.end();
        if (this.differ(forwardEndNode, backwardStartNode = backwardEdge.start(), equal)) {
            throw new CoreException("Forward edge {} end node {} does not match its backward edge start node {}", forwardEdgeIdentifier, forwardEndNode, backwardStartNode);
        }
    }

    private void validateEdgePolyLinesMatch(Edge forwardEdge, Edge backwardEdge) {
        PolyLine backwardPolyLine;
        BiPredicate<PolyLine, PolyLine> equal = (left, right) -> left.equals(right.reversed());
        long forwardEdgeIdentifier = forwardEdge.getIdentifier();
        PolyLine forwardPolyLine = forwardEdge.asPolyLine();
        if (this.differ(forwardPolyLine, backwardPolyLine = backwardEdge.asPolyLine(), equal)) {
            throw new CoreException("Forward edge {} polyline {} does not match its backward edge polyline {}", forwardEdgeIdentifier, forwardPolyLine, backwardPolyLine);
        }
    }
}

