/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.change.testing;

import com.google.common.collect.Lists;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.SortedSet;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.openstreetmap.atlas.geography.Rectangle;
import org.openstreetmap.atlas.geography.atlas.Atlas;
import org.openstreetmap.atlas.geography.atlas.builder.RelationBean;
import org.openstreetmap.atlas.geography.atlas.change.AtlasChangeGenerator;
import org.openstreetmap.atlas.geography.atlas.change.FeatureChange;
import org.openstreetmap.atlas.geography.atlas.complete.CompleteEdge;
import org.openstreetmap.atlas.geography.atlas.complete.CompleteNode;
import org.openstreetmap.atlas.geography.atlas.complete.CompleteRelation;
import org.openstreetmap.atlas.geography.atlas.items.AtlasEntity;
import org.openstreetmap.atlas.geography.atlas.items.AtlasObject;
import org.openstreetmap.atlas.geography.atlas.items.Edge;
import org.openstreetmap.atlas.geography.atlas.items.ItemType;
import org.openstreetmap.atlas.geography.atlas.items.Node;
import org.openstreetmap.atlas.geography.atlas.items.Relation;
import org.openstreetmap.atlas.utilities.collections.Maps;
import org.openstreetmap.atlas.utilities.collections.Sets;

public class AtlasChangeGeneratorAddTurnRestrictions
implements AtlasChangeGenerator {
    private static final long serialVersionUID = -518515697422424803L;
    private static final int MINIMUM_NODE_VALENCE = 3;
    private final int minimumNodeValence;

    public AtlasChangeGeneratorAddTurnRestrictions() {
        this(3);
    }

    public AtlasChangeGeneratorAddTurnRestrictions(int minimumNodeValence) {
        this.minimumNodeValence = minimumNodeValence;
    }

    @Override
    public Set<FeatureChange> generateWithoutValidation(Atlas atlas) {
        AtomicLong identifierGenerator = new AtomicLong();
        HashSet<FeatureChange> result = new HashSet<FeatureChange>();
        Long parentRelationIdentifier = identifierGenerator.incrementAndGet();
        RelationBean parentMembers = new RelationBean();
        Rectangle parentBounds = null;
        for (Node node2 : atlas.nodes(node -> node.valence() > (long)this.minimumNodeValence)) {
            SortedSet<Edge> inEdges = node2.inEdges();
            SortedSet<Edge> outEdges = node2.outEdges();
            Iterator iterator = inEdges.iterator();
            if (!iterator.hasNext()) continue;
            Edge inEdge = (Edge)iterator.next();
            Iterator iterator2 = outEdges.iterator();
            if (!iterator2.hasNext()) continue;
            Edge outEdge = (Edge)iterator2.next();
            RelationBean members = new RelationBean();
            members.addItem(inEdge.getIdentifier(), "from", ItemType.EDGE);
            inEdge.reversed().ifPresent(reversed -> members.addItem(reversed.getIdentifier(), "from", ItemType.EDGE));
            members.addItem(node2.getIdentifier(), "via", ItemType.NODE);
            members.addItem(outEdge.getIdentifier(), "to", ItemType.EDGE);
            outEdge.reversed().ifPresent(reversed -> members.addItem(reversed.getIdentifier(), "to", ItemType.EDGE));
            Long relationIdentifier = identifierGenerator.incrementAndGet();
            Rectangle bounds = Rectangle.forLocated(inEdge, outEdge);
            parentBounds = parentBounds == null ? bounds : Rectangle.forLocated(parentBounds, bounds);
            parentMembers.addItem(relationIdentifier, "addition", ItemType.RELATION);
            result.add(FeatureChange.add(new CompleteRelation(relationIdentifier, Maps.hashMap("type", "restriction", "restriction", "no_left_turn"), bounds, members, Lists.newArrayList(relationIdentifier), members, relationIdentifier, Sets.hashSet(parentRelationIdentifier))));
            result.add(FeatureChange.add((AtlasEntity)((Object)CompleteEdge.shallowFrom(inEdge).withRelationIdentifiers((Set)this.mergeRelationMembers(inEdge.relations(), relationIdentifier)))));
            if (inEdge.hasReverseEdge()) {
                result.add(FeatureChange.add((AtlasEntity)((Object)CompleteEdge.shallowFrom(inEdge.reversed().get()).withRelationIdentifiers((Set)this.mergeRelationMembers(inEdge.relations(), relationIdentifier)))));
            }
            result.add(FeatureChange.add((AtlasEntity)((Object)CompleteNode.shallowFrom(node2).withRelationIdentifiers((Set)this.mergeRelationMembers(node2.relations(), relationIdentifier)))));
            result.add(FeatureChange.add((AtlasEntity)((Object)CompleteEdge.shallowFrom(outEdge).withRelationIdentifiers((Set)this.mergeRelationMembers(outEdge.relations(), relationIdentifier)))));
            if (!outEdge.hasReverseEdge()) continue;
            result.add(FeatureChange.add((AtlasEntity)((Object)CompleteEdge.shallowFrom(outEdge.reversed().get()).withRelationIdentifiers((Set)this.mergeRelationMembers(outEdge.relations(), relationIdentifier)))));
        }
        if (!result.isEmpty()) {
            result.add(FeatureChange.add(new CompleteRelation(parentRelationIdentifier, Maps.hashMap("name", "parent_of_new_restrictions"), parentBounds, parentMembers, Lists.newArrayList(parentRelationIdentifier), parentMembers, parentRelationIdentifier, Sets.hashSet(new Long[0]))));
        }
        return result;
    }

    private Set<Long> mergeRelationMembers(Set<Relation> relations, Long newIdentifier) {
        return Sets.withSets(relations.stream().map(AtlasObject::getIdentifier).collect(Collectors.toSet()), Sets.hashSet(newIdentifier));
    }
}

