/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.change.serializer;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.geography.GeometryPrintable;
import org.openstreetmap.atlas.geography.Rectangle;
import org.openstreetmap.atlas.geography.WktPrintable;
import org.openstreetmap.atlas.geography.atlas.change.FeatureChange;
import org.openstreetmap.atlas.geography.atlas.items.Area;
import org.openstreetmap.atlas.geography.atlas.items.AtlasEntity;
import org.openstreetmap.atlas.geography.atlas.items.AtlasObject;
import org.openstreetmap.atlas.geography.atlas.items.Edge;
import org.openstreetmap.atlas.geography.atlas.items.LineItem;
import org.openstreetmap.atlas.geography.atlas.items.LocationItem;
import org.openstreetmap.atlas.geography.atlas.items.Node;
import org.openstreetmap.atlas.geography.atlas.items.Relation;
import org.openstreetmap.atlas.geography.geojson.GeoJson;
import org.openstreetmap.atlas.geography.geojson.GeoJsonGeometry;
import org.openstreetmap.atlas.streaming.resource.WritableResource;
import org.openstreetmap.atlas.streaming.writers.SafeBufferedWriter;
import org.openstreetmap.atlas.utilities.collections.Iterables;
import org.openstreetmap.atlas.utilities.conversion.Converter;

public class FeatureChangeGeoJsonSerializer
implements BiConsumer<FeatureChange, WritableResource>,
Converter<FeatureChange, String> {
    private static final String NULL = "null";
    private static final Gson jsonSerializer;

    private static <T> void add(JsonObject result, String name, T property, Function<T, JsonElement> writer) {
        if (property == null) {
            result.addProperty(name, NULL);
        } else {
            result.add(name, writer.apply(property));
        }
    }

    private static <T> void addProperty(JsonObject result, String name, T property, Function<T, ? extends Object> writer) {
        result.addProperty(name, property == null ? NULL : writer.apply(property).toString());
    }

    @Override
    public void accept(FeatureChange featureChange, WritableResource resource) {
        try (SafeBufferedWriter writer = resource.writer();){
            jsonSerializer.toJson((Object)featureChange, (Appendable)writer);
        }
        catch (IOException e) {
            throw new CoreException("Could not save FeatureChange to resource {}", resource.getName(), e);
        }
    }

    @Override
    public String convert(FeatureChange featureChange) {
        return jsonSerializer.toJson(featureChange);
    }

    static {
        GsonBuilder gsonBuilder = new GsonBuilder();
        gsonBuilder.setPrettyPrinting();
        gsonBuilder.disableHtmlEscaping();
        gsonBuilder.registerTypeHierarchyAdapter(FeatureChange.class, new FeatureChangeTypeHierarchyAdapter());
        jsonSerializer = gsonBuilder.create();
    }

    private static class AtlasEntityPropertiesConverter
    implements Converter<AtlasEntity, JsonObject> {
        private static final Function<Map<String, String>, JsonElement> tagPrinter = map -> {
            JsonObject result = new JsonObject();
            map.forEach(result::addProperty);
            return result;
        };
        private static final Function<Iterable<? extends AtlasEntity>, JsonElement> identifierMapper = entity -> {
            JsonArray result = new JsonArray();
            Iterables.stream(entity).map(AtlasObject::getIdentifier).collectToSortedSet().forEach(number -> result.add(new JsonPrimitive((Number)number)));
            return result;
        };

        private AtlasEntityPropertiesConverter() {
        }

        @Override
        public JsonObject convert(AtlasEntity source) {
            JsonObject properties = new JsonObject();
            properties.addProperty("entityType", source.getType().toString());
            properties.addProperty("class", source.getClass().getName());
            properties.addProperty("identifier", source.getIdentifier());
            FeatureChangeGeoJsonSerializer.add(properties, "tags", source.getTags(), AtlasEntityPropertiesConverter.tagPrinter);
            FeatureChangeGeoJsonSerializer.add(properties, "relations", source.relations(), AtlasEntityPropertiesConverter.identifierMapper);
            if (source instanceof Edge) {
                FeatureChangeGeoJsonSerializer.addProperty(properties, "startNode", ((Edge)source).start(), AtlasObject::getIdentifier);
                FeatureChangeGeoJsonSerializer.addProperty(properties, "endNode", ((Edge)source).end(), AtlasObject::getIdentifier);
            } else if (source instanceof Node) {
                FeatureChangeGeoJsonSerializer.add(properties, "inEdges", ((Node)source).inEdges(), AtlasEntityPropertiesConverter.identifierMapper);
                FeatureChangeGeoJsonSerializer.add(properties, "outEdges", ((Node)source).outEdges(), AtlasEntityPropertiesConverter.identifierMapper);
            } else if (source instanceof Relation) {
                Relation relation = (Relation)source;
                FeatureChangeGeoJsonSerializer.add(properties, "members", relation.members(), members -> {
                    JsonArray beanResult = new JsonArray();
                    members.forEach(member -> beanResult.add(new JsonPrimitive(member.toString())));
                    return beanResult;
                });
            }
            return properties;
        }
    }

    private static class AtlasEntityGeometryPrintableConverter
    implements Converter<AtlasEntity, GeometryPrintable> {
        private AtlasEntityGeometryPrintableConverter() {
        }

        @Override
        public GeometryPrintable convert(AtlasEntity source) {
            GeoJsonGeometry result = null;
            result = source instanceof Area ? ((Area)source).asPolygon() : (source instanceof LineItem ? ((LineItem)source).asPolyLine() : (source instanceof LocationItem ? ((LocationItem)source).getLocation() : ((Relation)source).bounds()));
            if (result == null) {
                result = source.bounds();
            }
            return result;
        }
    }

    protected static class FeatureChangeTypeHierarchyAdapter
    implements JsonSerializer<FeatureChange> {
        protected FeatureChangeTypeHierarchyAdapter() {
        }

        private static void addGeometryGeojson(JsonObject result, GeometryPrintable property) {
            FeatureChangeGeoJsonSerializer.add(result, "geometry", property, GeoJson::asGeoJson);
        }

        private static void addGeometryWkt(JsonObject result, GeometryPrintable property) {
            FeatureChangeGeoJsonSerializer.addProperty(result, "WKT", property, WktPrintable::toWkt);
        }

        public JsonElement serialize(FeatureChange source) {
            JsonObject result = new JsonObject();
            result.addProperty("type", "Feature");
            Rectangle bounds = source.bounds();
            result.add("bbox", bounds.asGeoJsonBbox());
            GeometryPrintable geometryPrintable = new AtlasEntityGeometryPrintableConverter().convert(source.getAfterView());
            FeatureChangeTypeHierarchyAdapter.addGeometryGeojson(result, geometryPrintable);
            JsonObject properties = new JsonObject();
            properties.addProperty("featureChangeType", source.getChangeType().toString());
            new AtlasEntityPropertiesConverter().convert(source.getAfterView()).entrySet().forEach(entry -> properties.add((String)entry.getKey(), (JsonElement)entry.getValue()));
            FeatureChangeTypeHierarchyAdapter.addGeometryWkt(properties, geometryPrintable);
            properties.addProperty("bboxWKT", source.bounds().toWkt());
            result.add("properties", properties);
            return result;
        }

        @Override
        public JsonElement serialize(FeatureChange source, Type typeOfSource, JsonSerializationContext context) {
            return this.serialize(source);
        }
    }
}

