/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.change.diff;

import java.util.Iterator;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.geography.atlas.Atlas;
import org.openstreetmap.atlas.geography.atlas.change.ChangeType;
import org.openstreetmap.atlas.geography.atlas.change.FeatureChange;
import org.openstreetmap.atlas.geography.atlas.complete.CompleteArea;
import org.openstreetmap.atlas.geography.atlas.complete.CompleteEdge;
import org.openstreetmap.atlas.geography.atlas.complete.CompleteEntity;
import org.openstreetmap.atlas.geography.atlas.complete.CompleteLine;
import org.openstreetmap.atlas.geography.atlas.complete.CompleteNode;
import org.openstreetmap.atlas.geography.atlas.complete.CompletePoint;
import org.openstreetmap.atlas.geography.atlas.complete.CompleteRelation;
import org.openstreetmap.atlas.geography.atlas.items.Area;
import org.openstreetmap.atlas.geography.atlas.items.AtlasEntity;
import org.openstreetmap.atlas.geography.atlas.items.AtlasObject;
import org.openstreetmap.atlas.geography.atlas.items.Edge;
import org.openstreetmap.atlas.geography.atlas.items.Line;
import org.openstreetmap.atlas.geography.atlas.items.Node;
import org.openstreetmap.atlas.geography.atlas.items.Point;
import org.openstreetmap.atlas.geography.atlas.items.Relation;
import org.openstreetmap.atlas.geography.atlas.items.RelationMemberList;

public final class AtlasDiffHelper {
    public static Optional<FeatureChange> getAreaChangeIfNecessary(Area beforeArea, Area afterArea, Atlas beforeViewAtlas) {
        try {
            boolean featureChangeWouldBeUseful = false;
            CompleteArea completeArea = CompleteArea.shallowFrom(afterArea);
            if (!beforeArea.asPolygon().equals(afterArea.asPolygon())) {
                completeArea.withPolygon(afterArea.asPolygon());
                featureChangeWouldBeUseful = true;
            }
            if (featureChangeWouldBeUseful) {
                return Optional.of(FeatureChange.add(completeArea, beforeViewAtlas));
            }
        }
        catch (Exception exception) {
            throw new CoreException("Unable to compare areas {} and {}", beforeArea, afterArea, exception);
        }
        return Optional.empty();
    }

    public static Optional<FeatureChange> getEdgeChangeIfNecessary(Edge beforeEdge, Edge afterEdge, Atlas beforeViewAtlas, boolean saveAllGeometries) {
        try {
            boolean featureChangeWouldBeUseful = false;
            CompleteEdge completeEdge = CompleteEdge.shallowFrom(afterEdge);
            if (!beforeEdge.asPolyLine().equals(afterEdge.asPolyLine())) {
                completeEdge.withPolyLine(afterEdge.asPolyLine());
                featureChangeWouldBeUseful = true;
            }
            if (beforeEdge.start().getIdentifier() != afterEdge.start().getIdentifier()) {
                completeEdge.withStartNodeIdentifier(afterEdge.start().getIdentifier());
                featureChangeWouldBeUseful = true;
            }
            if (beforeEdge.end().getIdentifier() != afterEdge.end().getIdentifier()) {
                completeEdge.withEndNodeIdentifier(afterEdge.end().getIdentifier());
                featureChangeWouldBeUseful = true;
            }
            if (featureChangeWouldBeUseful) {
                if (saveAllGeometries) {
                    completeEdge.withPolyLine(afterEdge.asPolyLine());
                }
                return Optional.of(FeatureChange.add(completeEdge, beforeViewAtlas));
            }
        }
        catch (Exception exception) {
            throw new CoreException("Unable to compare edges {} and {}", beforeEdge, afterEdge, exception);
        }
        return Optional.empty();
    }

    public static Optional<FeatureChange> getLineChangeIfNecessary(Line beforeLine, Line afterLine, Atlas beforeViewAtlas) {
        try {
            boolean featureChangeWouldBeUseful = false;
            CompleteLine completeLine = CompleteLine.shallowFrom(afterLine);
            if (!beforeLine.asPolyLine().equals(afterLine.asPolyLine())) {
                completeLine.withPolyLine(afterLine.asPolyLine());
                featureChangeWouldBeUseful = true;
            }
            if (featureChangeWouldBeUseful) {
                return Optional.of(FeatureChange.add(completeLine, beforeViewAtlas));
            }
        }
        catch (Exception exception) {
            throw new CoreException("Unable to compare lines {} and {}", beforeLine, afterLine, exception);
        }
        return Optional.empty();
    }

    public static Optional<FeatureChange> getNodeChangeIfNecessary(Node beforeNode, Node afterNode, Atlas beforeViewAtlas, boolean saveAllGeometries) {
        try {
            boolean featureChangeWouldBeUseful = false;
            CompleteNode completeNode = CompleteNode.shallowFrom(afterNode);
            if (!beforeNode.getLocation().equals(afterNode.getLocation())) {
                completeNode.withLocation(afterNode.getLocation());
                featureChangeWouldBeUseful = true;
            }
            if (AtlasDiffHelper.differentEdgeSet(beforeNode.inEdges(), afterNode.inEdges())) {
                completeNode.withInEdgeIdentifiers(new TreeSet<Long>(afterNode.inEdges().stream().map(AtlasObject::getIdentifier).collect(Collectors.toSet())));
                if (saveAllGeometries) {
                    completeNode.withLocation(afterNode.getLocation());
                }
                featureChangeWouldBeUseful = true;
            }
            if (AtlasDiffHelper.differentEdgeSet(beforeNode.outEdges(), afterNode.outEdges())) {
                completeNode.withOutEdgeIdentifiers(new TreeSet<Long>(afterNode.outEdges().stream().map(AtlasObject::getIdentifier).collect(Collectors.toSet())));
                if (saveAllGeometries) {
                    completeNode.withLocation(afterNode.getLocation());
                }
                featureChangeWouldBeUseful = true;
            }
            if (featureChangeWouldBeUseful) {
                return Optional.of(FeatureChange.add(completeNode, beforeViewAtlas));
            }
        }
        catch (Exception exception) {
            throw new CoreException("Unable to compare nodes {} and {}", beforeNode, afterNode, exception);
        }
        return Optional.empty();
    }

    public static Optional<FeatureChange> getParentRelationMembershipChangeIfNecessary(AtlasEntity beforeEntity, AtlasEntity afterEntity, Atlas beforeViewAtlas, boolean saveAllGeometries) {
        try {
            CompleteEntity completeEntity;
            Set beforeRelationIdentifiers = beforeEntity.relations().stream().map(AtlasObject::getIdentifier).collect(Collectors.toSet());
            Set afterRelationIdentifiers = afterEntity.relations().stream().map(AtlasObject::getIdentifier).collect(Collectors.toSet());
            if (beforeRelationIdentifiers.isEmpty() && afterRelationIdentifiers.isEmpty()) {
                return Optional.empty();
            }
            if (beforeRelationIdentifiers.equals(afterRelationIdentifiers)) {
                return Optional.empty();
            }
            switch (afterEntity.getType()) {
                case AREA: {
                    CompleteEntity area = CompleteArea.shallowFrom((Area)afterEntity).withRelationIdentifiers(afterRelationIdentifiers);
                    if (saveAllGeometries) {
                        area = ((CompleteArea)area).withPolygon(((Area)afterEntity).asPolygon());
                    }
                    completeEntity = area;
                    break;
                }
                case EDGE: {
                    CompleteEntity edge = CompleteEdge.shallowFrom((Edge)afterEntity).withRelationIdentifiers(afterRelationIdentifiers);
                    if (saveAllGeometries) {
                        edge = ((CompleteEdge)edge).withPolyLine(((Edge)afterEntity).asPolyLine());
                    }
                    completeEntity = edge;
                    break;
                }
                case LINE: {
                    CompleteEntity line = CompleteLine.shallowFrom((Line)afterEntity).withRelationIdentifiers(afterRelationIdentifiers);
                    if (saveAllGeometries) {
                        line = ((CompleteLine)line).withPolyLine(((Line)afterEntity).asPolyLine());
                    }
                    completeEntity = line;
                    break;
                }
                case NODE: {
                    CompleteEntity node = CompleteNode.shallowFrom((Node)afterEntity).withRelationIdentifiers(afterRelationIdentifiers);
                    if (saveAllGeometries) {
                        node = ((CompleteNode)node).withLocation(((Node)afterEntity).getLocation());
                    }
                    completeEntity = node;
                    break;
                }
                case POINT: {
                    CompleteEntity point = CompletePoint.shallowFrom((Point)afterEntity).withRelationIdentifiers(afterRelationIdentifiers);
                    if (saveAllGeometries) {
                        point = ((CompletePoint)point).withLocation(((Point)afterEntity).getLocation());
                    }
                    completeEntity = point;
                    break;
                }
                case RELATION: {
                    CompleteEntity relation;
                    completeEntity = relation = CompleteRelation.shallowFrom((Relation)afterEntity).withRelationIdentifiers(afterRelationIdentifiers);
                    break;
                }
                default: {
                    throw new CoreException("Unknown item type {}", new Object[]{afterEntity.getType()});
                }
            }
            return Optional.of(FeatureChange.add((AtlasEntity)((Object)completeEntity), beforeViewAtlas));
        }
        catch (Exception exception) {
            throw new CoreException("Unable to compare relations for {} and {}", beforeEntity, afterEntity, exception);
        }
    }

    public static Optional<FeatureChange> getPointChangeIfNecessary(Point beforePoint, Point afterPoint, Atlas beforeViewAtlas) {
        try {
            boolean featureChangeWouldBeUseful = false;
            CompletePoint completePoint = CompletePoint.shallowFrom(afterPoint);
            if (!beforePoint.getLocation().equals(afterPoint.getLocation())) {
                completePoint.withLocation(afterPoint.getLocation());
                featureChangeWouldBeUseful = true;
            }
            if (featureChangeWouldBeUseful) {
                return Optional.of(FeatureChange.add(completePoint, beforeViewAtlas));
            }
        }
        catch (Exception exception) {
            throw new CoreException("Unable to compare points {} and {}", beforePoint, afterPoint, exception);
        }
        return Optional.empty();
    }

    public static Optional<FeatureChange> getRelationChangeIfNecessary(Relation beforeRelation, Relation afterRelation, Atlas beforeViewAtlas) {
        try {
            boolean featureChangeWouldBeUseful = false;
            CompleteRelation completeRelation = CompleteRelation.shallowFrom(afterRelation);
            RelationMemberList beforeMembers = beforeRelation.members();
            RelationMemberList afterMembers = afterRelation.members();
            if (!afterMembers.equals(beforeMembers)) {
                completeRelation.withMembersAndSource(afterRelation.members(), beforeRelation);
                featureChangeWouldBeUseful = true;
            }
            if (featureChangeWouldBeUseful) {
                return Optional.of(FeatureChange.add(completeRelation, beforeViewAtlas));
            }
        }
        catch (Exception exception) {
            throw new CoreException("Unable to compare relations {} and {}", beforeRelation, afterRelation, exception);
        }
        return Optional.empty();
    }

    public static Optional<FeatureChange> getTagChangeIfNecessary(AtlasEntity beforeEntity, AtlasEntity afterEntity, Atlas beforeViewAtlas, boolean saveAllGeometries) {
        AtlasEntity completeEntity;
        if (beforeEntity.getTags().equals(afterEntity.getTags())) {
            return Optional.empty();
        }
        switch (afterEntity.getType()) {
            case AREA: {
                CompleteArea area = (CompleteArea)CompleteArea.shallowFrom((Area)afterEntity).withTags(afterEntity.getTags());
                if (saveAllGeometries) {
                    area = area.withPolygon(((Area)afterEntity).asPolygon());
                }
                completeEntity = area;
                break;
            }
            case EDGE: {
                CompleteEdge edge = (CompleteEdge)CompleteEdge.shallowFrom((Edge)afterEntity).withTags(afterEntity.getTags());
                if (saveAllGeometries) {
                    edge = edge.withPolyLine(((Edge)afterEntity).asPolyLine());
                }
                completeEntity = edge;
                break;
            }
            case LINE: {
                CompleteLine line = (CompleteLine)CompleteLine.shallowFrom((Line)afterEntity).withTags(afterEntity.getTags());
                if (saveAllGeometries) {
                    line = line.withPolyLine(((Line)afterEntity).asPolyLine());
                }
                completeEntity = line;
                break;
            }
            case NODE: {
                CompleteNode node = (CompleteNode)CompleteNode.shallowFrom((Node)afterEntity).withTags(afterEntity.getTags());
                if (saveAllGeometries) {
                    node = node.withLocation(((Node)afterEntity).getLocation());
                }
                completeEntity = node;
                break;
            }
            case POINT: {
                CompletePoint point = (CompletePoint)CompletePoint.shallowFrom((Point)afterEntity).withTags(afterEntity.getTags());
                if (saveAllGeometries) {
                    point = point.withLocation(((Point)afterEntity).getLocation());
                }
                completeEntity = point;
                break;
            }
            case RELATION: {
                CompleteRelation relation;
                completeEntity = relation = (CompleteRelation)CompleteRelation.shallowFrom((Relation)afterEntity).withTags(afterEntity.getTags());
                break;
            }
            default: {
                throw new CoreException("Unknown item type {}", new Object[]{afterEntity.getType()});
            }
        }
        return Optional.of(FeatureChange.add(completeEntity, beforeViewAtlas));
    }

    public static FeatureChange simpleCompleteAreaChange(ChangeType changeType, Atlas atlasContainingTheEntity, Atlas beforeViewAtlas, AtlasEntity entity, boolean saveAllGeometries) {
        Long entityIdentifier = entity.getIdentifier();
        if (changeType == ChangeType.REMOVE) {
            CompleteArea completeArea = CompleteArea.shallowFrom(atlasContainingTheEntity.area(entityIdentifier));
            if (saveAllGeometries) {
                completeArea = completeArea.withPolygon(((Area)entity).asPolygon());
            }
            return FeatureChange.remove(completeArea, beforeViewAtlas);
        }
        return FeatureChange.add(CompleteArea.from(atlasContainingTheEntity.area(entityIdentifier)), beforeViewAtlas);
    }

    public static FeatureChange simpleCompleteEdgeChange(ChangeType changeType, Atlas atlasContainingTheEntity, Atlas beforeViewAtlas, AtlasEntity entity, boolean saveAllGeometries) {
        Long entityIdentifier = entity.getIdentifier();
        if (changeType == ChangeType.REMOVE) {
            CompleteEdge completeEdge = CompleteEdge.shallowFrom(atlasContainingTheEntity.edge(entityIdentifier));
            if (saveAllGeometries) {
                completeEdge = completeEdge.withPolyLine(((Edge)entity).asPolyLine());
            }
            return FeatureChange.remove(completeEdge, beforeViewAtlas);
        }
        return FeatureChange.add(CompleteEdge.from(atlasContainingTheEntity.edge(entityIdentifier)), beforeViewAtlas);
    }

    public static FeatureChange simpleCompleteLineChange(ChangeType changeType, Atlas atlasContainingTheEntity, Atlas beforeViewAtlas, AtlasEntity entity, boolean saveAllGeometries) {
        Long entityIdentifier = entity.getIdentifier();
        if (changeType == ChangeType.REMOVE) {
            CompleteLine completeLine = CompleteLine.shallowFrom(atlasContainingTheEntity.line(entityIdentifier));
            if (saveAllGeometries) {
                completeLine = completeLine.withPolyLine(((Line)entity).asPolyLine());
            }
            return FeatureChange.remove(completeLine, beforeViewAtlas);
        }
        return FeatureChange.add(CompleteLine.from(atlasContainingTheEntity.line(entityIdentifier)), beforeViewAtlas);
    }

    public static FeatureChange simpleCompleteNodeChange(ChangeType changeType, Atlas atlasContainingTheEntity, Atlas beforeViewAtlas, AtlasEntity entity, boolean saveAllGeometries) {
        Long entityIdentifier = entity.getIdentifier();
        if (changeType == ChangeType.REMOVE) {
            CompleteNode completeNode = CompleteNode.shallowFrom(atlasContainingTheEntity.node(entityIdentifier));
            if (saveAllGeometries) {
                completeNode = completeNode.withLocation(((Node)entity).getLocation());
            }
            return FeatureChange.remove(completeNode, beforeViewAtlas);
        }
        return FeatureChange.add(CompleteNode.from(atlasContainingTheEntity.node(entityIdentifier)), beforeViewAtlas);
    }

    public static FeatureChange simpleCompletePointChange(ChangeType changeType, Atlas atlasContainingTheEntity, Atlas beforeViewAtlas, AtlasEntity entity, boolean saveAllGeometries) {
        Long entityIdentifier = entity.getIdentifier();
        if (changeType == ChangeType.REMOVE) {
            CompletePoint completePoint = CompletePoint.shallowFrom(atlasContainingTheEntity.point(entityIdentifier));
            if (saveAllGeometries) {
                completePoint = completePoint.withLocation(((Point)entity).getLocation());
            }
            return FeatureChange.remove(completePoint, beforeViewAtlas);
        }
        return FeatureChange.add(CompletePoint.from(atlasContainingTheEntity.point(entityIdentifier)), beforeViewAtlas);
    }

    public static FeatureChange simpleCompleteRelationChange(ChangeType changeType, Atlas atlasContainingTheEntity, Atlas beforeViewAtlas, AtlasEntity entity) {
        Long entityIdentifier = entity.getIdentifier();
        if (changeType == ChangeType.REMOVE) {
            CompleteRelation completeRelation = CompleteRelation.shallowFrom(atlasContainingTheEntity.relation(entityIdentifier));
            return FeatureChange.remove(completeRelation, beforeViewAtlas);
        }
        return FeatureChange.add(CompleteRelation.from(atlasContainingTheEntity.relation(entityIdentifier)), beforeViewAtlas);
    }

    private static boolean differentEdgeSet(SortedSet<Edge> beforeEdges, SortedSet<Edge> afterEdges) {
        if (beforeEdges.size() != afterEdges.size()) {
            return true;
        }
        Iterator beforeInEdgeIterator = beforeEdges.iterator();
        Iterator afterInEdgeIterator = afterEdges.iterator();
        for (int i = 0; i < beforeEdges.size(); ++i) {
            Edge beforeInEdge = (Edge)beforeInEdgeIterator.next();
            Edge afterInEdge = (Edge)afterInEdgeIterator.next();
            if (beforeInEdge.getIdentifier() == afterInEdge.getIdentifier()) continue;
            return true;
        }
        return false;
    }

    private AtlasDiffHelper() {
    }
}

