/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.change;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.BinaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.geography.Location;
import org.openstreetmap.atlas.geography.PolyLine;
import org.openstreetmap.atlas.geography.Polygon;
import org.openstreetmap.atlas.geography.atlas.builder.RelationBean;
import org.openstreetmap.atlas.utilities.collections.Maps;
import org.openstreetmap.atlas.utilities.function.TernaryOperator;

public final class MemberMergeStrategies {
    static final BinaryOperator<Map<String, String>> simpleTagMerger = (xva$0, xva$1) -> Maps.withMaps(xva$0, xva$1);
    static final BinaryOperator<Set<Long>> simpleLongSetMerger = (xva$0, xva$1) -> org.openstreetmap.atlas.utilities.collections.Sets.withSets(xva$0, xva$1);
    static final BinaryOperator<Set<Long>> simpleLongSetAllowCollisionsMerger = (left, right) -> org.openstreetmap.atlas.utilities.collections.Sets.withSets(false, left, right);
    static final BinaryOperator<SortedSet<Long>> simpleLongSortedSetMerger = (xva$0, xva$1) -> org.openstreetmap.atlas.utilities.collections.Sets.withSortedSets(xva$0, xva$1);
    static final BinaryOperator<SortedSet<Long>> simpleLongSortedSetAllowCollisionsMerger = (left, right) -> org.openstreetmap.atlas.utilities.collections.Sets.withSortedSets(false, left, right);
    static final BinaryOperator<RelationBean> simpleRelationBeanMerger = RelationBean::merge;
    static final TernaryOperator<Long> diffBasedLongMerger = (beforeLong, afterLongLeft, afterLongRight) -> (Long)MemberMergeStrategies.getDiffBasedMutuallyExclusiveMerger().apply(beforeLong, (Long)afterLongLeft, afterLongRight);
    static final TernaryOperator<Location> diffBasedLocationMerger = (beforeLocation, afterLocationLeft, afterLocationRight) -> (Location)MemberMergeStrategies.getDiffBasedMutuallyExclusiveMerger().apply(beforeLocation, (Location)afterLocationLeft, afterLocationRight);
    static final TernaryOperator<PolyLine> diffBasedPolyLineMerger = (beforePolyLine, afterPolyLineLeft, afterPolyLineRight) -> (PolyLine)MemberMergeStrategies.getDiffBasedMutuallyExclusiveMerger().apply(beforePolyLine, (PolyLine)afterPolyLineLeft, afterPolyLineRight);
    static final TernaryOperator<Polygon> diffBasedPolygonMerger = (beforePolygon, afterPolygonLeft, afterPolygonRight) -> (Polygon)MemberMergeStrategies.getDiffBasedMutuallyExclusiveMerger().apply(beforePolygon, (Polygon)afterPolygonLeft, afterPolygonRight);
    static final TernaryOperator<RelationBean> diffBasedRelationBeanMerger = (beforeBean, afterLeftBean, afterRightBean) -> {
        Integer newValue;
        Integer beforeValue;
        Map<RelationBean.RelationBeanItem, Integer> beforeBeanMap = beforeBean.asMap();
        Map<RelationBean.RelationBeanItem, Integer> afterLeftBeanMap = afterLeftBean.asMap();
        Map<RelationBean.RelationBeanItem, Integer> afterRightBeanMap = afterRightBean.asMap();
        Map<RelationBean.RelationBeanItem, Integer> removedFromLeftView = MemberMergeStrategies.computeMapDifferenceCounts(beforeBeanMap, afterLeftBeanMap).entrySet().stream().filter(entry -> (Integer)entry.getValue() > 0).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        Map<RelationBean.RelationBeanItem, Integer> removedFromRightView = MemberMergeStrategies.computeMapDifferenceCounts(beforeBeanMap, afterRightBeanMap).entrySet().stream().filter(entry -> (Integer)entry.getValue() > 0).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        Map<RelationBean.RelationBeanItem, Integer> addedToLeftView = MemberMergeStrategies.computeMapDifferenceCounts(afterLeftBeanMap, beforeBeanMap).entrySet().stream().filter(entry -> (Integer)entry.getValue() > 0).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        Map<RelationBean.RelationBeanItem, Integer> addedToRightView = MemberMergeStrategies.computeMapDifferenceCounts(afterRightBeanMap, beforeBeanMap).entrySet().stream().filter(entry -> (Integer)entry.getValue() > 0).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        for (Map.Entry<RelationBean.RelationBeanItem, Integer> removedFromLeftEntry : removedFromLeftView.entrySet()) {
            RelationBean.RelationBeanItem leftKey = removedFromLeftEntry.getKey();
            Integer n = removedFromLeftEntry.getValue();
            Integer rightValue = removedFromRightView.get(leftKey);
            if (rightValue == null || n.equals(rightValue)) continue;
            throw new CoreException("diffBasedRelationBeanMerger failed due to REMOVE/REMOVE conflict on key: [{}]: beforeValue absolute count was {} but removedLeft/Right diff counts conflict [{} vs {}]", leftKey, beforeBeanMap.get(leftKey), n, rightValue);
        }
        Sets.SetView<RelationBean.RelationBeanItem> addedLeftRemovedRightConflicts = Sets.intersection(addedToLeftView.keySet(), removedFromRightView.keySet());
        if (!addedLeftRemovedRightConflicts.isEmpty()) {
            throw new CoreException("diffBasedRelationBeanMerger failed due to ADD/REMOVE conflict(s) on key(s): {}", addedLeftRemovedRightConflicts);
        }
        Sets.SetView<RelationBean.RelationBeanItem> addedRightRemovedLeftConflicts = Sets.intersection(addedToRightView.keySet(), removedFromLeftView.keySet());
        if (!addedRightRemovedLeftConflicts.isEmpty()) {
            throw new CoreException("diffBasedRelationBeanMerger failed due to ADD/REMOVE conflict(s) on key(s): {}", addedRightRemovedLeftConflicts);
        }
        for (Map.Entry entry2 : addedToLeftView.entrySet()) {
            RelationBean.RelationBeanItem leftKey = (RelationBean.RelationBeanItem)entry2.getKey();
            Iterator leftValue = (Integer)entry2.getValue();
            Integer n = addedToRightView.get(leftKey);
            if (n == null || ((Integer)((Object)leftValue)).equals(n)) continue;
            throw new CoreException("diffBasedRelationBeanMerger failed due to ADD/ADD conflict on key: [{}]: beforeValue absolute count was {} but addedLeft/Right diff counts conflict [{} vs {}]", leftKey, beforeBeanMap.get(leftKey) != null ? beforeBeanMap.get(leftKey) : 0, leftValue, n);
        }
        HashMap removedMergedView = new HashMap();
        removedFromLeftView.entrySet().stream().forEach(entry -> removedMergedView.put((RelationBean.RelationBeanItem)entry.getKey(), (Integer)entry.getValue()));
        removedFromRightView.entrySet().stream().forEach(entry -> removedMergedView.put((RelationBean.RelationBeanItem)entry.getKey(), (Integer)entry.getValue()));
        HashMap hashMap = new HashMap();
        addedToLeftView.entrySet().stream().forEach(entry -> addedMergedView.put((RelationBean.RelationBeanItem)entry.getKey(), (Integer)entry.getValue()));
        addedToRightView.entrySet().stream().forEach(entry -> addedMergedView.put((RelationBean.RelationBeanItem)entry.getKey(), (Integer)entry.getValue()));
        HashMap<RelationBean.RelationBeanItem, Integer> resultMap = new HashMap<RelationBean.RelationBeanItem, Integer>(beforeBeanMap);
        for (Map.Entry entry3 : removedMergedView.entrySet()) {
            RelationBean.RelationBeanItem removedKey = (RelationBean.RelationBeanItem)entry3.getKey();
            Integer removedCount = (Integer)entry3.getValue();
            beforeValue = beforeBeanMap.get(removedKey);
            newValue = beforeValue - removedCount;
            resultMap.put(removedKey, newValue);
        }
        for (Map.Entry entry4 : hashMap.entrySet()) {
            RelationBean.RelationBeanItem addedKey = (RelationBean.RelationBeanItem)entry4.getKey();
            Integer addedCount = (Integer)entry4.getValue();
            beforeValue = beforeBeanMap.get(addedKey);
            newValue = beforeValue == null ? Integer.valueOf(0 + addedCount) : Integer.valueOf(beforeValue + addedCount);
            resultMap.put(addedKey, newValue);
        }
        RelationBean resultBean = new RelationBean();
        for (Map.Entry resultEntry : resultMap.entrySet()) {
            RelationBean.RelationBeanItem resultKey = (RelationBean.RelationBeanItem)resultEntry.getKey();
            Integer resultCount = (Integer)resultEntry.getValue();
            for (int count = 0; count < resultCount; ++count) {
                resultBean.addItem(resultKey);
            }
        }
        Stream.concat(afterLeftBean.getExplicitlyExcluded().stream(), afterRightBean.getExplicitlyExcluded().stream()).forEach(resultBean::addItemExplicitlyExcluded);
        return resultBean;
    };
    static final TernaryOperator<Set<Long>> diffBasedLongSetMerger = (beforeSet, afterLeftSet, afterRightSet) -> {
        Sets.SetView removedFromLeftView = Sets.difference(beforeSet, afterLeftSet);
        Sets.SetView removedFromRightView = Sets.difference(beforeSet, afterRightSet);
        Sets.SetView addedToLeftView = Sets.difference(afterLeftSet, beforeSet);
        Sets.SetView addedToRightView = Sets.difference(afterRightSet, beforeSet);
        Set removedMerged = org.openstreetmap.atlas.utilities.collections.Sets.withSets(false, removedFromLeftView, removedFromRightView);
        Set addedMerged = org.openstreetmap.atlas.utilities.collections.Sets.withSets(false, addedToLeftView, addedToRightView);
        HashSet result = new HashSet(beforeSet);
        result.removeAll(removedMerged);
        result.addAll(addedMerged);
        return result;
    };
    static final TernaryOperator<SortedSet<Long>> diffBasedLongSortedSetMerger = (beforeSet, afterLeftSet, afterRightSet) -> new TreeSet((Collection)diffBasedLongSetMerger.apply(beforeSet, (Set<Long>)afterLeftSet, afterRightSet));
    static final TernaryOperator<Map<String, String>> diffBasedTagMerger = (beforeMap, afterLeftMap, afterRightMap) -> {
        Sets.SetView keysRemovedFromLeftView = Sets.difference(beforeMap.keySet(), afterLeftMap.keySet());
        Sets.SetView keysRemovedFromRightView = Sets.difference(beforeMap.keySet(), afterRightMap.keySet());
        Map<String, String> addedToLeftView = Sets.difference(afterLeftMap.entrySet(), beforeMap.entrySet()).stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        Map<String, String> addedToRightView = Sets.difference(afterRightMap.entrySet(), beforeMap.entrySet()).stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        Sets.SetView<String> sharedAddedKeys = Sets.intersection(addedToLeftView.keySet(), addedToRightView.keySet());
        for (String sharedKey : sharedAddedKeys) {
            String rightValue;
            String leftValue = addedToLeftView.get(sharedKey);
            if (Objects.equals(leftValue, rightValue = addedToRightView.get(sharedKey))) continue;
            throw new CoreException("diffBasedTagMerger failed due to ADD/ADD conflict on keys: [{} -> {}] vs [{} -> {}]", sharedKey, leftValue, sharedKey, rightValue);
        }
        Set keysRemovedMerged = org.openstreetmap.atlas.utilities.collections.Sets.withSets(false, keysRemovedFromLeftView, keysRemovedFromRightView);
        Set keysAddedMerged = org.openstreetmap.atlas.utilities.collections.Sets.withSets(false, addedToLeftView.keySet(), addedToRightView.keySet());
        Sets.SetView collision = Sets.intersection(keysRemovedMerged, keysAddedMerged);
        if (!collision.isEmpty()) {
            throw new CoreException("diffBasedTagMerger failed due to ADD/REMOVE conflict(s) on key(s): {}", collision);
        }
        HashMap result = new HashMap(beforeMap);
        keysRemovedMerged.forEach(result::remove);
        keysAddedMerged.forEach(key -> {
            String value = (String)addedToLeftView.get(key);
            if (value == null) {
                value = (String)addedToRightView.get(key);
            }
            result.put(key, value);
        });
        return result;
    };

    private static <T> Map<T, Integer> computeMapDifferenceCounts(Map<T, Integer> before, Map<T, Integer> after) {
        HashMap<T, Integer> result = new HashMap<T, Integer>();
        for (Map.Entry<T, Integer> beforeEntry : before.entrySet()) {
            T beforeKey = beforeEntry.getKey();
            Integer beforeCount = beforeEntry.getValue();
            Integer afterCount = after.get(beforeKey);
            if (afterCount != null) {
                result.put(beforeKey, beforeCount - afterCount);
                continue;
            }
            result.put(beforeKey, beforeCount);
        }
        return result;
    }

    private static <T> TernaryOperator<T> getDiffBasedMutuallyExclusiveMerger() {
        return (beforeView, afterViewLeft, afterViewRight) -> {
            if (afterViewLeft.equals(afterViewRight)) {
                return afterViewLeft;
            }
            if (afterViewLeft.equals(beforeView)) {
                return afterViewRight;
            }
            if (afterViewRight.equals(beforeView)) {
                return afterViewLeft;
            }
            throw new CoreException("diffBasedMutuallyExclusiveMerger failed due to ADD/ADD conflict: beforeView was {} but afterViews were [{} vs {}]", beforeView, afterViewLeft, afterViewRight);
        };
    }

    private MemberMergeStrategies() {
    }
}

