/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.change;

import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.geography.Location;
import org.openstreetmap.atlas.geography.PolyLine;
import org.openstreetmap.atlas.geography.Polygon;
import org.openstreetmap.atlas.geography.Rectangle;
import org.openstreetmap.atlas.geography.atlas.builder.RelationBean;
import org.openstreetmap.atlas.geography.atlas.change.ChangeType;
import org.openstreetmap.atlas.geography.atlas.change.FeatureChange;
import org.openstreetmap.atlas.geography.atlas.change.MemberMergeStrategies;
import org.openstreetmap.atlas.geography.atlas.change.MergedMemberBean;
import org.openstreetmap.atlas.geography.atlas.complete.CompleteArea;
import org.openstreetmap.atlas.geography.atlas.complete.CompleteEdge;
import org.openstreetmap.atlas.geography.atlas.complete.CompleteEntity;
import org.openstreetmap.atlas.geography.atlas.complete.CompleteLine;
import org.openstreetmap.atlas.geography.atlas.complete.CompleteNode;
import org.openstreetmap.atlas.geography.atlas.complete.CompletePoint;
import org.openstreetmap.atlas.geography.atlas.complete.CompleteRelation;
import org.openstreetmap.atlas.geography.atlas.items.Area;
import org.openstreetmap.atlas.geography.atlas.items.AtlasEntity;
import org.openstreetmap.atlas.geography.atlas.items.AtlasObject;
import org.openstreetmap.atlas.geography.atlas.items.Edge;
import org.openstreetmap.atlas.geography.atlas.items.Line;
import org.openstreetmap.atlas.geography.atlas.items.LineItem;
import org.openstreetmap.atlas.geography.atlas.items.LocationItem;
import org.openstreetmap.atlas.geography.atlas.items.Node;
import org.openstreetmap.atlas.geography.atlas.items.Point;
import org.openstreetmap.atlas.geography.atlas.items.Relation;
import org.openstreetmap.atlas.tags.Taggable;
import org.openstreetmap.atlas.utilities.function.TernaryOperator;

public final class FeatureChangeMergingHelpers {
    private static final String AFTER_ENTITY_RIGHT_WAS_NULL = "afterEntityRight was null, this should never happen!";
    private static final String AFTER_ENTITY_LEFT_WAS_NULL = "afterEntityLeft was null, this should never happen!";

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static <M> MergedMemberBean<M> mergeMember(String memberName, AtlasEntity beforeEntityLeft, AtlasEntity afterEntityLeft, AtlasEntity beforeEntityRight, AtlasEntity afterEntityRight, Function<AtlasEntity, M> memberExtractor, BinaryOperator<M> simpleMergeStrategy, TernaryOperator<M> diffBasedMergeStrategy) {
        Object afterMemberResult;
        Object afterMemberRight;
        Object beforeMemberLeft = beforeEntityLeft == null ? null : (Object)memberExtractor.apply(beforeEntityLeft);
        Object afterMemberLeft = afterEntityLeft == null ? null : (Object)memberExtractor.apply(afterEntityLeft);
        Object beforeMemberRight = beforeEntityRight == null ? null : memberExtractor.apply(beforeEntityRight);
        Object u = afterMemberRight = afterEntityRight == null ? null : (Object)memberExtractor.apply(afterEntityRight);
        if (beforeMemberLeft != null && beforeMemberRight != null && !beforeMemberLeft.equals(beforeMemberRight)) {
            throw new CoreException("Attempted merged failed for {}: beforeMembers did not match: {} vs {}", memberName, beforeMemberLeft, beforeMemberRight);
        }
        Object beforeMemberResult = beforeMemberLeft != null && beforeMemberRight != null ? beforeMemberLeft : (beforeMemberLeft != null ? beforeMemberLeft : (beforeMemberRight != null ? beforeMemberRight : null));
        if (afterMemberLeft != null && afterMemberRight != null) {
            if (afterMemberLeft.equals(afterMemberRight)) {
                afterMemberResult = afterMemberLeft;
                return new MergedMemberBean<Object>(beforeMemberResult, afterMemberResult);
            } else if (beforeMemberLeft != null && beforeMemberRight != null && diffBasedMergeStrategy != null) {
                try {
                    afterMemberResult = diffBasedMergeStrategy.apply(beforeMemberLeft, afterMemberLeft, afterMemberRight);
                    return new MergedMemberBean<Object>(beforeMemberResult, afterMemberResult);
                }
                catch (Exception exception) {
                    throw new CoreException("Attempted merge failed for {} with beforeView: {}; afterView: {} vs {}", memberName, beforeMemberLeft, afterMemberLeft, afterMemberRight, exception);
                }
            } else {
                if (simpleMergeStrategy == null) throw new CoreException("Conflicting members and no simple merge strategy for {}; afterView: {} vs {}", memberName, afterMemberLeft, afterMemberRight);
                try {
                    afterMemberResult = simpleMergeStrategy.apply(afterMemberLeft, afterMemberRight);
                    return new MergedMemberBean<Object>(beforeMemberResult, afterMemberResult);
                }
                catch (CoreException exception) {
                    throw new CoreException("Attempted merge failed for {}: {} and {}", memberName, afterMemberLeft, afterMemberRight, exception);
                }
            }
        } else {
            afterMemberResult = afterMemberLeft != null ? afterMemberLeft : (afterMemberRight != null ? afterMemberRight : null);
        }
        return new MergedMemberBean<Object>(beforeMemberResult, afterMemberResult);
    }

    public static FeatureChange mergeADDFeatureChangePair(FeatureChange left, FeatureChange right) {
        AtlasEntity beforeEntityLeft = left.getBeforeView();
        AtlasEntity afterEntityLeft = left.getAfterView();
        AtlasEntity beforeEntityRight = right.getBeforeView();
        AtlasEntity afterEntityRight = right.getAfterView();
        if (afterEntityLeft == null) {
            throw new CoreException(AFTER_ENTITY_LEFT_WAS_NULL);
        }
        if (afterEntityRight == null) {
            throw new CoreException(AFTER_ENTITY_RIGHT_WAS_NULL);
        }
        MergedMemberBean<Map<String, String>> mergedTagsBean = FeatureChangeMergingHelpers.mergeMember("tags", beforeEntityLeft, afterEntityLeft, beforeEntityRight, afterEntityRight, Taggable::getTags, MemberMergeStrategies.simpleTagMerger, MemberMergeStrategies.diffBasedTagMerger);
        MergedMemberBean<Set<Long>> mergedParentRelationsBean = FeatureChangeMergingHelpers.mergeMember("parentRelations", beforeEntityLeft, afterEntityLeft, beforeEntityRight, afterEntityRight, atlasEntity -> atlasEntity.relations() == null ? null : atlasEntity.relations().stream().map(AtlasObject::getIdentifier).collect(Collectors.toSet()), MemberMergeStrategies.simpleLongSetAllowCollisionsMerger, MemberMergeStrategies.diffBasedLongSetMerger);
        if (afterEntityLeft instanceof LocationItem) {
            return FeatureChangeMergingHelpers.mergeLocationItems(left, right, mergedTagsBean, mergedParentRelationsBean);
        }
        if (afterEntityLeft instanceof LineItem) {
            return FeatureChangeMergingHelpers.mergeLineItems(left, right, mergedTagsBean, mergedParentRelationsBean);
        }
        if (afterEntityLeft instanceof Area) {
            return FeatureChangeMergingHelpers.mergeAreas(left, right, mergedTagsBean, mergedParentRelationsBean);
        }
        if (afterEntityLeft instanceof Relation) {
            return FeatureChangeMergingHelpers.mergeRelations(left, right, mergedTagsBean, mergedParentRelationsBean);
        }
        throw new CoreException("Unknown AtlasEntity subtype {}", afterEntityLeft.getClass().getName());
    }

    private static FeatureChange mergeAreas(FeatureChange left, FeatureChange right, MergedMemberBean<Map<String, String>> mergedTagsBean, MergedMemberBean<Set<Long>> mergedParentRelationsBean) {
        AtlasEntity beforeEntityLeft = left.getBeforeView();
        AtlasEntity afterEntityLeft = left.getAfterView();
        AtlasEntity beforeEntityRight = right.getBeforeView();
        AtlasEntity afterEntityRight = right.getAfterView();
        if (afterEntityLeft == null) {
            throw new CoreException(AFTER_ENTITY_LEFT_WAS_NULL);
        }
        if (afterEntityRight == null) {
            throw new CoreException(AFTER_ENTITY_RIGHT_WAS_NULL);
        }
        MergedMemberBean<Polygon> mergedPolygonBean = FeatureChangeMergingHelpers.mergeMember("polygon", beforeEntityLeft, afterEntityLeft, beforeEntityRight, afterEntityRight, atlasEntity -> ((Area)atlasEntity).asPolygon(), null, MemberMergeStrategies.diffBasedPolygonMerger);
        CompleteArea mergedAfterArea = new CompleteArea(left.getIdentifier(), mergedPolygonBean.getMergedAfterMember(), mergedTagsBean.getMergedAfterMember(), mergedParentRelationsBean.getMergedAfterMember());
        mergedAfterArea.withBoundsExtendedBy(afterEntityLeft.bounds());
        mergedAfterArea.withBoundsExtendedBy(afterEntityRight.bounds());
        CompleteEntity mergedBeforeArea = beforeEntityLeft != null ? ((CompleteArea)CompleteArea.shallowFrom((Area)beforeEntityLeft).withTags(mergedTagsBean.getMergedBeforeMember())).withRelationIdentifiers((Set)mergedParentRelationsBean.getMergedBeforeMember()) : null;
        return new FeatureChange(ChangeType.ADD, mergedAfterArea, (AtlasEntity)((Object)mergedBeforeArea));
    }

    private static FeatureChange mergeEdges(FeatureChange left, FeatureChange right, MergedMemberBean<PolyLine> mergedPolyLineBean, MergedMemberBean<Map<String, String>> mergedTagsBean, MergedMemberBean<Set<Long>> mergedParentRelationsBean) {
        AtlasEntity beforeEntityLeft = left.getBeforeView();
        AtlasEntity afterEntityLeft = left.getAfterView();
        AtlasEntity beforeEntityRight = right.getBeforeView();
        AtlasEntity afterEntityRight = right.getAfterView();
        if (afterEntityLeft == null) {
            throw new CoreException(AFTER_ENTITY_LEFT_WAS_NULL);
        }
        if (afterEntityRight == null) {
            throw new CoreException(AFTER_ENTITY_RIGHT_WAS_NULL);
        }
        MergedMemberBean<Long> mergedStartNodeIdentifierBean = FeatureChangeMergingHelpers.mergeMember("startNode", beforeEntityLeft, afterEntityLeft, beforeEntityRight, afterEntityRight, edge -> ((Edge)edge).start() == null ? null : Long.valueOf(((Edge)edge).start().getIdentifier()), null, MemberMergeStrategies.diffBasedLongMerger);
        MergedMemberBean<Long> mergedEndNodeIdentifierBean = FeatureChangeMergingHelpers.mergeMember("endNode", beforeEntityLeft, afterEntityLeft, beforeEntityRight, afterEntityRight, edge -> ((Edge)edge).end() == null ? null : Long.valueOf(((Edge)edge).end().getIdentifier()), null, MemberMergeStrategies.diffBasedLongMerger);
        CompleteEdge mergedAfterEdge = new CompleteEdge(left.getIdentifier(), mergedPolyLineBean.getMergedAfterMember(), mergedTagsBean.getMergedAfterMember(), mergedStartNodeIdentifierBean.getMergedAfterMember(), mergedEndNodeIdentifierBean.getMergedAfterMember(), mergedParentRelationsBean.getMergedAfterMember());
        mergedAfterEdge.withBoundsExtendedBy(afterEntityLeft.bounds());
        mergedAfterEdge.withBoundsExtendedBy(afterEntityRight.bounds());
        CompleteEntity mergedBeforeEdge = beforeEntityLeft != null ? ((CompleteEdge)CompleteEdge.shallowFrom((Edge)beforeEntityLeft).withStartNodeIdentifier(mergedStartNodeIdentifierBean.getMergedBeforeMember()).withEndNodeIdentifier(mergedEndNodeIdentifierBean.getMergedBeforeMember()).withTags(mergedTagsBean.getMergedBeforeMember())).withRelationIdentifiers((Set)mergedParentRelationsBean.getMergedBeforeMember()) : null;
        return new FeatureChange(ChangeType.ADD, mergedAfterEdge, (AtlasEntity)((Object)mergedBeforeEdge));
    }

    private static FeatureChange mergeLineItems(FeatureChange left, FeatureChange right, MergedMemberBean<Map<String, String>> mergedTagsBean, MergedMemberBean<Set<Long>> mergedParentRelationsBean) {
        AtlasEntity beforeEntityLeft = left.getBeforeView();
        AtlasEntity afterEntityLeft = left.getAfterView();
        AtlasEntity beforeEntityRight = right.getBeforeView();
        AtlasEntity afterEntityRight = right.getAfterView();
        if (afterEntityLeft == null) {
            throw new CoreException(AFTER_ENTITY_LEFT_WAS_NULL);
        }
        if (afterEntityRight == null) {
            throw new CoreException(AFTER_ENTITY_RIGHT_WAS_NULL);
        }
        MergedMemberBean<PolyLine> mergedPolyLineBean = FeatureChangeMergingHelpers.mergeMember("polyLine", beforeEntityLeft, afterEntityLeft, beforeEntityRight, afterEntityRight, atlasEntity -> ((LineItem)atlasEntity).asPolyLine(), null, MemberMergeStrategies.diffBasedPolyLineMerger);
        if (afterEntityLeft instanceof Edge) {
            return FeatureChangeMergingHelpers.mergeEdges(left, right, mergedPolyLineBean, mergedTagsBean, mergedParentRelationsBean);
        }
        if (afterEntityLeft instanceof Line) {
            return FeatureChangeMergingHelpers.mergeLines(left, right, mergedPolyLineBean, mergedTagsBean, mergedParentRelationsBean);
        }
        throw new CoreException("Unknown AtlasEntity subtype {}", afterEntityLeft.getClass().getName());
    }

    private static FeatureChange mergeLines(FeatureChange left, FeatureChange right, MergedMemberBean<PolyLine> mergedPolyLineBean, MergedMemberBean<Map<String, String>> mergedTagsBean, MergedMemberBean<Set<Long>> mergedParentRelationsBean) {
        AtlasEntity beforeEntityLeft = left.getBeforeView();
        AtlasEntity afterEntityLeft = left.getAfterView();
        AtlasEntity afterEntityRight = right.getAfterView();
        if (afterEntityLeft == null) {
            throw new CoreException(AFTER_ENTITY_LEFT_WAS_NULL);
        }
        if (afterEntityRight == null) {
            throw new CoreException(AFTER_ENTITY_RIGHT_WAS_NULL);
        }
        CompleteLine mergedAfterLine = new CompleteLine(left.getIdentifier(), mergedPolyLineBean.getMergedAfterMember(), mergedTagsBean.getMergedAfterMember(), mergedParentRelationsBean.getMergedAfterMember());
        mergedAfterLine.withBoundsExtendedBy(afterEntityLeft.bounds());
        mergedAfterLine.withBoundsExtendedBy(afterEntityRight.bounds());
        CompleteEntity mergedBeforeLine = beforeEntityLeft != null ? ((CompleteLine)CompleteLine.shallowFrom((Line)beforeEntityLeft).withTags(mergedTagsBean.getMergedBeforeMember())).withRelationIdentifiers((Set)mergedParentRelationsBean.getMergedBeforeMember()) : null;
        return new FeatureChange(ChangeType.ADD, mergedAfterLine, (AtlasEntity)((Object)mergedBeforeLine));
    }

    private static FeatureChange mergeLocationItems(FeatureChange left, FeatureChange right, MergedMemberBean<Map<String, String>> mergedTagsBean, MergedMemberBean<Set<Long>> mergedParentRelationsBean) {
        AtlasEntity beforeEntityLeft = left.getBeforeView();
        AtlasEntity afterEntityLeft = left.getAfterView();
        AtlasEntity beforeEntityRight = right.getBeforeView();
        AtlasEntity afterEntityRight = right.getAfterView();
        if (afterEntityLeft == null) {
            throw new CoreException(AFTER_ENTITY_LEFT_WAS_NULL);
        }
        if (afterEntityRight == null) {
            throw new CoreException(AFTER_ENTITY_RIGHT_WAS_NULL);
        }
        MergedMemberBean<Location> mergedLocationBean = FeatureChangeMergingHelpers.mergeMember("location", beforeEntityLeft, afterEntityLeft, beforeEntityRight, afterEntityRight, atlasEntity -> ((LocationItem)atlasEntity).getLocation(), null, MemberMergeStrategies.diffBasedLocationMerger);
        if (afterEntityLeft instanceof Node) {
            return FeatureChangeMergingHelpers.mergeNodes(left, right, mergedLocationBean, mergedTagsBean, mergedParentRelationsBean);
        }
        if (afterEntityLeft instanceof Point) {
            return FeatureChangeMergingHelpers.mergePoints(left, right, mergedLocationBean, mergedTagsBean, mergedParentRelationsBean);
        }
        throw new CoreException("Unknown LocationItem subtype {}", afterEntityLeft.getClass().getName());
    }

    private static FeatureChange mergeNodes(FeatureChange left, FeatureChange right, MergedMemberBean<Location> mergedLocationBean, MergedMemberBean<Map<String, String>> mergedTagsBean, MergedMemberBean<Set<Long>> mergedParentRelationsBean) {
        AtlasEntity beforeEntityLeft = left.getBeforeView();
        AtlasEntity afterEntityLeft = left.getAfterView();
        AtlasEntity beforeEntityRight = right.getBeforeView();
        AtlasEntity afterEntityRight = right.getAfterView();
        if (afterEntityLeft == null) {
            throw new CoreException(AFTER_ENTITY_LEFT_WAS_NULL);
        }
        if (afterEntityRight == null) {
            throw new CoreException(AFTER_ENTITY_RIGHT_WAS_NULL);
        }
        MergedMemberBean<SortedSet<Long>> mergedInEdgeIdentifiersBean = FeatureChangeMergingHelpers.mergeMember("inEdgeIdentifiers", beforeEntityLeft, afterEntityLeft, beforeEntityRight, afterEntityRight, atlasEntity -> ((Node)atlasEntity).inEdges() == null ? null : (SortedSet)((Node)atlasEntity).inEdges().stream().map(AtlasObject::getIdentifier).collect(Collectors.toCollection(TreeSet::new)), MemberMergeStrategies.simpleLongSortedSetMerger, MemberMergeStrategies.diffBasedLongSortedSetMerger);
        MergedMemberBean<SortedSet<Long>> mergedOutEdgeIdentifiersBean = FeatureChangeMergingHelpers.mergeMember("outEdgeIdentifiers", beforeEntityLeft, afterEntityLeft, beforeEntityRight, afterEntityRight, atlasEntity -> ((Node)atlasEntity).outEdges() == null ? null : (SortedSet)((Node)atlasEntity).outEdges().stream().map(AtlasObject::getIdentifier).collect(Collectors.toCollection(TreeSet::new)), MemberMergeStrategies.simpleLongSortedSetMerger, MemberMergeStrategies.diffBasedLongSortedSetMerger);
        CompleteNode mergedAfterNode = new CompleteNode(left.getIdentifier(), mergedLocationBean.getMergedAfterMember(), mergedTagsBean.getMergedAfterMember(), mergedInEdgeIdentifiersBean.getMergedAfterMember(), mergedOutEdgeIdentifiersBean.getMergedAfterMember(), mergedParentRelationsBean.getMergedAfterMember());
        mergedAfterNode.withBoundsExtendedBy(afterEntityLeft.bounds());
        mergedAfterNode.withBoundsExtendedBy(afterEntityRight.bounds());
        CompleteEntity mergedBeforeNode = beforeEntityLeft != null ? ((CompleteNode)CompleteNode.shallowFrom((Node)beforeEntityLeft).withInEdgeIdentifiers(mergedInEdgeIdentifiersBean.getMergedBeforeMember()).withOutEdgeIdentifiers(mergedOutEdgeIdentifiersBean.getMergedBeforeMember()).withTags(mergedTagsBean.getMergedBeforeMember())).withRelationIdentifiers((Set)mergedParentRelationsBean.getMergedBeforeMember()) : null;
        return new FeatureChange(ChangeType.ADD, mergedAfterNode, (AtlasEntity)((Object)mergedBeforeNode));
    }

    private static FeatureChange mergePoints(FeatureChange left, FeatureChange right, MergedMemberBean<Location> mergedLocationBean, MergedMemberBean<Map<String, String>> mergedTagsBean, MergedMemberBean<Set<Long>> mergedParentRelationsBean) {
        AtlasEntity beforeEntityLeft = left.getBeforeView();
        AtlasEntity afterEntityLeft = left.getAfterView();
        AtlasEntity afterEntityRight = right.getAfterView();
        if (afterEntityLeft == null) {
            throw new CoreException(AFTER_ENTITY_LEFT_WAS_NULL);
        }
        if (afterEntityRight == null) {
            throw new CoreException(AFTER_ENTITY_RIGHT_WAS_NULL);
        }
        CompletePoint mergedAfterPoint = new CompletePoint(left.getIdentifier(), mergedLocationBean.getMergedAfterMember(), mergedTagsBean.getMergedAfterMember(), mergedParentRelationsBean.getMergedAfterMember());
        mergedAfterPoint.withBoundsExtendedBy(afterEntityLeft.bounds());
        mergedAfterPoint.withBoundsExtendedBy(afterEntityRight.bounds());
        CompleteEntity mergedBeforePoint = beforeEntityLeft != null ? ((CompletePoint)CompletePoint.shallowFrom((Point)beforeEntityLeft).withTags(mergedTagsBean.getMergedBeforeMember())).withRelationIdentifiers((Set)mergedParentRelationsBean.getMergedBeforeMember()) : null;
        return new FeatureChange(ChangeType.ADD, mergedAfterPoint, (AtlasEntity)((Object)mergedBeforePoint));
    }

    private static FeatureChange mergeRelations(FeatureChange left, FeatureChange right, MergedMemberBean<Map<String, String>> mergedTagsBean, MergedMemberBean<Set<Long>> mergedParentRelationsBean) {
        AtlasEntity beforeEntityLeft = left.getBeforeView();
        AtlasEntity afterEntityLeft = left.getAfterView();
        AtlasEntity beforeEntityRight = right.getBeforeView();
        AtlasEntity afterEntityRight = right.getAfterView();
        if (afterEntityLeft == null) {
            throw new CoreException(AFTER_ENTITY_LEFT_WAS_NULL);
        }
        if (afterEntityRight == null) {
            throw new CoreException(AFTER_ENTITY_RIGHT_WAS_NULL);
        }
        MergedMemberBean<RelationBean> mergedMembersBean = FeatureChangeMergingHelpers.mergeMember("relationMembers", beforeEntityLeft, afterEntityLeft, beforeEntityRight, afterEntityRight, entity -> ((Relation)entity).members() == null ? null : ((Relation)entity).members().asBean(), MemberMergeStrategies.simpleRelationBeanMerger, MemberMergeStrategies.diffBasedRelationBeanMerger);
        MergedMemberBean<Set<Long>> mergedAllRelationsWithSameOsmIdentifierBean = FeatureChangeMergingHelpers.mergeMember("allRelationsWithSameOsmIdentifier", beforeEntityLeft, afterEntityLeft, beforeEntityRight, afterEntityRight, atlasEntity -> ((Relation)atlasEntity).allRelationsWithSameOsmIdentifier() == null ? null : ((Relation)atlasEntity).allRelationsWithSameOsmIdentifier().stream().map(AtlasObject::getIdentifier).collect(Collectors.toSet()), MemberMergeStrategies.simpleLongSetMerger, MemberMergeStrategies.diffBasedLongSetMerger);
        MergedMemberBean<RelationBean> mergedAllKnownMembersBean = FeatureChangeMergingHelpers.mergeMember("allKnownOsmMembers", beforeEntityLeft, afterEntityLeft, beforeEntityRight, afterEntityRight, entity -> ((Relation)entity).allKnownOsmMembers() == null ? null : ((Relation)entity).allKnownOsmMembers().asBean(), MemberMergeStrategies.simpleRelationBeanMerger, MemberMergeStrategies.diffBasedRelationBeanMerger);
        MergedMemberBean<Long> mergedOsmRelationIdentifier = FeatureChangeMergingHelpers.mergeMember("osmRelationIdentifier", beforeEntityLeft, afterEntityLeft, beforeEntityRight, afterEntityRight, entity -> ((Relation)entity).osmRelationIdentifier(), null, MemberMergeStrategies.diffBasedLongMerger);
        Rectangle mergedBounds = Rectangle.forLocated(afterEntityLeft, afterEntityRight);
        CompleteRelation mergedAfterRelation = new CompleteRelation(left.getIdentifier(), mergedTagsBean.getMergedAfterMember(), mergedBounds, mergedMembersBean.getMergedAfterMember(), mergedAllRelationsWithSameOsmIdentifierBean.getMergedAfterMember() != null ? mergedAllRelationsWithSameOsmIdentifierBean.getMergedAfterMember().stream().collect(Collectors.toList()) : null, mergedAllKnownMembersBean.getMergedAfterMember(), mergedOsmRelationIdentifier.getMergedAfterMember(), mergedParentRelationsBean.getMergedAfterMember());
        mergedAfterRelation.withBoundsExtendedBy(afterEntityLeft.bounds());
        mergedAfterRelation.withBoundsExtendedBy(afterEntityRight.bounds());
        CompleteEntity mergedBeforeRelation = beforeEntityLeft != null ? ((CompleteRelation)CompleteRelation.shallowFrom((Relation)beforeEntityLeft).withMembers(mergedMembersBean.getMergedBeforeMember(), beforeEntityLeft.bounds()).withAllRelationsWithSameOsmIdentifier(mergedAllRelationsWithSameOsmIdentifierBean.getMergedAfterMember() != null ? mergedAllRelationsWithSameOsmIdentifierBean.getMergedBeforeMember().stream().collect(Collectors.toList()) : null).withAllKnownOsmMembers(mergedAllKnownMembersBean.getMergedBeforeMember()).withOsmRelationIdentifier(mergedOsmRelationIdentifier.getMergedBeforeMember()).withTags(mergedTagsBean.getMergedBeforeMember())).withRelationIdentifiers((Set)mergedParentRelationsBean.getMergedBeforeMember()) : null;
        return new FeatureChange(ChangeType.ADD, mergedAfterRelation, (AtlasEntity)((Object)mergedBeforeRelation));
    }

    private FeatureChangeMergingHelpers() {
    }
}

