/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.change;

import java.io.Serializable;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.geography.Located;
import org.openstreetmap.atlas.geography.Rectangle;
import org.openstreetmap.atlas.geography.atlas.Atlas;
import org.openstreetmap.atlas.geography.atlas.change.ChangeType;
import org.openstreetmap.atlas.geography.atlas.change.FeatureChangeMergingHelpers;
import org.openstreetmap.atlas.geography.atlas.change.serializer.FeatureChangeGeoJsonSerializer;
import org.openstreetmap.atlas.geography.atlas.complete.CompleteArea;
import org.openstreetmap.atlas.geography.atlas.complete.CompleteEdge;
import org.openstreetmap.atlas.geography.atlas.complete.CompleteEntity;
import org.openstreetmap.atlas.geography.atlas.complete.CompleteLineItem;
import org.openstreetmap.atlas.geography.atlas.complete.CompleteLocationItem;
import org.openstreetmap.atlas.geography.atlas.complete.CompleteNode;
import org.openstreetmap.atlas.geography.atlas.complete.CompleteRelation;
import org.openstreetmap.atlas.geography.atlas.items.Area;
import org.openstreetmap.atlas.geography.atlas.items.AtlasEntity;
import org.openstreetmap.atlas.geography.atlas.items.AtlasObject;
import org.openstreetmap.atlas.geography.atlas.items.Edge;
import org.openstreetmap.atlas.geography.atlas.items.ItemType;
import org.openstreetmap.atlas.geography.atlas.items.Line;
import org.openstreetmap.atlas.geography.atlas.items.LineItem;
import org.openstreetmap.atlas.geography.atlas.items.LocationItem;
import org.openstreetmap.atlas.geography.atlas.items.Node;
import org.openstreetmap.atlas.geography.atlas.items.Point;
import org.openstreetmap.atlas.geography.atlas.items.Relation;
import org.openstreetmap.atlas.geography.atlas.validators.FeatureChangeUsefulnessValidator;
import org.openstreetmap.atlas.streaming.resource.WritableResource;

public class FeatureChange
implements Located,
Serializable {
    private static final long serialVersionUID = 9172045162819925515L;
    private final String featureChangeIdentifier = UUID.randomUUID().toString();
    private final ChangeType changeType;
    private AtlasEntity beforeView;
    private final AtlasEntity afterView;

    public static FeatureChange add(AtlasEntity afterView) {
        return new FeatureChange(ChangeType.ADD, afterView);
    }

    public static FeatureChange add(AtlasEntity afterView, Atlas atlasContext) {
        return new FeatureChange(ChangeType.ADD, afterView).withAtlasContext(atlasContext);
    }

    public static FeatureChange remove(AtlasEntity reference) {
        return new FeatureChange(ChangeType.REMOVE, reference);
    }

    public static FeatureChange remove(AtlasEntity reference, Atlas atlasContext) {
        return new FeatureChange(ChangeType.REMOVE, reference).withAtlasContext(atlasContext);
    }

    FeatureChange(ChangeType changeType, AtlasEntity afterView) {
        this(changeType, afterView, null);
    }

    FeatureChange(ChangeType changeType, AtlasEntity afterView, AtlasEntity beforeView) {
        if (afterView == null) {
            throw new CoreException("After view cannot be null.");
        }
        if (!(afterView instanceof CompleteEntity)) {
            throw new CoreException("FeatureChange afterView requires CompleteEntity, found reference of type {}", afterView.getClass().getName());
        }
        if (beforeView != null && !(beforeView instanceof CompleteEntity)) {
            throw new CoreException("FeatureChange beforeView requires CompleteEntity, found reference of type {}", beforeView.getClass().getName());
        }
        if (changeType == null) {
            throw new CoreException("changeType cannot be null.");
        }
        this.changeType = changeType;
        this.afterView = afterView;
        this.beforeView = beforeView;
        if (this.afterView.bounds() == null) {
            throw new CoreException("afterView {} bounds was null for {}", this.afterView, this.toString());
        }
        if (this.beforeView != null && this.beforeView.bounds() == null) {
            throw new CoreException("beforeView {} bounds was null for {}", this.beforeView, this.toString());
        }
        this.validateNotShallow();
        if (this.beforeView != null) {
            new FeatureChangeUsefulnessValidator(this).validate();
        }
    }

    public String getFeatureChangeIdentifier() {
        return this.featureChangeIdentifier;
    }

    FeatureChange withAtlasContext(Atlas atlas) {
        this.computeBeforeViewUsingAtlasContext(atlas, this.changeType);
        new FeatureChangeUsefulnessValidator(this).validate();
        return this;
    }

    public boolean afterViewIsFull() {
        if (this.getAfterView().getTags() == null || this.getAfterView().relations() == null) {
            return false;
        }
        switch (this.getItemType()) {
            case NODE: {
                Node nodeReference = (Node)this.getAfterView();
                if (nodeReference.inEdges() != null && nodeReference.outEdges() != null && nodeReference.getLocation() != null) break;
                return false;
            }
            case EDGE: {
                Edge edgeReference = (Edge)this.getAfterView();
                if (edgeReference.start() != null && edgeReference.end() != null && edgeReference.asPolyLine() != null) break;
                return false;
            }
            case AREA: {
                Area areaReference = (Area)this.getAfterView();
                if (areaReference.asPolygon() != null) break;
                return false;
            }
            case LINE: {
                Line lineReference = (Line)this.getAfterView();
                if (lineReference.asPolyLine() != null) break;
                return false;
            }
            case POINT: {
                Point pointReference = (Point)this.getAfterView();
                if (pointReference.getLocation() != null) break;
                return false;
            }
            case RELATION: {
                Relation relationReference = (Relation)this.getAfterView();
                if (relationReference.members() != null && relationReference.allKnownOsmMembers() != null && relationReference.allRelationsWithSameOsmIdentifier() != null) break;
                return false;
            }
            default: {
                throw new CoreException("Unknown Item Type {}", new Object[]{this.getItemType()});
            }
        }
        return true;
    }

    @Override
    public Rectangle bounds() {
        Rectangle updatedBounds = this.afterView.bounds();
        if (this.beforeView == null) {
            return updatedBounds;
        }
        return Rectangle.forLocated(this.beforeView.bounds(), updatedBounds);
    }

    public boolean equals(Object other) {
        if (other instanceof FeatureChange) {
            FeatureChange that = (FeatureChange)other;
            return this.getChangeType() == that.getChangeType() && this.getAfterView().equals(that.getAfterView());
        }
        return false;
    }

    public AtlasEntity getAfterView() {
        return this.afterView;
    }

    public AtlasEntity getBeforeView() {
        return this.beforeView;
    }

    public ChangeType getChangeType() {
        return this.changeType;
    }

    public long getIdentifier() {
        return this.getAfterView().getIdentifier();
    }

    public ItemType getItemType() {
        return this.getAfterView().getType();
    }

    public Optional<String> getTag(String key) {
        return this.getAfterView().getTag(key);
    }

    public Map<String, String> getTags() {
        return this.getAfterView().getTags();
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.changeType, this.afterView});
    }

    public FeatureChange merge(FeatureChange other) {
        try {
            if (this.getIdentifier() != other.getIdentifier() || this.getItemType() != other.getItemType() || this.getChangeType() != other.getChangeType()) {
                throw new CoreException("Cannot merge FeatureChanges with mismatching properties: [{}, {}, {}] vs [{}, {}, {}]", new Object[]{this.getIdentifier(), this.getItemType(), this.getChangeType(), other.getIdentifier(), other.getItemType(), other.getChangeType()});
            }
            if (this.getBeforeView() == null && other.getBeforeView() != null || this.getBeforeView() != null && other.getBeforeView() == null) {
                throw new CoreException("One of the FeatureChanges was missing a beforeView - cannot merge two FeatureChanges unless both either explicitly provide or explicitly exclude a beforeView, {} and {}", this.toString(), other.toString());
            }
            if (this.getChangeType() == ChangeType.REMOVE) {
                return this;
            }
            if (this.getChangeType() == ChangeType.ADD) {
                return FeatureChangeMergingHelpers.mergeADDFeatureChangePair(this, other);
            }
            throw new CoreException("Unable to merge {} and {}", this, other);
        }
        catch (Exception exception) {
            throw new CoreException("Cannot merge two feature changes {} and {}.", this, other, exception);
        }
    }

    public void save(WritableResource resource) {
        new FeatureChangeGeoJsonSerializer().accept(this, resource);
    }

    public String toGeoJson() {
        return new FeatureChangeGeoJsonSerializer().convert(this);
    }

    public String toString() {
        return "FeatureChange [changeType=" + (Object)((Object)this.changeType) + ", reference={" + (Object)((Object)this.afterView.getType()) + "," + this.afterView.getIdentifier() + "}, tags=" + this.getTags() + ", bounds=" + this.bounds() + "]";
    }

    private void computeBeforeViewUsingAtlasContext(Atlas atlas, ChangeType changeType) {
        Set<Relation> updatedViewRelations;
        AtlasEntity beforeViewUpdatesOnly;
        if (atlas == null) {
            throw new CoreException("Atlas context cannot be null for {}", this.toString());
        }
        AtlasEntity beforeViewFromAtlas = atlas.entity(this.afterView.getIdentifier(), this.afterView.getType());
        if (beforeViewFromAtlas == null && changeType != ChangeType.ADD) {
            throw new CoreException("Could not find {} with ID {} in atlas context, ChangeType was {}", new Object[]{this.afterView.getType(), this.afterView.getIdentifier(), changeType});
        }
        if (changeType == ChangeType.REMOVE) {
            this.beforeView = CompleteEntity.from(beforeViewFromAtlas);
            return;
        }
        if (changeType != ChangeType.ADD) {
            throw new CoreException("Unknown ChangeType {}", new Object[]{changeType});
        }
        if (beforeViewFromAtlas == null) {
            this.beforeView = null;
            return;
        }
        if (this.afterView instanceof Area) {
            Area afterAreaView = (Area)this.afterView;
            Area beforeAreaViewFromAtlas = (Area)beforeViewFromAtlas;
            beforeViewUpdatesOnly = CompleteArea.shallowFrom(beforeAreaViewFromAtlas);
            if (afterAreaView.asPolygon() != null) {
                beforeViewUpdatesOnly.withPolygon(beforeAreaViewFromAtlas.asPolygon());
            }
        } else if (this.afterView instanceof LineItem) {
            LineItem afterLineItemView = (LineItem)this.afterView;
            LineItem beforeLineItemViewFromAtlas = (LineItem)beforeViewFromAtlas;
            beforeViewUpdatesOnly = CompleteEntity.shallowFrom(beforeLineItemViewFromAtlas);
            if (afterLineItemView.asPolyLine() != null) {
                ((CompleteLineItem)((Object)beforeViewUpdatesOnly)).withPolyLine(beforeLineItemViewFromAtlas.asPolyLine());
            }
            if (this.afterView instanceof Edge) {
                Edge afterEdgeView = (Edge)afterLineItemView;
                Edge beforeEdgeViewFromAtlas = (Edge)beforeViewFromAtlas;
                if (afterEdgeView.start() != null) {
                    ((CompleteEdge)beforeViewUpdatesOnly).withStartNodeIdentifier(beforeEdgeViewFromAtlas.start().getIdentifier());
                }
                if (afterEdgeView.end() != null) {
                    ((CompleteEdge)beforeViewUpdatesOnly).withEndNodeIdentifier(beforeEdgeViewFromAtlas.end().getIdentifier());
                }
            }
        } else if (this.afterView instanceof LocationItem) {
            LocationItem afterLocationItemView = (LocationItem)this.afterView;
            LocationItem beforeLocationItemViewFromAtlas = (LocationItem)beforeViewFromAtlas;
            beforeViewUpdatesOnly = CompleteEntity.shallowFrom(beforeLocationItemViewFromAtlas);
            if (afterLocationItemView.getLocation() != null) {
                ((CompleteLocationItem)((Object)beforeViewUpdatesOnly)).withLocation(beforeLocationItemViewFromAtlas.getLocation());
            }
            if (this.afterView instanceof Node) {
                Node afterNodeView = (Node)afterLocationItemView;
                Node beforeNodeViewFromAtlas = (Node)beforeViewFromAtlas;
                if (afterNodeView.inEdges() != null) {
                    ((CompleteNode)beforeViewUpdatesOnly).withInEdges(beforeNodeViewFromAtlas.inEdges());
                }
                if (afterNodeView.outEdges() != null) {
                    ((CompleteNode)beforeViewUpdatesOnly).withOutEdges(beforeNodeViewFromAtlas.outEdges());
                }
            }
        } else if (this.afterView instanceof Relation) {
            Relation afterRelationView = (Relation)this.afterView;
            Relation beforeRelationViewFromAtlas = (Relation)beforeViewFromAtlas;
            beforeViewUpdatesOnly = CompleteRelation.shallowFrom(afterRelationView);
            if (afterRelationView.members() != null) {
                ((CompleteRelation)beforeViewUpdatesOnly).withMembers(beforeRelationViewFromAtlas.members());
            }
            if (afterRelationView.allRelationsWithSameOsmIdentifier() != null) {
                ((CompleteRelation)beforeViewUpdatesOnly).withAllRelationsWithSameOsmIdentifier(beforeRelationViewFromAtlas.allRelationsWithSameOsmIdentifier().stream().map(AtlasObject::getIdentifier).collect(Collectors.toList()));
            }
            if (afterRelationView.allKnownOsmMembers() != null) {
                ((CompleteRelation)beforeViewUpdatesOnly).withAllKnownOsmMembers(beforeRelationViewFromAtlas.allKnownOsmMembers().asBean());
            }
            if (afterRelationView.osmRelationIdentifier() != null) {
                ((CompleteRelation)beforeViewUpdatesOnly).withOsmRelationIdentifier(beforeRelationViewFromAtlas.osmRelationIdentifier());
            }
        } else {
            throw new CoreException("Unknown entity type {}", new Object[]{this.afterView.getType()});
        }
        Map<String, String> updatedViewTags = this.afterView.getTags();
        if (updatedViewTags != null) {
            ((CompleteEntity)((Object)beforeViewUpdatesOnly)).withTags(beforeViewFromAtlas.getTags());
        }
        if ((updatedViewRelations = this.afterView.relations()) != null) {
            ((CompleteEntity)((Object)beforeViewUpdatesOnly)).withRelations(beforeViewFromAtlas.relations());
        }
        this.beforeView = beforeViewUpdatesOnly;
    }

    private void validateNotShallow() {
        if (this.changeType == ChangeType.ADD && ((CompleteEntity)((Object)this.afterView)).isShallow()) {
            throw new CoreException("{} was shallow (i.e. it contained only an identifier)", this);
        }
    }
}

