/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.change;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.openstreetmap.atlas.geography.atlas.builder.RelationBean;
import org.openstreetmap.atlas.geography.atlas.change.ChangeAtlas;
import org.openstreetmap.atlas.geography.atlas.change.ChangeEntity;
import org.openstreetmap.atlas.geography.atlas.items.AtlasEntity;
import org.openstreetmap.atlas.geography.atlas.items.AtlasObject;
import org.openstreetmap.atlas.geography.atlas.items.Relation;
import org.openstreetmap.atlas.geography.atlas.items.RelationMember;
import org.openstreetmap.atlas.geography.atlas.items.RelationMemberList;
import org.openstreetmap.atlas.tags.Taggable;

public class ChangeRelation
extends Relation {
    private static final long serialVersionUID = 4353679260691518275L;
    private final Relation source;
    private final Relation override;
    private transient RelationMemberList membersCache;
    private transient Object membersCacheLock = new Object();
    private transient Set<Relation> relationsCache;
    private transient Object relationsCacheLock = new Object();

    protected ChangeRelation(ChangeAtlas atlas, Relation source, Relation override) {
        super(atlas);
        this.source = source;
        this.override = override;
    }

    @Override
    public RelationMemberList allKnownOsmMembers() {
        return this.membersFor(this.attribute(Relation::allKnownOsmMembers, "all known osm members").asBean());
    }

    @Override
    public List<Relation> allRelationsWithSameOsmIdentifier() {
        return this.attribute(Relation::allRelationsWithSameOsmIdentifier, "all relations with same osm identifier").stream().map(relation -> this.getChangeAtlas().relation(relation.getIdentifier())).collect(Collectors.toList());
    }

    @Override
    public long getIdentifier() {
        return this.attribute(AtlasObject::getIdentifier, "identifier");
    }

    @Override
    public Map<String, String> getTags() {
        return this.attribute(Taggable::getTags, "tags");
    }

    @Override
    public RelationMemberList members() {
        Supplier<RelationMemberList> creator = () -> {
            List<RelationMemberList> availableMemberLists = this.allAvailableAttributes(Relation::members, "members");
            RelationBean mergedMembersBean = availableMemberLists.stream().map(RelationMemberList::asBean).reduce(new RelationBean(), RelationBean::merge);
            RelationBean filteredAndMergedMembersBean = new RelationBean();
            mergedMembersBean.forEach(relationBeanItem -> {
                if (this.getChangeAtlas().entity(relationBeanItem.getIdentifier(), relationBeanItem.getType()) != null) {
                    filteredAndMergedMembersBean.addItem((RelationBean.RelationBeanItem)relationBeanItem);
                }
            });
            return this.membersFor(filteredAndMergedMembersBean);
        };
        return ChangeEntity.getOrCreateCache(this.membersCache, cache -> {
            this.membersCache = cache;
        }, this.membersCacheLock, creator);
    }

    @Override
    public Long osmRelationIdentifier() {
        return this.attribute(Relation::osmRelationIdentifier, "osm relation identifier");
    }

    @Override
    public Set<Relation> relations() {
        Supplier<Set> creator = () -> ChangeEntity.filterRelations(this.attribute(AtlasEntity::relations, "relations"), this.getChangeAtlas());
        return ChangeEntity.getOrCreateCache(this.relationsCache, cache -> {
            this.relationsCache = cache;
        }, this.relationsCacheLock, creator);
    }

    private <T> List<T> allAvailableAttributes(Function<Relation, T> memberExtractor, String name) {
        return ChangeEntity.getAttributeAndOptionallyBackup(this.source, this.override, memberExtractor, name);
    }

    private <T> T attribute(Function<Relation, T> memberExtractor, String name) {
        return ChangeEntity.getAttributeOrBackup(this.source, this.override, memberExtractor, name);
    }

    private ChangeAtlas getChangeAtlas() {
        return (ChangeAtlas)this.getAtlas();
    }

    private RelationMemberList membersFor(RelationBean bean) {
        if (bean == null) {
            return null;
        }
        ArrayList<RelationMember> memberList = new ArrayList<RelationMember>();
        for (RelationBean.RelationBeanItem item : bean) {
            AtlasEntity memberChangeEntity = this.getChangeAtlas().entity(item.getIdentifier(), item.getType());
            if (memberChangeEntity == null) continue;
            memberList.add(new RelationMember(item.getRole(), memberChangeEntity, this.getIdentifier()));
        }
        return new RelationMemberList(memberList);
    }
}

