/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.change;

import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import org.openstreetmap.atlas.geography.PolyLine;
import org.openstreetmap.atlas.geography.atlas.change.ChangeAtlas;
import org.openstreetmap.atlas.geography.atlas.change.ChangeEntity;
import org.openstreetmap.atlas.geography.atlas.items.AtlasEntity;
import org.openstreetmap.atlas.geography.atlas.items.AtlasObject;
import org.openstreetmap.atlas.geography.atlas.items.Edge;
import org.openstreetmap.atlas.geography.atlas.items.LineItem;
import org.openstreetmap.atlas.geography.atlas.items.Node;
import org.openstreetmap.atlas.geography.atlas.items.Relation;
import org.openstreetmap.atlas.tags.Taggable;

public class ChangeEdge
extends Edge {
    private static final long serialVersionUID = -5658471275390043045L;
    private final Edge source;
    private final Edge override;
    private transient Set<Relation> relationsCache;
    private transient Object relationsCacheLock = new Object();
    private transient Node startNodeCache;
    private transient Object startNodeCacheLock = new Object();
    private transient Node endNodeCache;
    private transient Object endNodeCacheLock = new Object();

    protected ChangeEdge(ChangeAtlas atlas, Edge source, Edge override) {
        super(atlas);
        this.source = source;
        this.override = override;
    }

    @Override
    public PolyLine asPolyLine() {
        return this.attribute(LineItem::asPolyLine, "polyLine");
    }

    @Override
    public Node end() {
        Supplier<Node> creator = () -> this.getChangeAtlas().node(this.endNodeIdentifier());
        return ChangeEntity.getOrCreateCache(this.endNodeCache, cache -> {
            this.endNodeCache = cache;
        }, this.endNodeCacheLock, creator);
    }

    public long endNodeIdentifier() {
        return this.attribute(Edge::end, "end node").getIdentifier();
    }

    @Override
    public long getIdentifier() {
        return this.attribute(AtlasObject::getIdentifier, "identifier");
    }

    @Override
    public Map<String, String> getTags() {
        return this.attribute(Taggable::getTags, "tags");
    }

    @Override
    public Set<Relation> relations() {
        Supplier<Set> creator = () -> ChangeEntity.filterRelations(this.attribute(AtlasEntity::relations, "relations"), this.getChangeAtlas());
        return ChangeEntity.getOrCreateCache(this.relationsCache, cache -> {
            this.relationsCache = cache;
        }, this.relationsCacheLock, creator);
    }

    @Override
    public Node start() {
        Supplier<Node> creator = () -> this.getChangeAtlas().node(this.startNodeIdentifier());
        return ChangeEntity.getOrCreateCache(this.startNodeCache, cache -> {
            this.startNodeCache = cache;
        }, this.startNodeCacheLock, creator);
    }

    public long startNodeIdentifier() {
        return this.attribute(Edge::start, "start node").getIdentifier();
    }

    private <T> T attribute(Function<Edge, T> memberExtractor, String name) {
        return ChangeEntity.getAttributeOrBackup(this.source, this.override, memberExtractor, name);
    }

    private ChangeAtlas getChangeAtlas() {
        return (ChangeAtlas)this.getAtlas();
    }
}

