/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.change;

import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import org.openstreetmap.atlas.geography.Polygon;
import org.openstreetmap.atlas.geography.atlas.change.ChangeAtlas;
import org.openstreetmap.atlas.geography.atlas.change.ChangeEntity;
import org.openstreetmap.atlas.geography.atlas.items.Area;
import org.openstreetmap.atlas.geography.atlas.items.AtlasEntity;
import org.openstreetmap.atlas.geography.atlas.items.AtlasObject;
import org.openstreetmap.atlas.geography.atlas.items.Relation;
import org.openstreetmap.atlas.tags.Taggable;

public class ChangeArea
extends Area {
    private static final long serialVersionUID = -5658471275390043045L;
    private final Area source;
    private final Area override;
    private transient Set<Relation> relationsCache;
    private transient Object relationsCacheLock = new Object();

    protected ChangeArea(ChangeAtlas atlas, Area source, Area override) {
        super(atlas);
        this.source = source;
        this.override = override;
    }

    @Override
    public Polygon asPolygon() {
        return this.attribute(Area::asPolygon, "polygon");
    }

    @Override
    public long getIdentifier() {
        return this.attribute(AtlasObject::getIdentifier, "identifier");
    }

    @Override
    public Map<String, String> getTags() {
        return this.attribute(Taggable::getTags, "tags");
    }

    @Override
    public Set<Relation> relations() {
        Supplier<Set> creator = () -> ChangeEntity.filterRelations(this.attribute(AtlasEntity::relations, "relations"), this.getChangeAtlas());
        return ChangeEntity.getOrCreateCache(this.relationsCache, cache -> {
            this.relationsCache = cache;
        }, this.relationsCacheLock, creator);
    }

    private <T> T attribute(Function<Area, T> memberExtractor, String name) {
        return ChangeEntity.getAttributeOrBackup(this.source, this.override, memberExtractor, name);
    }

    private ChangeAtlas getChangeAtlas() {
        return (ChangeAtlas)this.getAtlas();
    }
}

