/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.change;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openstreetmap.atlas.geography.Located;
import org.openstreetmap.atlas.geography.Rectangle;
import org.openstreetmap.atlas.geography.atlas.change.FeatureChange;
import org.openstreetmap.atlas.geography.atlas.change.FeatureChangeMergeGroup;
import org.openstreetmap.atlas.geography.atlas.change.serializer.ChangeGeoJsonSerializer;
import org.openstreetmap.atlas.geography.atlas.items.ItemType;
import org.openstreetmap.atlas.streaming.resource.WritableResource;
import org.openstreetmap.atlas.utilities.collections.StringList;
import org.openstreetmap.atlas.utilities.tuples.Tuple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Change
implements Located,
Serializable {
    private static final long serialVersionUID = 1048481626851547987L;
    private static final Logger logger = LoggerFactory.getLogger(Change.class);
    private static final AtomicInteger CHANGE_IDENTIFIER_FACTORY = new AtomicInteger();
    private final List<FeatureChange> featureChanges = new ArrayList<FeatureChange>();
    private final Map<Tuple<ItemType, Long>, Integer> identifierToIndex = new HashMap<Tuple<ItemType, Long>, Integer>();
    private final int identifier = CHANGE_IDENTIFIER_FACTORY.getAndIncrement();
    private Rectangle bounds;
    private String name;

    public static Change merge(Change ... changeInstances) {
        FeatureChange[] mergedFeatureChanges = (FeatureChange[])Arrays.stream(changeInstances).flatMap(Change::changes).collect(Collectors.groupingBy(FeatureChangeMergeGroup::from, LinkedHashMap::new, Collectors.reducing(FeatureChange::merge))).values().stream().map(Optional::get).toArray(FeatureChange[]::new);
        return Change.newInstance().withName("Merged Change").addAll(mergedFeatureChanges);
    }

    public static Change newInstance() {
        return new Change();
    }

    protected Change() {
    }

    List<FeatureChange> getFeatureChanges() {
        return this.featureChanges;
    }

    @Override
    public Rectangle bounds() {
        return this.bounds;
    }

    public int changeCount() {
        return this.featureChanges.size();
    }

    public Optional<FeatureChange> changeFor(ItemType itemType, Long identifier) {
        Tuple<ItemType, Long> key = new Tuple<ItemType, Long>(itemType, identifier);
        if (!this.identifierToIndex.containsKey(key)) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.featureChanges.get(this.identifierToIndex.get(key)));
    }

    public Stream<FeatureChange> changes() {
        return this.featureChanges.stream();
    }

    public Stream<FeatureChange> changesFor(ItemType itemType) {
        return this.identifierToIndex.keySet().stream().filter(tuple -> tuple.getFirst() == itemType).map(tuple -> this.featureChanges.get(this.identifierToIndex.get(tuple)));
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        Change that = (Change)other;
        return Objects.equals(this.featureChanges, that.featureChanges);
    }

    public int getIdentifier() {
        return this.identifier;
    }

    public String getName() {
        return Optional.ofNullable(this.name).orElse(String.valueOf(this.getIdentifier()));
    }

    public int hashCode() {
        return Objects.hashCode(this.featureChanges);
    }

    public void save(WritableResource resource) {
        new ChangeGeoJsonSerializer().accept(this, resource);
    }

    public String toJson() {
        return new ChangeGeoJsonSerializer().convert(this);
    }

    public String toString() {
        StringList split = new StringList();
        StringBuilder builder = new StringBuilder();
        for (int index = 0; index < this.featureChanges.size(); ++index) {
            split.add(index + " - " + this.featureChanges.get(index));
        }
        builder.append("[Change:");
        builder.append(System.lineSeparator());
        builder.append(split.join(System.lineSeparator()));
        builder.append(System.lineSeparator());
        builder.append("]");
        return builder.toString();
    }

    public Change withName(String name) {
        this.name = name;
        return this;
    }

    protected Change add(FeatureChange featureChange) {
        int currentIndex = this.featureChanges.size();
        Tuple<ItemType, Long> key = new Tuple<ItemType, Long>(featureChange.getItemType(), featureChange.getIdentifier());
        FeatureChange chosen = featureChange;
        if (!this.identifierToIndex.containsKey(key)) {
            this.identifierToIndex.put(key, currentIndex);
            this.featureChanges.add(featureChange);
        } else {
            int existingIndex = this.identifierToIndex.get(key);
            FeatureChange existing = this.featureChanges.get(existingIndex);
            logger.trace("Change already has a similar feature change. Triggered a merge attempt! Existing: {}; New: {}", (Object)existing, (Object)featureChange);
            chosen = existing.merge(featureChange);
            this.featureChanges.set(existingIndex, chosen);
        }
        Rectangle featureBounds = chosen.bounds();
        this.bounds = this.bounds != null ? (featureBounds != null ? this.bounds.combine(featureBounds) : this.bounds) : featureBounds;
        return this;
    }

    protected Change addAll(FeatureChange ... featureChanges) {
        Arrays.stream(featureChanges).forEach(this::add);
        return this;
    }
}

