/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.change;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.stream.Collectors;
import org.openstreetmap.atlas.geography.Rectangle;
import org.openstreetmap.atlas.geography.atlas.Atlas;
import org.openstreetmap.atlas.geography.atlas.change.Change;
import org.openstreetmap.atlas.geography.atlas.change.ChangeAtlas;
import org.openstreetmap.atlas.geography.atlas.change.ChangeBuilder;
import org.openstreetmap.atlas.geography.atlas.change.FeatureChange;
import org.openstreetmap.atlas.geography.atlas.complete.CompleteNode;
import org.openstreetmap.atlas.geography.atlas.items.Edge;
import org.openstreetmap.atlas.geography.atlas.items.ItemType;
import org.openstreetmap.atlas.geography.atlas.items.Node;
import org.openstreetmap.atlas.utilities.conversion.Converter;
import org.openstreetmap.atlas.utilities.maps.MultiMapWithSet;

public interface AtlasChangeGenerator
extends Converter<Atlas, Set<FeatureChange>>,
Serializable {
    public static Set<FeatureChange> expandNodeBounds(Atlas atlas, Set<FeatureChange> featureChanges) {
        Iterator bounds;
        HashSet<FeatureChange> result = new HashSet<FeatureChange>();
        HashSet<FeatureChange> nodes = new HashSet<FeatureChange>();
        MultiMapWithSet nodeIdentifierToConnectedEdgeBounds = new MultiMapWithSet();
        for (FeatureChange featureChange : featureChanges) {
            ItemType itemType = featureChange.getItemType();
            if (itemType == ItemType.NODE) {
                nodes.add(featureChange);
                continue;
            }
            result.add(featureChange);
            if (itemType != ItemType.EDGE) continue;
            Edge changedEdge = (Edge)featureChange.getAfterView();
            Node start = changedEdge.start();
            Node end = changedEdge.end();
            bounds = changedEdge.bounds();
            if (start != null) {
                nodeIdentifierToConnectedEdgeBounds.add(start.getIdentifier(), bounds);
            }
            if (end == null) continue;
            nodeIdentifierToConnectedEdgeBounds.add(end.getIdentifier(), bounds);
        }
        for (FeatureChange featureChange : nodes) {
            Rectangle newBounds = featureChange.bounds();
            Long originalNodeIdentifier = featureChange.getIdentifier();
            CompleteNode originalCompleteNode = (CompleteNode)featureChange.getAfterView();
            Node originalNode = atlas.node(originalNodeIdentifier);
            if (originalNode != null) {
                for (Edge originalEdge : originalNode.connectedEdges()) {
                    newBounds = newBounds.combine(originalEdge.bounds());
                }
            }
            if (nodeIdentifierToConnectedEdgeBounds.containsKey(originalNodeIdentifier)) {
                bounds = nodeIdentifierToConnectedEdgeBounds.get(originalNodeIdentifier).iterator();
                while (bounds.hasNext()) {
                    Rectangle bounds2 = (Rectangle)bounds.next();
                    newBounds = newBounds.combine(bounds2);
                }
            }
            FeatureChange newFeatureChange = new FeatureChange(featureChange.getChangeType(), originalCompleteNode.withBoundsExtendedBy(newBounds));
            result.add(newFeatureChange);
        }
        return result;
    }

    @Override
    default public Set<FeatureChange> convert(Atlas atlas) {
        return this.generate(atlas);
    }

    default public Set<FeatureChange> generate(Atlas atlas) {
        Set<FeatureChange> result = AtlasChangeGenerator.expandNodeBounds(atlas, this.generateWithoutValidation(atlas));
        result.stream().forEach(featureChange -> featureChange.withAtlasContext(atlas));
        if (result.isEmpty()) {
            return result;
        }
        ChangeBuilder builder = new ChangeBuilder();
        result.forEach(builder::add);
        Change change = builder.get();
        this.validate(atlas, change);
        return change.changes().collect(Collectors.toSet());
    }

    public Set<FeatureChange> generateWithoutValidation(Atlas var1);

    default public String getName() {
        return this.getClass().getSimpleName();
    }

    default public void validate(Atlas source, Change change) {
        new ChangeAtlas(source, change).validate();
    }
}

