/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.builder.text;

import java.util.Map;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.geography.Location;
import org.openstreetmap.atlas.geography.PolyLine;
import org.openstreetmap.atlas.geography.Polygon;
import org.openstreetmap.atlas.geography.atlas.Atlas;
import org.openstreetmap.atlas.geography.atlas.AtlasMetaData;
import org.openstreetmap.atlas.geography.atlas.builder.AtlasSize;
import org.openstreetmap.atlas.geography.atlas.builder.RelationBean;
import org.openstreetmap.atlas.geography.atlas.items.Area;
import org.openstreetmap.atlas.geography.atlas.items.Edge;
import org.openstreetmap.atlas.geography.atlas.items.ItemType;
import org.openstreetmap.atlas.geography.atlas.items.Line;
import org.openstreetmap.atlas.geography.atlas.items.Node;
import org.openstreetmap.atlas.geography.atlas.items.Point;
import org.openstreetmap.atlas.geography.atlas.items.Relation;
import org.openstreetmap.atlas.geography.atlas.items.RelationMember;
import org.openstreetmap.atlas.geography.atlas.packed.PackedAtlas;
import org.openstreetmap.atlas.geography.atlas.packed.PackedAtlasBuilder;
import org.openstreetmap.atlas.geography.converters.PolyLineStringConverter;
import org.openstreetmap.atlas.geography.converters.PolygonStringConverter;
import org.openstreetmap.atlas.streaming.resource.LineWriter;
import org.openstreetmap.atlas.streaming.resource.Resource;
import org.openstreetmap.atlas.streaming.resource.WritableResource;
import org.openstreetmap.atlas.tags.Taggable;
import org.openstreetmap.atlas.utilities.collections.Maps;
import org.openstreetmap.atlas.utilities.collections.StringList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TextAtlasBuilder {
    private static final Logger logger = LoggerFactory.getLogger(TextAtlasBuilder.class);
    private static final String NODES_HEADER = "# Nodes";
    private static final String EDGES_HEADER = "# Edges";
    private static final String AREAS_HEADER = "# Areas";
    private static final String LINES_HEADER = "# Lines";
    private static final String POINTS_HEADER = "# Points";
    private static final String RELATIONS_HEADER = "# Relations";
    private static final String SEPARATOR = " && ";
    private static final String SECONDARY_SEPARATOR = " || ";
    private static final String TERTIARY_SEPARATOR = " -> ";
    private static final String SEPARATOR_REPLACEMENT = " ";

    public PackedAtlas read(Resource resource) {
        WriteMode mode = null;
        long numberOfNodes = 0L;
        long numberOfEdges = 0L;
        long numberOfAreas = 0L;
        long numberOfLines = 0L;
        long numberOfPoints = 0L;
        long numberOfRelations = 0L;
        for (String line : resource.lines()) {
            if (line.startsWith("#")) {
                mode = WriteMode.forHeader(line);
                continue;
            }
            if (mode == null) {
                throw new CoreException("Failed reading {}. Is that a text Atlas? Is it compressed?", resource);
            }
            switch (mode) {
                case NODE: {
                    ++numberOfNodes;
                    break;
                }
                case EDGE: {
                    ++numberOfEdges;
                    break;
                }
                case AREA: {
                    ++numberOfAreas;
                    break;
                }
                case LINE: {
                    ++numberOfLines;
                    break;
                }
                case POINT: {
                    ++numberOfPoints;
                    break;
                }
                case RELATION: {
                    ++numberOfRelations;
                    break;
                }
            }
        }
        AtlasSize size = new AtlasSize(numberOfEdges, numberOfNodes, numberOfAreas, numberOfLines, numberOfPoints, numberOfRelations);
        AtlasMetaData metaData = new AtlasMetaData(size, true, "unknown", "TextAtlas", "unknown", "unknown", Maps.hashMap(new String[0]));
        PackedAtlasBuilder builder = new PackedAtlasBuilder().withSizeEstimates(size).withMetaData(metaData).withName(resource.getName());
        for (String line : resource.lines()) {
            if (line.startsWith("#")) {
                mode = WriteMode.forHeader(line);
                continue;
            }
            switch (mode) {
                case NODE: {
                    this.parseNode(builder, line);
                    break;
                }
                case EDGE: {
                    this.parseEdge(builder, line);
                    break;
                }
                case AREA: {
                    this.parseArea(builder, line);
                    break;
                }
                case LINE: {
                    this.parseLine(builder, line);
                    break;
                }
                case POINT: {
                    this.parsePoint(builder, line);
                    break;
                }
                case RELATION: {
                    this.parseRelation(builder, line);
                    break;
                }
            }
        }
        return (PackedAtlas)builder.get();
    }

    public void write(Atlas atlas, WritableResource resource) {
        try (LineWriter writer = new LineWriter(resource);){
            block15: for (WriteMode mode : WriteMode.values()) {
                writer.writeLine(mode.getHeader());
                switch (mode) {
                    case NODE: {
                        atlas.nodes().forEach(item -> writer.writeLine(this.convertNode((Node)item)));
                        continue block15;
                    }
                    case EDGE: {
                        atlas.edges().forEach(item -> writer.writeLine(this.convertEdge((Edge)item)));
                        continue block15;
                    }
                    case AREA: {
                        atlas.areas().forEach(item -> writer.writeLine(this.convertArea((Area)item)));
                        continue block15;
                    }
                    case LINE: {
                        atlas.lines().forEach(item -> writer.writeLine(this.convertLine((Line)item)));
                        continue block15;
                    }
                    case POINT: {
                        atlas.points().forEach(item -> writer.writeLine(this.convertPoint((Point)item)));
                        continue block15;
                    }
                    case RELATION: {
                        atlas.relations().forEach(item -> writer.writeLine(this.convertRelation((Relation)item)));
                        continue block15;
                    }
                }
            }
        }
        catch (Exception e) {
            throw new CoreException("Unable to write Atlas to {}", resource, e);
        }
    }

    private String cleanupTags(String value) {
        if (value != null) {
            String result = value;
            if (value.contains(SEPARATOR)) {
                logger.warn("Tag {} contains {}. Replacing it with \"{}\"", new Object[]{value, SEPARATOR, SEPARATOR_REPLACEMENT});
                result = result.replace(SEPARATOR, SEPARATOR_REPLACEMENT);
            }
            if (value.contains(SECONDARY_SEPARATOR)) {
                logger.warn("Tag {} contains {}. Replacing it with \"{}\"", new Object[]{value, SECONDARY_SEPARATOR, SEPARATOR_REPLACEMENT});
                result = result.replace(SECONDARY_SEPARATOR, SEPARATOR_REPLACEMENT);
            }
            if (value.contains(TERTIARY_SEPARATOR)) {
                logger.warn("Tag {} contains {}. Replacing it with \"{}\"", new Object[]{value, TERTIARY_SEPARATOR, SEPARATOR_REPLACEMENT});
                result = result.replace(TERTIARY_SEPARATOR, SEPARATOR_REPLACEMENT);
            }
            if (value.contains(System.lineSeparator())) {
                logger.warn("Tag {} contains a new line. Removing it.", (Object)value);
                result = result.replace(System.lineSeparator(), "");
            }
            return result;
        }
        return value;
    }

    private String convertArea(Area item) {
        StringList list = new StringList();
        list.add(item.getIdentifier());
        list.add(item.asPolygon().toCompactString());
        list.add(this.convertTags(item));
        return list.join(SEPARATOR);
    }

    private String convertEdge(Edge item) {
        StringList list = new StringList();
        list.add(item.getIdentifier());
        list.add(item.asPolyLine().toCompactString());
        list.add(this.convertTags(item));
        return list.join(SEPARATOR);
    }

    private String convertLine(Line item) {
        StringList list = new StringList();
        list.add(item.getIdentifier());
        list.add(item.asPolyLine().toCompactString());
        list.add(this.convertTags(item));
        return list.join(SEPARATOR);
    }

    private String convertNode(Node item) {
        StringList list = new StringList();
        list.add(item.getIdentifier());
        list.add(item.getLocation().toCompactString());
        list.add(this.convertTags(item));
        return list.join(SEPARATOR);
    }

    private String convertPoint(Point item) {
        StringList list = new StringList();
        list.add(item.getIdentifier());
        list.add(item.getLocation().toCompactString());
        list.add(this.convertTags(item));
        return list.join(SEPARATOR);
    }

    private String convertRelation(Relation item) {
        StringList list = new StringList();
        list.add(item.getIdentifier());
        list.add(this.convertRelationBean(item));
        list.add(this.convertTags(item));
        return list.join(SEPARATOR);
    }

    private String convertRelationBean(Relation relation) {
        StringList bean = new StringList();
        for (RelationMember member : relation.members()) {
            StringList list = new StringList();
            list.add(member.getEntity().getIdentifier());
            list.add(member.getRole());
            ItemType type = ItemType.forEntity(member.getEntity());
            list.add(type.toShortString());
            bean.add(list.join(TERTIARY_SEPARATOR));
        }
        return bean.join(SECONDARY_SEPARATOR);
    }

    private String convertTags(Taggable taggable) {
        StringList tags = new StringList();
        for (Map.Entry<String, String> entry : taggable.getTags().entrySet()) {
            StringBuilder builder = new StringBuilder();
            builder.append(this.cleanupTags(entry.getKey()));
            builder.append(TERTIARY_SEPARATOR);
            builder.append(this.cleanupTags(entry.getValue()));
            tags.add(builder.toString());
        }
        return tags.join(SECONDARY_SEPARATOR);
    }

    private void parseArea(PackedAtlasBuilder builder, String line) {
        StringList split = StringList.split(line, SEPARATOR);
        long identifier = Long.parseLong(split.get(0));
        Polygon geometry = new PolygonStringConverter().convert(split.get(1));
        Map<String, String> tags = this.parseTags(split.get(2));
        builder.addArea(identifier, geometry, tags);
    }

    private void parseEdge(PackedAtlasBuilder builder, String line) {
        StringList split = StringList.split(line, SEPARATOR);
        long identifier = Long.parseLong(split.get(0));
        PolyLine geometry = new PolyLineStringConverter().convert(split.get(1));
        Map<String, String> tags = this.parseTags(split.get(2));
        builder.addEdge(identifier, geometry, tags);
    }

    private void parseLine(PackedAtlasBuilder builder, String line) {
        StringList split = StringList.split(line, SEPARATOR);
        long identifier = Long.parseLong(split.get(0));
        PolyLine geometry = new PolyLineStringConverter().convert(split.get(1));
        Map<String, String> tags = this.parseTags(split.get(2));
        builder.addLine(identifier, geometry, tags);
    }

    private void parseNode(PackedAtlasBuilder builder, String line) {
        StringList split = StringList.split(line, SEPARATOR);
        long identifier = Long.parseLong(split.get(0));
        Location geometry = Location.forString(split.get(1));
        Map<String, String> tags = this.parseTags(split.get(2));
        builder.addNode(identifier, geometry, tags);
    }

    private void parsePoint(PackedAtlasBuilder builder, String line) {
        StringList split = StringList.split(line, SEPARATOR);
        long identifier = Long.parseLong(split.get(0));
        Location geometry = Location.forString(split.get(1));
        Map<String, String> tags = this.parseTags(split.get(2));
        builder.addPoint(identifier, geometry, tags);
    }

    private void parseRelation(PackedAtlasBuilder builder, String line) {
        StringList split = StringList.split(line, SEPARATOR);
        long identifier = Long.parseLong(split.get(0));
        RelationBean structure = this.parseRelationBean(split.get(1));
        Map<String, String> tags = this.parseTags(split.get(2));
        builder.addRelation(identifier, identifier, structure, tags);
    }

    private RelationBean parseRelationBean(String value) {
        RelationBean bean = new RelationBean();
        StringList split = StringList.split(value, SECONDARY_SEPARATOR);
        for (String beanValue : split) {
            StringList valueSplit = StringList.split(beanValue, TERTIARY_SEPARATOR);
            long identifier = Long.parseLong(valueSplit.get(0));
            String role = valueSplit.get(1);
            ItemType itemType = ItemType.shortValueOf(valueSplit.get(2));
            bean.addItem(identifier, role, itemType);
        }
        return bean;
    }

    private Map<String, String> parseTags(String value) {
        try {
            Map<String, String> result = Maps.hashMap(new String[0]);
            StringList split = StringList.split(value, SECONDARY_SEPARATOR);
            for (String tag : split) {
                StringList tagSplit = StringList.split(tag, TERTIARY_SEPARATOR);
                if (tagSplit.size() == 2) {
                    result.put(tagSplit.get(0), tagSplit.get(1));
                }
                if (tagSplit.size() != 1) continue;
                result.put(tagSplit.get(0), "");
            }
            return result;
        }
        catch (Throwable error) {
            throw new CoreException("Unable to parse tags from \"{}\"", value, error);
        }
    }

    private static enum WriteMode {
        NODE("# Nodes"),
        EDGE("# Edges"),
        AREA("# Areas"),
        LINE("# Lines"),
        POINT("# Points"),
        RELATION("# Relations");

        private final String header;

        protected static WriteMode forHeader(String header) {
            switch (header) {
                case "# Nodes": {
                    return NODE;
                }
                case "# Edges": {
                    return EDGE;
                }
                case "# Areas": {
                    return AREA;
                }
                case "# Lines": {
                    return LINE;
                }
                case "# Points": {
                    return POINT;
                }
                case "# Relations": {
                    return RELATION;
                }
            }
            throw new CoreException("Invalid Header {}", header);
        }

        private WriteMode(String header) {
            this.header = header;
        }

        protected String getHeader() {
            return this.header;
        }
    }
}

