/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.builder.store;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.geography.Location;
import org.openstreetmap.atlas.geography.PolyLine;
import org.openstreetmap.atlas.geography.atlas.Atlas;
import org.openstreetmap.atlas.geography.atlas.builder.AtlasSize;
import org.openstreetmap.atlas.geography.atlas.builder.RelationBean;
import org.openstreetmap.atlas.geography.atlas.builder.store.AtlasPrimitiveArea;
import org.openstreetmap.atlas.geography.atlas.builder.store.AtlasPrimitiveLineItem;
import org.openstreetmap.atlas.geography.atlas.builder.store.AtlasPrimitiveLocationItem;
import org.openstreetmap.atlas.geography.atlas.builder.store.AtlasPrimitiveRelation;
import org.openstreetmap.atlas.geography.atlas.builder.store.TemporaryObjectStore;
import org.openstreetmap.atlas.geography.atlas.items.ItemType;
import org.openstreetmap.atlas.geography.atlas.packed.PackedAtlasBuilder;
import org.openstreetmap.atlas.utilities.collections.JoinedCollection;
import org.openstreetmap.atlas.utilities.collections.ParallelIterable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtlasPrimitiveObjectStore {
    private static final Logger logger = LoggerFactory.getLogger(AtlasPrimitiveObjectStore.class);
    private final Map<Long, AtlasPrimitiveLocationItem> nodes = new HashMap<Long, AtlasPrimitiveLocationItem>();
    private final Map<Long, AtlasPrimitiveLocationItem> points = new HashMap<Long, AtlasPrimitiveLocationItem>();
    private final Map<Long, AtlasPrimitiveLineItem> edges = new HashMap<Long, AtlasPrimitiveLineItem>();
    private final Map<Long, AtlasPrimitiveLineItem> lines = new HashMap<Long, AtlasPrimitiveLineItem>();
    private final Map<Long, AtlasPrimitiveArea> areas = new HashMap<Long, AtlasPrimitiveArea>();
    private final Map<Long, AtlasPrimitiveRelation> relations = new HashMap<Long, AtlasPrimitiveRelation>();

    public void addArea(AtlasPrimitiveArea area) {
        this.areas.put(area.getIdentifier(), area);
    }

    public void addEdge(AtlasPrimitiveLineItem edge) {
        this.edges.put(edge.getIdentifier(), edge);
    }

    public void addLine(AtlasPrimitiveLineItem line) {
        this.lines.put(line.getIdentifier(), line);
    }

    public void addNode(AtlasPrimitiveLocationItem node) {
        this.nodes.put(node.getIdentifier(), node);
    }

    public void addPoint(AtlasPrimitiveLocationItem point) {
        this.points.put(point.getIdentifier(), point);
    }

    public void addRelation(AtlasPrimitiveRelation relation) {
        this.relations.put(relation.getIdentifier(), relation);
    }

    public Atlas build() {
        Optional<TemporaryObjectStore> missingIdentifiers = this.checkDataIntegrity();
        missingIdentifiers.ifPresent(missingObjects -> {
            throw new CoreException("Data is not complete, still missing {} ", missingObjects.toDebugString());
        });
        logger.debug("Data is complete, starts to build atlas");
        PackedAtlasBuilder builder = new PackedAtlasBuilder().withSizeEstimates(new AtlasSize(this.getEdges().size(), this.getNodes().size(), this.getAreas().size(), this.getLines().size(), this.getPoints().size(), this.getRelations().size()));
        logger.debug("Building atlas nodes...");
        this.getNodes().values().forEach(node -> builder.addNode(node.getIdentifier(), node.getLocation(), node.getTags()));
        logger.debug("Building atlas points...");
        this.getPoints().values().forEach(point -> builder.addPoint(point.getIdentifier(), point.getLocation(), point.getTags()));
        logger.debug("Building atlas edges...");
        this.getEdges().values().forEach(edge -> builder.addEdge(edge.getIdentifier(), edge.getPolyLine(), edge.getTags()));
        logger.debug("Building atlas lines...");
        this.getLines().values().forEach(line -> builder.addLine(line.getIdentifier(), line.getPolyLine(), line.getTags()));
        logger.debug("Building atlas areas...");
        this.getAreas().values().forEach(area -> builder.addArea(area.getIdentifier(), area.getPolygon(), area.getTags()));
        logger.debug("Building atlas relations...");
        this.getRelations().values().forEach(relation -> builder.addRelation(relation.getIdentifier(), relation.getOsmIdentifier(), relation.getRelationBean(), relation.getTags()));
        return builder.get();
    }

    public Optional<TemporaryObjectStore> checkDataIntegrity() {
        logger.debug("Checking object store data integrity");
        TemporaryObjectStore missingObjects = new TemporaryObjectStore();
        this.getRelations().values().forEach(relation -> {
            RelationBean bean = relation.getRelationBean();
            ParallelIterable parallel = new ParallelIterable(bean.getMemberIdentifiers(), bean.getMemberTypes());
            block8: for (JoinedCollection relationMember : parallel) {
                long identifier = (Long)relationMember.get(0);
                ItemType type = (ItemType)((Object)((Object)relationMember.get(1)));
                switch (type) {
                    case NODE: {
                        if (this.nodes.containsKey(identifier)) continue block8;
                        missingObjects.addNode(identifier);
                        continue block8;
                    }
                    case EDGE: {
                        if (this.edges.containsKey(identifier)) continue block8;
                        missingObjects.addEdge(identifier);
                        continue block8;
                    }
                    case AREA: {
                        if (this.areas.containsKey(identifier)) continue block8;
                        missingObjects.addArea(identifier);
                        continue block8;
                    }
                    case LINE: {
                        if (this.lines.containsKey(identifier)) continue block8;
                        missingObjects.addLine(identifier);
                        continue block8;
                    }
                    case POINT: {
                        if (this.points.containsKey(identifier)) continue block8;
                        missingObjects.addPoint(identifier);
                        continue block8;
                    }
                    case RELATION: {
                        if (this.relations.containsKey(identifier)) continue block8;
                        missingObjects.addRelation(identifier);
                        continue block8;
                    }
                }
                throw new CoreException("Unknown type {}", new Object[]{type});
            }
        });
        HashSet locationOfNodes = new HashSet(this.nodes.size(), 1.0f);
        this.getNodes().values().forEach(node -> locationOfNodes.add(node.getLocation()));
        this.getEdges().values().forEach(edge -> {
            PolyLine shape = edge.getPolyLine();
            Location first = shape.first();
            Location last = shape.last();
            if (!locationOfNodes.contains(first)) {
                missingObjects.addLocation(first);
            }
            if (!locationOfNodes.contains(last)) {
                missingObjects.addLocation(last);
            }
        });
        return missingObjects.isEmpty() ? Optional.empty() : Optional.of(missingObjects);
    }

    public Map<Long, AtlasPrimitiveArea> getAreas() {
        return this.areas;
    }

    public Map<Long, AtlasPrimitiveLineItem> getEdges() {
        return this.edges;
    }

    public Map<Long, AtlasPrimitiveLineItem> getLines() {
        return this.lines;
    }

    public Map<Long, AtlasPrimitiveLocationItem> getNodes() {
        return this.nodes;
    }

    public Map<Long, AtlasPrimitiveLocationItem> getPoints() {
        return this.points;
    }

    public Map<Long, AtlasPrimitiveRelation> getRelations() {
        return this.relations;
    }

    public String summary() {
        return "The store has " + this.nodes.size() + " nodes, " + this.points.size() + " points, " + this.edges.size() + " edges, " + this.lines.size() + " lines, " + this.areas.size() + " areas, " + this.relations.size() + " relations";
    }
}

