/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.builder;

import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.geography.atlas.items.ItemType;

public class RelationBean
extends AbstractCollection<RelationBeanItem>
implements Serializable {
    private static final long serialVersionUID = 8511830231633569713L;
    private final List<Long> memberIdentifiers = new ArrayList<Long>();
    private final List<String> memberRoles = new ArrayList<String>();
    private final List<ItemType> memberTypes = new ArrayList<ItemType>();
    private final Set<RelationBeanItem> explicitlyExcluded = new HashSet<RelationBeanItem>();

    public static RelationBean fromSet(Set<RelationBeanItem> set) {
        RelationBean bean = new RelationBean();
        for (RelationBeanItem item : set) {
            bean.addItem(item);
        }
        return bean;
    }

    @Override
    public boolean add(RelationBeanItem item) {
        this.addItem(item);
        return true;
    }

    public void addItem(Long identifier, String role, ItemType itemType) {
        this.memberIdentifiers.add(identifier);
        this.memberRoles.add(role);
        this.memberTypes.add(itemType);
    }

    public void addItem(RelationBeanItem item) {
        this.addItem(item.getIdentifier(), item.getRole(), item.getType());
    }

    public void addItemExplicitlyExcluded(Long identifier, String role, ItemType itemType) {
        this.addItemExplicitlyExcluded(new RelationBeanItem(identifier, role, itemType));
    }

    public void addItemExplicitlyExcluded(RelationBeanItem item) {
        this.explicitlyExcluded.add(item);
    }

    public List<RelationBeanItem> asList() {
        ArrayList<RelationBeanItem> result = new ArrayList<RelationBeanItem>();
        for (int index = 0; index < this.size(); ++index) {
            result.add(new RelationBeanItem(this.memberIdentifiers.get(index), this.memberRoles.get(index), this.memberTypes.get(index)));
        }
        return result;
    }

    public Map<RelationBeanItem, Integer> asMap() {
        HashMap<RelationBeanItem, Integer> result = new HashMap<RelationBeanItem, Integer>();
        for (RelationBeanItem beanItem : this) {
            if (result.containsKey(beanItem)) {
                int count = (Integer)result.get(beanItem);
                result.put(beanItem, ++count);
                continue;
            }
            result.put(beanItem, 1);
        }
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof RelationBean) {
            RelationBean that = (RelationBean)other;
            return this.asMap().equals(that.asMap());
        }
        return false;
    }

    public boolean equalsIncludingExplicitlyExcluded(Object other) {
        if (other instanceof RelationBean) {
            return other instanceof RelationBean && this.equals(other) && this.explicitlyExcluded.equals(((RelationBean)other).explicitlyExcluded);
        }
        return false;
    }

    public Set<RelationBeanItem> getExplicitlyExcluded() {
        return this.explicitlyExcluded;
    }

    public Optional<RelationBeanItem> getItemFor(long identifier, ItemType type) {
        for (int index = 0; index < this.memberIdentifiers.size(); ++index) {
            if (this.memberIdentifiers.get(index) != identifier || this.memberTypes.get(index) != type) continue;
            return Optional.of(this.getItemFor(index));
        }
        return Optional.empty();
    }

    public Optional<RelationBeanItem> getItemFor(long identifier, String role, ItemType type) {
        for (int index = 0; index < this.memberIdentifiers.size(); ++index) {
            if (this.memberIdentifiers.get(index) != identifier || !role.equals(this.memberRoles.get(index)) || this.memberTypes.get(index) != type) continue;
            return Optional.of(this.getItemFor(index));
        }
        return Optional.empty();
    }

    public List<Long> getMemberIdentifiers() {
        return this.memberIdentifiers;
    }

    public List<String> getMemberRoles() {
        return this.memberRoles;
    }

    public List<ItemType> getMemberTypes() {
        return this.memberTypes;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.getMemberIdentifiers(), this.getMemberRoles(), this.getMemberTypes());
    }

    @Override
    public boolean isEmpty() {
        return this.memberIdentifiers.isEmpty();
    }

    @Override
    public Iterator<RelationBeanItem> iterator() {
        ArrayList<RelationBeanItem> result = new ArrayList<RelationBeanItem>();
        for (int index = 0; index < this.memberIdentifiers.size(); ++index) {
            result.add(new RelationBeanItem(this.memberIdentifiers.get(index), this.memberRoles.get(index), this.memberTypes.get(index)));
        }
        return result.iterator();
    }

    public RelationBean merge(RelationBean other) {
        RelationBean result = new RelationBean();
        for (RelationBeanItem leftItem : this) {
            if (other.isExplicitlyExcluded(leftItem)) continue;
            result.addItem(leftItem);
        }
        for (RelationBeanItem rightItem : other) {
            Optional<RelationBeanItem> existingLeftItem = this.getItemFor(rightItem.getIdentifier(), rightItem.getType());
            if (existingLeftItem.isPresent() && existingLeftItem.get().getRole().equals(rightItem.getRole()) || this.isExplicitlyExcluded(rightItem)) continue;
            result.addItem(rightItem);
        }
        this.explicitlyExcluded.forEach(result::addItemExplicitlyExcluded);
        other.explicitlyExcluded.forEach(result::addItemExplicitlyExcluded);
        return result;
    }

    @Override
    public int size() {
        return this.memberIdentifiers.size();
    }

    @Override
    public String toString() {
        return "RelationBean [memberIdentifiers=" + this.memberIdentifiers + ", memberRoles=" + this.memberRoles + ", memberTypes=" + this.memberTypes + "]";
    }

    private RelationBeanItem getItemFor(int index) {
        if (index < 0 || index > this.memberIdentifiers.size()) {
            throw new CoreException("Invalid index {}", index);
        }
        return new RelationBeanItem(this.memberIdentifiers.get(index), this.memberRoles.get(index), this.memberTypes.get(index));
    }

    private boolean isExplicitlyExcluded(RelationBeanItem relationBeanItem) {
        return this.explicitlyExcluded.contains(relationBeanItem);
    }

    public static class RelationBeanItem
    implements Serializable {
        private static final long serialVersionUID = 441160361936498695L;
        private final Long identifier;
        private final String role;
        private final ItemType type;

        public RelationBeanItem(Long identifier, String role, ItemType type) {
            this.identifier = identifier;
            this.role = role;
            this.type = type;
        }

        public boolean equals(Object other) {
            if (other instanceof RelationBeanItem) {
                RelationBeanItem that = (RelationBeanItem)other;
                return this.getIdentifier().equals(that.getIdentifier()) && this.getRole().equals(that.getRole()) && this.getType() == that.getType();
            }
            return false;
        }

        public Long getIdentifier() {
            return this.identifier;
        }

        public String getRole() {
            return this.role;
        }

        public ItemType getType() {
            return this.type;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.identifier, this.role, this.type});
        }

        public String toString() {
            return (Object)((Object)this.type) + ", " + this.identifier + ", " + this.role;
        }
    }
}

