/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import org.openstreetmap.atlas.geography.atlas.Atlas;
import org.openstreetmap.atlas.geography.atlas.items.AtlasEntity;
import org.openstreetmap.atlas.geography.atlas.multi.MultiAtlas;
import org.openstreetmap.atlas.geography.atlas.packed.PackedAtlas;
import org.openstreetmap.atlas.geography.atlas.sub.AtlasCutType;
import org.openstreetmap.atlas.streaming.compression.Decompressor;
import org.openstreetmap.atlas.streaming.resource.File;
import org.openstreetmap.atlas.streaming.resource.FileSuffix;
import org.openstreetmap.atlas.streaming.resource.Resource;
import org.openstreetmap.atlas.utilities.collections.Iterables;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtlasResourceLoader {
    public static final Predicate<Resource> IS_ATLAS = FileSuffix.resourceFilter(FileSuffix.ATLAS).or(FileSuffix.resourceFilter(FileSuffix.ATLAS, FileSuffix.GZIP));
    private static final Logger logger = LoggerFactory.getLogger(AtlasResourceLoader.class);
    private final Predicate<Resource> alwaysTrueAtlasFilter = resource -> true;
    private Predicate<Resource> resourceFilter = resource -> true;
    private Predicate<AtlasEntity> atlasEntityFilter = null;
    private String multiAtlasName;
    private boolean filterForAtlasFileExtension = true;

    public Atlas load(Iterable<? extends Resource> input) {
        Predicate<Resource> toggleableAtlasFileFilter = this.filterForAtlasFileExtension ? IS_ATLAS : this.alwaysTrueAtlasFilter;
        List<Resource> resources = Iterables.stream(input).flatMap(this::resourcesIn).filter(toggleableAtlasFileFilter).filter(this.resourceFilter).collectToList();
        long size = resources.size();
        if (size == 1L) {
            PackedAtlas result = PackedAtlas.load(resources.get(0));
            if (this.atlasEntityFilter != null) {
                Optional<Atlas> subAtlas = result.subAtlas(this.atlasEntityFilter, AtlasCutType.SOFT_CUT);
                result = subAtlas.isPresent() ? subAtlas.get() : null;
            }
            return result;
        }
        if (size > 1L) {
            MultiAtlas result;
            MultiAtlas multiAtlas = result = this.atlasEntityFilter == null ? MultiAtlas.loadFromPackedAtlas(resources) : MultiAtlas.loadFromPackedAtlas(resources, this.atlasEntityFilter);
            if (this.multiAtlasName != null) {
                result.setName(this.multiAtlasName);
            }
            return result;
        }
        return null;
    }

    public Atlas load(Resource ... resource) {
        return this.load(Iterables.from(resource));
    }

    public void setAtlasEntityFilter(Predicate<AtlasEntity> filter) {
        this.atlasEntityFilter = filter;
    }

    public void setResourceFilter(Predicate<Resource> filter) {
        this.resourceFilter = filter;
    }

    public AtlasResourceLoader withAtlasEntityFilter(Predicate<AtlasEntity> filter) {
        this.setAtlasEntityFilter(filter);
        return this;
    }

    public AtlasResourceLoader withAtlasFileExtensionFilterSetTo(boolean value) {
        this.filterForAtlasFileExtension = value;
        return this;
    }

    public AtlasResourceLoader withMultiAtlasName(String multiAtlasName) {
        this.multiAtlasName = multiAtlasName;
        return this;
    }

    public AtlasResourceLoader withResourceFilter(Predicate<Resource> filter) {
        this.setResourceFilter(filter);
        return this;
    }

    private List<Resource> resourcesIn(Resource resource) {
        ArrayList<Resource> result = new ArrayList<Resource>();
        if (resource != null) {
            if (resource instanceof File) {
                result.addAll(new AtlasFileSelector().select((File)resource));
            } else {
                result.add(resource);
            }
        }
        return result;
    }

    protected static final class AtlasFileSelector {
        protected AtlasFileSelector() {
        }

        public List<Resource> select(File file) {
            ArrayList<Resource> result = new ArrayList<Resource>();
            if (file != null && file.exists()) {
                file.listFilesRecursively().forEach(child -> {
                    if (child.isGzipped()) {
                        child.setDecompressor(Decompressor.GZIP);
                    }
                    result.add((Resource)child);
                });
            } else {
                logger.warn("File {} does not exist.", (Object)file);
            }
            return result;
        }
    }
}

