/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas;

import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.geography.GeometricSurface;
import org.openstreetmap.atlas.geography.Located;
import org.openstreetmap.atlas.geography.Location;
import org.openstreetmap.atlas.geography.PolyLine;
import org.openstreetmap.atlas.geography.Polygon;
import org.openstreetmap.atlas.geography.Rectangle;
import org.openstreetmap.atlas.geography.atlas.Atlas;
import org.openstreetmap.atlas.geography.atlas.BareAtlas;
import org.openstreetmap.atlas.geography.atlas.items.Area;
import org.openstreetmap.atlas.geography.atlas.items.AtlasEntity;
import org.openstreetmap.atlas.geography.atlas.items.Edge;
import org.openstreetmap.atlas.geography.atlas.items.ItemType;
import org.openstreetmap.atlas.geography.atlas.items.Line;
import org.openstreetmap.atlas.geography.atlas.items.Node;
import org.openstreetmap.atlas.geography.atlas.items.Point;
import org.openstreetmap.atlas.geography.atlas.items.Relation;
import org.openstreetmap.atlas.geography.atlas.packed.PackedAtlas;
import org.openstreetmap.atlas.geography.atlas.pbf.AtlasLoadingOption;
import org.openstreetmap.atlas.geography.atlas.raw.creation.RawAtlasGenerator;
import org.openstreetmap.atlas.geography.atlas.raw.sectioning.WaySectionProcessor;
import org.openstreetmap.atlas.geography.atlas.raw.slicing.RawAtlasCountrySlicer;
import org.openstreetmap.atlas.geography.boundary.CountryBoundaryMap;
import org.openstreetmap.atlas.geography.index.PackedSpatialIndex;
import org.openstreetmap.atlas.geography.index.RTree;
import org.openstreetmap.atlas.geography.index.SpatialIndex;
import org.openstreetmap.atlas.streaming.resource.Resource;
import org.openstreetmap.atlas.streaming.resource.WritableResource;
import org.openstreetmap.atlas.utilities.collections.Iterables;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAtlas
extends BareAtlas {
    private static final long serialVersionUID = -1408393006815178776L;
    private static final Logger logger = LoggerFactory.getLogger(AbstractAtlas.class);
    protected static final long DEFAULT_NUMBER_OF_ITEMS = 1024L;
    protected static final int HASH_MODULO_RATIO = 10;
    private static final Object NODE_LOCK = new Object();
    private static final Object EDGE_LOCK = new Object();
    private static final Object AREA_LOCK = new Object();
    private static final Object LINE_LOCK = new Object();
    private static final Object POINT_LOCK = new Object();
    private static final Object RELATION_LOCK = new Object();
    private volatile transient SpatialIndex<Node> nodeSpatialIndex;
    private volatile transient SpatialIndex<Edge> edgeSpatialIndex;
    private volatile transient SpatialIndex<Area> areaSpatialIndex;
    private volatile transient SpatialIndex<Line> lineSpatialIndex;
    private volatile transient SpatialIndex<Point> pointSpatialIndex;
    private volatile transient SpatialIndex<Relation> relationSpatialIndex;

    public static Atlas createAndSaveOsmPbf(Resource osmPbf, WritableResource atlasResource) {
        Atlas atlas = new RawAtlasGenerator(osmPbf).build();
        atlas = new WaySectionProcessor(atlas, AtlasLoadingOption.createOptionWithNoSlicing()).run();
        atlas.save(atlasResource);
        return atlas;
    }

    public static Atlas createAndSaveOsmPbfWithSlicing(Resource osmPbf, WritableResource atlasResource, CountryBoundaryMap boundaryMap) {
        Atlas atlas = new RawAtlasGenerator(osmPbf).build();
        AtlasLoadingOption loadingOption = AtlasLoadingOption.createOptionWithAllEnabled(boundaryMap);
        loadingOption.setAdditionalCountryCodes(boundaryMap.getLoadedCountries());
        atlas = new RawAtlasCountrySlicer(loadingOption).slice(atlas);
        atlas = new WaySectionProcessor(atlas, AtlasLoadingOption.createOptionWithAllEnabled(boundaryMap)).run();
        atlas.save(atlasResource);
        return atlas;
    }

    public static Atlas forOsmPbf(Resource resource) {
        Atlas atlas = new RawAtlasGenerator(resource).build();
        atlas = new WaySectionProcessor(atlas, AtlasLoadingOption.createOptionWithNoSlicing()).run();
        return atlas;
    }

    @Override
    public Iterable<Area> areasCovering(Location location) {
        return Iterables.stream(this.getAreaSpatialIndex().get(location.bounds())).filter(area -> {
            Polygon areaPolygon = area.asPolygon();
            return areaPolygon.fullyGeometricallyEncloses(location);
        });
    }

    @Override
    public Iterable<Area> areasCovering(Location location, Predicate<Area> matcher) {
        return Iterables.filter(this.areasCovering(location), matcher);
    }

    @Override
    public Iterable<Area> areasIntersecting(GeometricSurface surface) {
        return Iterables.stream(this.getAreaSpatialIndex().get(surface.bounds())).filter(area -> {
            Polygon areaPolygon = area.asPolygon();
            return surface.overlaps(areaPolygon);
        });
    }

    @Override
    public Iterable<Area> areasIntersecting(GeometricSurface surface, Predicate<Area> matcher) {
        return Iterables.filterTranslate(this.areasIntersecting(surface), item -> item, matcher);
    }

    @Override
    public Iterable<Area> areasWithin(GeometricSurface surface) {
        return Iterables.stream(this.getAreaSpatialIndex().get(surface.bounds())).filter(area -> {
            Polygon areaPolygon = area.asPolygon();
            return surface.fullyGeometricallyEncloses(areaPolygon);
        });
    }

    @Override
    public Iterable<Edge> edgesContaining(Location location) {
        return Iterables.stream(this.getEdgeSpatialIndex().get(location.bounds())).filter(edge -> {
            PolyLine polyline = edge.asPolyLine();
            return polyline.contains(location);
        });
    }

    @Override
    public Iterable<Edge> edgesContaining(Location location, Predicate<Edge> matcher) {
        return Iterables.filter(this.edgesContaining(location), matcher);
    }

    @Override
    public Iterable<Edge> edgesIntersecting(GeometricSurface surface) {
        return Iterables.stream(this.getEdgeSpatialIndex().get(surface.bounds())).filter(edge -> {
            PolyLine polyline = edge.asPolyLine();
            return surface.overlaps(polyline);
        });
    }

    @Override
    public Iterable<Edge> edgesIntersecting(GeometricSurface surface, Predicate<Edge> matcher) {
        return Iterables.filter(this.edgesIntersecting(surface), matcher);
    }

    @Override
    public Iterable<Edge> edgesWithin(GeometricSurface surface) {
        return Iterables.stream(this.getEdgeSpatialIndex().get(surface.bounds())).filter(edge -> {
            PolyLine polyline = edge.asPolyLine();
            return surface.fullyGeometricallyEncloses(polyline);
        });
    }

    public SpatialIndex<Area> getAreaSpatialIndex() {
        this.buildAreaSpatialIndexIfNecessary();
        return this.areaSpatialIndex;
    }

    public SpatialIndex<Edge> getEdgeSpatialIndex() {
        this.buildEdgeSpatialIndexIfNecessary();
        return this.edgeSpatialIndex;
    }

    public SpatialIndex<Line> getLineSpatialIndex() {
        this.buildLineSpatialIndexIfNecessary();
        return this.lineSpatialIndex;
    }

    public SpatialIndex<Node> getNodeSpatialIndex() {
        this.buildNodeSpatialIndexIfNecessary();
        return this.nodeSpatialIndex;
    }

    public SpatialIndex<Point> getPointSpatialIndex() {
        this.buildPointSpatialIndexIfNecessary();
        return this.pointSpatialIndex;
    }

    public SpatialIndex<Relation> getRelationSpatialIndex() {
        this.buildRelationSpatialIndexIfNecessary();
        return this.relationSpatialIndex;
    }

    @Override
    public Iterable<Line> linesContaining(Location location) {
        return Iterables.stream(this.getLineSpatialIndex().get(location.bounds())).filter(line -> {
            PolyLine polyline = line.asPolyLine();
            return polyline.contains(location);
        });
    }

    @Override
    public Iterable<Line> linesContaining(Location location, Predicate<Line> matcher) {
        return Iterables.filter(this.linesContaining(location), matcher);
    }

    @Override
    public Iterable<Line> linesIntersecting(GeometricSurface surface) {
        return Iterables.stream(this.getLineSpatialIndex().get(surface.bounds())).filter(line -> {
            PolyLine polyline = line.asPolyLine();
            return surface.overlaps(polyline);
        });
    }

    @Override
    public Iterable<Line> linesIntersecting(GeometricSurface surface, Predicate<Line> matcher) {
        return Iterables.filter(this.linesIntersecting(surface), matcher);
    }

    @Override
    public Iterable<Line> linesWithin(GeometricSurface surface) {
        return Iterables.stream(this.getLineSpatialIndex().get(surface.bounds())).filter(line -> {
            PolyLine polyline = line.asPolyLine();
            return surface.fullyGeometricallyEncloses(polyline);
        });
    }

    @Override
    public Iterable<Node> nodesAt(Location location) {
        return this.getNodeSpatialIndex().get(location.bounds());
    }

    @Override
    public Iterable<Node> nodesWithin(GeometricSurface surface) {
        Iterable<Node> nodes = this.getNodeSpatialIndex().get(surface.bounds());
        if (surface instanceof Rectangle) {
            return nodes;
        }
        return Iterables.filter(nodes, node -> surface.fullyGeometricallyEncloses(node.getLocation()));
    }

    @Override
    public Iterable<Node> nodesWithin(GeometricSurface surface, Predicate<Node> matcher) {
        return Iterables.filter(this.nodesWithin(surface), matcher);
    }

    @Override
    public Iterable<Point> pointsAt(Location location) {
        return this.getPointSpatialIndex().get(location.bounds());
    }

    @Override
    public Iterable<Point> pointsWithin(GeometricSurface surface) {
        Iterable<Point> points = this.getPointSpatialIndex().get(surface.bounds());
        if (surface instanceof Rectangle) {
            return points;
        }
        return Iterables.filter(points, point -> surface.fullyGeometricallyEncloses(point.getLocation()));
    }

    @Override
    public Iterable<Point> pointsWithin(GeometricSurface surface, Predicate<Point> matcher) {
        return Iterables.filterTranslate(this.pointsWithin(surface), item -> item, matcher);
    }

    @Override
    public Iterable<Relation> relationsWithEntitiesIntersecting(GeometricSurface surface) {
        Iterable<Relation> relations = this.getRelationSpatialIndex().get(surface.bounds());
        return Iterables.filter(relations, relation -> relation.intersects(surface));
    }

    @Override
    public Iterable<Relation> relationsWithEntitiesIntersecting(GeometricSurface surface, Predicate<Relation> matcher) {
        return Iterables.filter(this.relationsWithEntitiesIntersecting(surface), matcher);
    }

    @Override
    public Iterable<Relation> relationsWithEntitiesWithin(GeometricSurface surface) {
        Iterable<Relation> relations = this.getRelationSpatialIndex().get(surface.bounds());
        return Iterables.filter(relations, relation -> relation.within(surface));
    }

    @Override
    public void save(WritableResource writableResource) {
        throw new CoreException("{} does not support saving. Consider using {} instead. A {} can be had using Atlas.cloneToPackedAtlas()", this.getClass().getName(), PackedAtlas.class.getName(), PackedAtlas.class.getName());
    }

    protected void buildAreaSpatialIndexIfNecessary() {
        this.buildSpatialIndexIfNecessary(AREA_LOCK, ItemType.AREA, this::newAreaSpatialIndex, () -> this.areaSpatialIndex, newSpatialIndex -> {
            this.areaSpatialIndex = newSpatialIndex;
        });
    }

    protected void buildEdgeSpatialIndexIfNecessary() {
        this.buildSpatialIndexIfNecessary(EDGE_LOCK, ItemType.EDGE, this::newEdgeSpatialIndex, () -> this.edgeSpatialIndex, newSpatialIndex -> {
            this.edgeSpatialIndex = newSpatialIndex;
        });
    }

    protected void buildLineSpatialIndexIfNecessary() {
        this.buildSpatialIndexIfNecessary(LINE_LOCK, ItemType.LINE, this::newLineSpatialIndex, () -> this.lineSpatialIndex, newSpatialIndex -> {
            this.lineSpatialIndex = newSpatialIndex;
        });
    }

    protected void buildNodeSpatialIndexIfNecessary() {
        this.buildSpatialIndexIfNecessary(NODE_LOCK, ItemType.NODE, this::newNodeSpatialIndex, () -> this.nodeSpatialIndex, newSpatialIndex -> {
            this.nodeSpatialIndex = newSpatialIndex;
        });
    }

    protected void buildPointSpatialIndexIfNecessary() {
        this.buildSpatialIndexIfNecessary(POINT_LOCK, ItemType.POINT, this::newPointSpatialIndex, () -> this.pointSpatialIndex, newSpatialIndex -> {
            this.pointSpatialIndex = newSpatialIndex;
        });
    }

    protected void buildRelationSpatialIndexIfNecessary() {
        this.buildSpatialIndexIfNecessary(RELATION_LOCK, ItemType.RELATION, this::newRelationSpatialIndex, () -> this.relationSpatialIndex, newSpatialIndex -> {
            this.relationSpatialIndex = newSpatialIndex;
        });
    }

    protected SpatialIndex<Area> getAsNewAreaSpatialIndex() {
        if (this.areaSpatialIndex == null) {
            this.areaSpatialIndex = this.newAreaSpatialIndex();
        }
        return this.areaSpatialIndex;
    }

    protected SpatialIndex<Edge> getAsNewEdgeSpatialIndex() {
        if (this.edgeSpatialIndex == null) {
            this.edgeSpatialIndex = this.newEdgeSpatialIndex();
        }
        return this.edgeSpatialIndex;
    }

    protected SpatialIndex<Line> getAsNewLineSpatialIndex() {
        if (this.lineSpatialIndex == null) {
            this.lineSpatialIndex = this.newLineSpatialIndex();
        }
        return this.lineSpatialIndex;
    }

    protected SpatialIndex<Node> getAsNewNodeSpatialIndex() {
        if (this.nodeSpatialIndex == null) {
            this.nodeSpatialIndex = this.newNodeSpatialIndex();
        }
        return this.nodeSpatialIndex;
    }

    protected SpatialIndex<Point> getAsNewPointSpatialIndex() {
        if (this.pointSpatialIndex == null) {
            this.pointSpatialIndex = this.newPointSpatialIndex();
        }
        return this.pointSpatialIndex;
    }

    protected SpatialIndex<Relation> getAsNewRelationSpatialIndex() {
        if (this.relationSpatialIndex == null) {
            this.relationSpatialIndex = this.newRelationSpatialIndex();
        }
        return this.relationSpatialIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <M extends AtlasEntity> void buildSpatialIndexIfNecessary(Object lock, ItemType type, Supplier<SpatialIndex<M>> newIndexSupplier, Supplier<SpatialIndex<M>> globalIndexSupplier, Consumer<SpatialIndex<M>> globalIndexConsumer) {
        SpatialIndex<M> localIndex = globalIndexSupplier.get();
        if (localIndex == null) {
            Object object = lock;
            synchronized (object) {
                localIndex = globalIndexSupplier.get();
                if (localIndex == null) {
                    logger.info("Re-Building {} Spatial Index...", (Object)type);
                    SpatialIndex<M> temporaryIndex = newIndexSupplier.get();
                    Iterables.stream(this.entities(type, type.getMemberClass())).map(entity -> entity).forEach(temporaryIndex::add);
                    globalIndexConsumer.accept(temporaryIndex);
                }
            }
        }
    }

    private SpatialIndex<Area> newAreaSpatialIndex() {
        return this.newSpatialIndex((item, bounds) -> bounds.overlaps(item.asPolygon()), this::area);
    }

    private SpatialIndex<Edge> newEdgeSpatialIndex() {
        return this.newSpatialIndex((item, bounds) -> bounds.overlaps(item.asPolyLine()), this::edge);
    }

    private SpatialIndex<Line> newLineSpatialIndex() {
        return this.newSpatialIndex((item, bounds) -> bounds.overlaps(item.asPolyLine()), this::line);
    }

    private SpatialIndex<Node> newNodeSpatialIndex() {
        return this.newSpatialIndex((item, bounds) -> bounds.fullyGeometricallyEncloses((Located)item), this::node);
    }

    private SpatialIndex<Point> newPointSpatialIndex() {
        return this.newSpatialIndex((item, bounds) -> bounds.fullyGeometricallyEncloses((Located)item), this::point);
    }

    private SpatialIndex<Relation> newRelationSpatialIndex() {
        return this.newSpatialIndex((item, bounds) -> item.intersects((GeometricSurface)bounds), this::relation);
    }

    private <M extends AtlasEntity> SpatialIndex<M> newSpatialIndex(final BiFunction<M, Rectangle, Boolean> memberValidForBounds, final Function<Long, M> memberFromIdentifier) {
        return new PackedSpatialIndex<M, Long>(new RTree()){
            private static final long serialVersionUID = 6569644967280192054L;

            @Override
            protected Long compress(M item) {
                return item.getIdentifier();
            }

            @Override
            protected boolean isValid(M item, Rectangle bounds) {
                return (Boolean)memberValidForBounds.apply(item, bounds);
            }

            @Override
            protected M restore(Long packed) {
                return (AtlasEntity)memberFromIdentifier.apply(packed);
            }
        };
    }
}

